#!/bin/sh
#
# shell script to pull new code from xorp's cvs repository
#
# NOTE: you will need the subversion supplied perl script svn_load_dirs.pl
# in your exec path.  Both this file and svn_load_dirs.pl are checked into
# the vendor branch.


###################################################
# Get the specified xorp version.
# If no date is specified, get the latest version.
###################################################
SVN_URL=http://suva.vyatta.com/svn/repos/vyatta/vendor/xorp

export CVSROOT=:pserver:xorpcvs:@cvs.xorp.org:/cvs
PACKAGE=xorp

DATE="$1"
if [ -z $DATE]
then
	DATE=`date --utc +%y%m%d%k%M`
	CO_DIR=`echo $DATE|tr -d -c "[0-9]"`
	cvs co -d $CO_DIR $PACKAGE
else
	CO_DIR=`echo $DATE|tr -d -c "[0-9]"`
	cvs co -d $CO_DIR -D $DATE $PACKAGE
fi

###################################################
# Now remove files that we will derive in our build.
###################################################
(cd $CO_DIR; rm -f configure config.sub config.guess ltmain.sh libtool)

find $CO_DIR \( \
      -name CVS \
   -o -name configure \
   -o -name ltmain.sh \
   -o -name libtool \
   -o -name config.h.in \
   -o -name MakefileRootCheck.in \
 \) \
 -exec rm -rf {} \;>&/dev/null

# skip xorp/cli/libtecla/Makefile.in
rm -f `find $CO_DIR -name Makefile.in|grep -v libtecla`

###################################################
# Now do the merge.
###################################################
./svn_load_dirs.pl $SVN_URL . $CO_DIR

svn log http://suva.vyatta.com/svn/repos/vyatta/vendor/xorp>svn.log

echo
echo " Now print svn.log"
echo
echo " svn log http://suva.vyatta/com/svn/repos/vyatta/vendor/xorp .|more"
echo
echo "Look for the second newest revision with the entry:"
echo
echo " Load...into vendor/xorp."
echo
echo "Say this is revision XXXX.  Now use:"
echo
echo " svn merge -rXXXX:HEAD http://suva.vyatta.com/svn/repos/vyatta/vendor/xorp ."
echo
echo "The dot in the above command is important."
echo "You can then remove directory $CO_DIR if you like"
