#include <fcntl.h>
#include <stdio.h>
#include <errno.h>
#include <dirent.h>

#include <sys/types.h>
#include <unistd.h>

#include <iostream>
#include <string>
#include <vector>

#include <string>
#include "vsh/common/vsh_common.hh"
#include "vsh/common/vsh_execute.hh"
#include "vsh/common/vsh_str_proc.hh"

using namespace std;

void 
process_command(VecColl &coll, string &root);
void
write_to_config(VecColl &coll, bool multi, DataType type, string &def, string &root);



/**
 *
 *
 **/
void
usage()
{
  printf("template_convert -t [template_to_convert] -r [root_to_new_config]\n");
}


/**
 *
 *
 **/
int 
main(int argc, char* const argv[])
{
  bool debug = false;
  string tmplt, root;

  int ch;
  while ((ch = getopt(argc, argv, "t:r:d")) != -1) {
    switch (ch) {
    case 'd':
      debug = true;
      break;
    case 't':
      tmplt = optarg;
      break;
    case 'r':
      root = optarg;
      break;
    default:
      usage();
      return -1;
    }
  }

  if (tmplt.empty()) {
    usage();
    return -1;
  }

  //strip off first arg, then mash up directory 
  if (debug) {
    cout << "starting template conversion: " << tmplt << ", will write to: " << root << endl;
  }

  VecColl coll;
  //  string file_path = "etc/templates/" + tmplt;
  string file_path = "/home/mike/rbays4/xorp/xorp/etc/templates/" + tmplt;
  FILE *fd = fopen(file_path.c_str(), "r");
  if (fd) {
    char line[256];
    while (fgets(line, 255, fd) != NULL) {
      coll.push_back(line);
    }
    fclose(fd);

    process_command(coll, root);
  }
  else {
    cout << "file not found, nothing processed: " << file_path << endl;
    exit(0);
  }
  exit(0);
}


//could make this recursive, but seems to be more work to do so...
void 
process_command(VecColl &coll, string &root)
{
  VecColl path_coll;

  VecIter iter = coll.begin();
  while (iter != coll.end()) {
    StrProc str_proc(*iter, " ");

    if ((iter->find("{") != string::npos) && (iter->find("}") != string::npos)) {
      //ignore this condition
    }
    else {
      if (iter->find("{") != string::npos) {
	cout << "process_command: " << str_proc.get(0) << endl;
	path_coll.push_back(str_proc.get(0));
      }
      if (iter->find("}") != string::npos) {
	cout << "pop" << endl;
	path_coll.pop_back();
      }
    }
    
    if (iter->find("%") != string::npos) {
      cout << "DONE: note only processing a single depth for now..." << endl;
      return;
    }

    //is multi-node
    bool multi = false;
    if (iter->find("@") != string::npos) {
      multi = true;
    }
    
    //find data type
    DataType type = kSTRING;

    //find default value
    string def;

    write_to_config(path_coll, multi, type, def, root);
    ++iter;
  }
}

void
write_to_config(VecColl &coll, bool multi, DataType type, string &def, string &root)
{
  string path = root + "/";

  if (coll.empty()) {
    cout << "path is empty, ignoring cmd" << endl;
    return;
  }

  VecIter iter = coll.begin();
  while (iter != coll.end()) {
    path += *iter + "/";
    ++iter;
  }

  path = path.substr(0, path.length()-1);

  if (multi) {
    path += ":";
  }

  string dir = "mkdir -p " + path;
  if (vcmn_execute(dir) != 0) { 
      cout << "Commit: Error on applying actions" << endl;
      return;
  }
  
  if (type != kNONE) {
    string type_file = "echo 'type: ";
    switch (type) {
    case kSTRING:
      type_file += "string";
      break;
    case kBOOL:
      type_file += "bool";
      break;
    case kIPV4:
      type_file += "ipv4";
      break;
    case kIPV4NET:
      type_file += "ipv4net";
      break;
    case kMAC:
      type_file += "mac";
      break;
    default:
      cout << "error: no match on datatype returning" << endl;
      return;
    }
    
    type_file += "' > " + path + "/type";
    
    //now create type and default files
    if (vcmn_execute(type_file) != 0) { 
      cout << "Commit: Error on applying actions" << endl;
      return;
    }
  }

  if (def.empty() == false) {
    string def_cmd = "echo " + def + " > " + root;
    if (vcmn_execute(def_cmd) != 0) { 
      cout << "Commit: Error on applying actions" << endl;
      return;
    }
  }

}
