#include <stdio.h>
#include <errno.h>
#include <dirent.h>

#include <iostream>
#include <string>
#include <vector>
#include <map>

#include "vsh/common/vsh_common.hh"
#include "vsh/common/vsh_execute.hh"
#include "vsh/common/vsh_config.hh"
#include "vsh/common/vsh_str_proc.hh"

using namespace std;

/**
 *
 *
 **/
void
usage()
{
  printf("show -g -l\n");
}


/**
 *
 *
 **/
int 
main(int argc, char* const argv[])
{
  bool debug = false;
  bool global = false, local = false;

  int ch;
  while ((ch = getopt(argc, argv, "gld")) != -1) {
    switch (ch) {
    case 'd':
      debug = true;
      break;
    case 'g':
      global = true;
      break;
    case 'l':
      local = true;
      break;
    default:
      usage();
      return -1;
    }
  }

  //strip off first arg, then mash up directory 
  if (debug) {
    cout << "starting vshell show: " << endl;
  }

  /**
   *
   * Currently only displays the current working config.
   *
   **/
  if (global && local) {
    cout << "not yet implemented" << endl;
  }
  if (global) {
    string tmp = "ls -R " + vcmn_get_global_root();
    vcmn_execute(tmp);
  }
  else if (local) {
    string tmp = "ls -R " + vcmn_get_local_root();
    vcmn_execute(tmp);
  }
  else {
    cout << "not a command" << endl;
  }
  exit(0);
}
