#include <regex.h>
#include <iostream>
#include <vector>
#include <string>
#include "vsh/common/vsh_str_proc.hh"
#include "validate_types.hh"

using namespace std;

int
apply_regex(string &in, string &match, bool debug);

/**
 *
 *
 **/
int 
validate_string(string &in, string &match, bool debug)
{
  if (debug) {
    cout << "validate_string: " << in << ", " << match << endl;
  }
  return apply_regex(in, match, debug);
}

/**
 *
 *
 **/
int 
validate_bool(string &in, string &match, bool debug)
{
  if (in != "true" && in != "false") {
    return -1;
  }
  return apply_regex(in, match, debug);
}

/**
 *
 *
 **/
int 
validate_ipv4(string &in, string &match, bool debug)
{
  cout << "validate_ipv4: " << in << ", " << match << endl;
  
  StrProc str_proc(in, ".");
  
  for (int i = 0; i < 4; ++i) {
    int val = 256;
    val = strtoul(str_proc.get(1+i*2).c_str(), NULL, 10);
    /*    if (debug) {
      char buf[20];
      sprintf(buf, "%d", val);
      cout << "validate_ipv4: " << string(buf) << endl;
      }*/
    if (val > 255) {
      return -1;
    }
  }
  return apply_regex(in, match, debug);
}

/**
 *
 *
 **/
int 
validate_ipv4net(string &in, string &match, bool debug)
{
  in = match = debug = "";

  string empty;
  StrProc str_proc(in, "/");
  string ip_str = str_proc.get(0);
  if (validate_ipv4(ip_str, empty, debug) != 0) {
    return -1;
  }

  int val = strtoul(str_proc.get(1).c_str(), NULL, 10);
  if (val < 0 || val > 32) {
    return -1;
  }

  return apply_regex(in, match, debug);
}

/**
 *
 *
 **/
int 
validate_mac(string &in, string &match, bool debug)
{
  in = match = debug = "";

  StrProc str_proc(in, ":");
  for (int i = 0; i < 6; ++i) {
    char check_0 = str_proc.get(i)[0];
    char check_1 = str_proc.get(i)[1];
    //now need to compare string to 0-9 and a-f

    //dummy arg for now
    check_0 = check_1;

  }
  return apply_regex(in, match, debug);
}

/**
 *
 *
 **/
int
apply_regex(string &in, string &match, bool debug)
{
  debug = 0;

  if (!match.empty()) {
    regex_t myreg;
    int rc;
    regmatch_t rm[1]; 
    
    cout << "apply_regex: " << in << ", " << match << endl;

    //perform regex comparision
    rc = regcomp(&myreg, match.c_str(), REG_EXTENDED);
    if (rc != 0) {
      cout << "validate_string(), error in regex" << endl;
      return -1;
    }
    
    /* search first match
     */
    int err = regexec(&myreg, in.c_str(), 1, rm, 0);
    cout << "return code from regexec: " << err << endl;
    if (err == 0) {
      cout << "success in regex" << endl;
      //      in.substr(rm[0].rm_so, rm[0].rm_eo);
      //only determine a success for now, i think
      return 0;
    }
    else if (err == REG_NOMATCH) {
      printf("no match found\n");
      return -1;
    }
    else {
      cout << "apply_regex: " << err << endl;
    }
  }
  cout << "dunno how I got here" << endl;
  return -1;
}
