#include <string>
#include <sys/stat.h>
#include <dirent.h>
#include <fcntl.h>
#include <unistd.h>
#include <stdio.h>
#include <iostream>
#include <stdlib.h>
#include <errno.h>
#include <string.h>
#include "vsh/common/vsh_str_proc.hh"
#include <dirent.h>

#include <getopt.h>

using namespace std;

#define SOCK_PATH "/tmp/vshd"

string 
proc_conf_dir(const string &input, bool debug);

bool 
match_node(vector<string> &in_cmd, string &dir_lu, vector<string> &match, bool debug);

int
dir_filter(const struct dirent *d);

/**
 *
 *
 **/
void
usage()
{
  printf("vsh -c [vyatta command]\n");
}

/**
 *
 *
 **/
int 
main(int argc, char* const argv[])
{
  bool debug = false;
  string cmd;

  int ch;
  while ((ch = getopt(argc, argv, "c:d")) != -1) {
    switch (ch) {
    case 'd':
      debug = true;
      break;
    case 'c':
      cmd = optarg;
      break;
    default:
      break;
    }
  }
  //strip off first arg, then mash up directory 
  if (debug) {
    cout << "starting vsh: " << cmd << endl;
  }

  string match;
  match = proc_conf_dir(cmd, debug);
  
  cout << match;

  return 0;
}

/**

How to match:
set interfaces ethernet eth0 address 1.1.1.1 prefix-length 24
to 
/config/interfaces/ethernet:/address:/prefix-length

We convert the command to:

/config/interfaces/ethernet/eth0/address/1.1.1.1/prefix-length/24

**/

/**
 *
 *
 **/
string
proc_conf_dir(const string &input, bool debug)
{
  StrProc str_proc(input, " ");
  vector<string> in_cmd = str_proc.get();
  if (!in_cmd.empty()) {
    in_cmd.erase(in_cmd.begin());
  }

  //root of configuration data
  string dir_cmd = "/config";
  if (debug) {
    //instead look from current working directory
    dir_cmd = "." + dir_cmd;
  }
  
  vector<string> match;
  string rtn_str;

  //match all nodes
  if (match_node(in_cmd, dir_cmd, match, debug)) {
    //output string for now
    vector<string>::iterator iter = match.begin();
    while (iter != match.end()) {
      rtn_str += *iter + " ";
      ++iter;
    }
  }
  else {
    return "";
  }
  return rtn_str;
}

/**
 * Recursive call into directory structure for match. Returns
 * true when search is complete, otherwise false.
 *
 **/
bool 
match_node(vector<string> &in_cmd, string &dir_lu, vector<string> &match, bool debug)
{
  string new_dir_lu = dir_lu;

  match.erase(match.begin(), match.end());

  //pop the next node off the incoming command if there is another command to process
  string cur_node;
  if (!in_cmd.empty()) {
    cur_node = *in_cmd.begin();
    in_cmd.erase(in_cmd.begin());
  }

  if (debug) {
    cout << "match_node dir_ul: " << dir_lu << ", cur_node: " << cur_node << endl;
  }

  bool match_done = false;
  DIR *dir;
  struct dirent *ent;
  if ((dir = opendir(dir_lu.c_str()))) {
    while ((ent = readdir(dir))) {
      bool is_multi = false;
      string dir_name(ent->d_name);

      //test for multi-node hint on directory configuration
      if (char(dir_name[dir_name.length()-1]) == int(':')) {
	dir_name = dir_name.erase(dir_name.length()-1);
	is_multi = true;
      }

      //when a partial or complete node is specified
      if (cur_node.empty() == false) {
	if (dir_name == cur_node) {
	  if (is_multi == true) {
	    //eat next value in in_cmd and continue
	    if (in_cmd.empty() == false) {
	      in_cmd.erase(in_cmd.begin());
	    }
	    match.push_back(dir_name + ":");
	    break;
	  }
	  match.push_back(dir_name);
	  break;
	}
	//partial node match below
	else if (dir_name.find(cur_node) != string::npos) {
	  match_done = true; 
	  match.push_back(dir_name);
	}
      }
      else {
	match_done = true;
	//when an empty node is specified
	if (dir_name != "." && dir_name != "..") {
	  match.push_back(dir_name);
	}
      }
    }
    closedir(dir);
  }

  //recursion call if current node was exactly matched
  if (match.size() == 1 && match_done == false) {
    dir_lu += string("/") + *match.begin();
    match_node(in_cmd, dir_lu, match, debug);
  }
  return !match.empty();
}

