#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <stdio.h>
#include <errno.h>
#include <dirent.h>

#include <iostream>
#include <string>
#include <vector>
#include <map>

#include "vsh/common/vsh_common.hh"
#include "vsh/common/vsh_execute.hh"
#include "vsh/common/vsh_config.hh"
#include "vsh/common/vsh_str_proc.hh"

using namespace std;


int
apply_actions(VecColl &coll);

/**
 *
 *
 **/
void
usage()
{
  printf("commit \n");
}


/**
 *
 *
 **/
int 
main(int argc, char* const argv[])
{
  bool debug = false;
  string cmd;

  int ch;
  while ((ch = getopt(argc, argv, "d")) != -1) {
    switch (ch) {
    case 'd':
      debug = true;
      break;
    default:
      usage();
      return -1;
    }
  }

  //strip off first arg, then mash up directory 
  if (debug) {
    cout << "starting vshell commit: " << cmd << endl;
  }

  
  /*
    1) Iterate through shell configuration and pull action statements 
    for all changed nodes.
    2) Prune actions to least specific statements.
    3) Expand statements according to shell config and global config
    4) Start applying action(s)
    5) Complete action(s)
    6) copy over configuration to global config
    7) done
  */

  //may not be correct as this needs to iterate over all
  //also expands actions....
  string empty;
  VecColl coll;
  vcmn_get_commit_actions(empty, coll); //returns pruned action statements

  if (debug) {
    VecIter iter = coll.begin();
    while (iter != coll.end()) {
      cout << "commit: actions found: " << *iter << endl;
      ++iter;
    }
  }

  if (apply_actions(coll) != 0) {
    cout << "commit: Error in applying actions" << endl;
    exit(1);
  }

  if (vcmn_commit_to_global() != 0) {
    cout << "commit: Error in applying config to global" << endl;
    exit(1);
  }

  if (debug) {
    cout << "done with commit: " << endl;
  }
  exit(0);
}


/**
 *
 *
 **/
int
apply_actions(VecColl &coll)
{
  VecIter iter = coll.begin();
  while (iter != coll.end()) {
    StrProc str_proc(*iter, "\"");

    string tmp = str_proc.get(1);
    if (vcmn_execute(tmp) != 0) {
      cout << "Commit: Error on applying actions" << endl;
      return -1;
    }
    ++iter;
  }
  return 0;
}
