/**
 * Module: xrl_rl_system_node.hh
 *
 * Author: Michael Larson
 * Date: 2006
 */

#ifndef __RL_VPN_XRL_RL_VPN_NODE_HH__
#define __RL_VPN_XRL_RL_VPN_NODE_HH__


//
// RLVPN dummy XRL-aware node definition.
//

#include "libxorp/status_codes.h"
#include "libxipc/xrl_std_router.hh"
#include "xrl/interfaces/finder_event_notifier_xif.hh"

#include "xrl/targets/rl_vpn_base.hh"


//
// The top-level class that wraps-up everything together under one roof
//
class XrlRLVPNNode :     public XrlStdRouter, /* used for dispatch of xrl messages */
			      public XrlRlVpnTargetBase { /* used for defined interface */
public:
    XrlRLVPNNode(EventLoop&	eventloop,
		    const string&	class_name,
		    const string&	finder_hostname,
		    uint16_t	        finder_port,
		    const string&	finder_target);
  ~XrlRLVPNNode(); 

    /**
     * Startup the node operation.
     *
     * @return true on success, false on failure.
     */
  bool	startup();

    /**
     * Shutdown the node operation.
     *
     * @return true on success, false on failure.
     */
  XrlCmdError rl_vpn_0_1_shutdown_vpn();
  XrlCmdError rl_vpn_0_1_end_commit();

    /**
     * Shutdown the node operation.
     *
     * @return true on success, false on failure.
     */
    /**
     * Get a reference to the XrlRouter instance.
     *
     * @return a reference to the XrlRouter (@ref XrlRouter) instance.
     */
    XrlRouter&	xrl_router() { return *this; }

    /**
     * Test if the node processing is done.
     * 
     * @return true if the node processing is done, otherwise false.
     */
    bool	is_done() const { return (_status == PROC_DONE); }

protected:
    //
    // XRL target methods
    //

    /**
     *  Get name of Xrl Target
     */
    XrlCmdError common_0_1_get_target_name(
	// Output values, 
	string&	name);

    /**
     *  Get version string from Xrl Target
     */
    XrlCmdError common_0_1_get_version(
	// Output values, 
	string&	version);

    /**
     *  Get status of Xrl Target
     */
    XrlCmdError common_0_1_get_status(
	// Output values, 
	uint32_t&	status, 
	string&	reason);

    /**
     *  Request clean shutdown of Xrl Target
     */
    XrlCmdError common_0_1_shutdown();


  /**
   *
   */
  XrlCmdError rl_vpn_0_1_delete_vpn(const string &dir);

    /**
     *  Announce target birth to observer.
     *
     *  @param target_class the target class name.
     *
     *  @param target_instance the target instance name.
     */
    XrlCmdError finder_event_observer_0_1_xrl_target_birth(
	// Input values,
	const string&	target_class,
	const string&	target_instance);

    /**
     *  Announce target death to observer.
     *
     *  @param target_class the target class name.
     *
     *  @param target_instance the target instance name.
     */
    XrlCmdError finder_event_observer_0_1_xrl_target_death(
	// Input values,
	const string&	target_class,
	const string&	target_instance);

private:
  /**
   * Called when Finder connection is established.
   *
   * Note that this method overwrites an XrlRouter virtual method.
   */
  virtual void finder_connect_event();
  
  /**
   * Called when Finder disconnect occurs.
   *
   * Note that this method overwrites an XrlRouter virtual method.
   */
  virtual void finder_disconnect_event();
  
  const string& my_xrl_target_name() {
      return XrlRlVpnTargetBase::name();
    }
  
  EventLoop&		_eventloop;
  const string	_class_name;
  const string	_instance_name;
  const string	_finder_target;
  
  XrlFinderEventNotifierV0p1Client	_xrl_finder_client;
  
  static const TimeVal RETRY_TIMEVAL;
  
  bool		_is_finder_alive;

  uint32_t         _status;
};

#endif // __RL_VPN_XRL_RL_VPN_NODE_HH__
