/**
 * Module: xrl_rl_vpn_node.hh
 *
 * Author: Michael Larson
 * Date: 2006
 */

#include "rl_vpn_module.h"

#include "libxorp/xorp.h"
#include "libxorp/xlog.h"
#include "libxorp/debug.h"
#include "libxorp/ipvx.hh"
#include "libxorp/status_codes.h"
#include "librl_common/rl_command.hh"

#include "xrl_rl_vpn_node.hh"

XrlRLVPNNode::XrlRLVPNNode(EventLoop&	eventloop,
				 const string&	class_name,
				 const string&	finder_hostname,
				 uint16_t	finder_port,
				 const string&	finder_target)
    : XrlStdRouter(eventloop, class_name.c_str(), finder_hostname.c_str(),
		   finder_port),
      XrlRlVpnTargetBase(&xrl_router()),
      _eventloop(eventloop),
      _class_name(xrl_router().class_name()),
      _instance_name(xrl_router().instance_name()),
      _finder_target(finder_target),
      _xrl_finder_client(&xrl_router()),
      _is_finder_alive(false),
      _status(PROC_STARTUP)
{
}

XrlRLVPNNode::~XrlRLVPNNode()
{
}

bool
XrlRLVPNNode::startup()
{
  _status = PROC_READY;
  return true;
}

XrlCmdError
XrlRLVPNNode::rl_vpn_0_1_shutdown_vpn()
{
  string cmd("/etc/init.d/ipsec stop");
  if (rl_command::execute(cmd) == false) {
      XLOG_ERROR("XrlRLVPNNode: error on execution: %s", cmd.c_str());
  }
  
  cmd = "rm -rf " RUNNING_CONFIG "/vpn";
  if (rl_command::execute(cmd) == false) {
      XLOG_ERROR("XrlRLVPNNode: error on execution: %s", cmd.c_str());
  }
  cmd = "rm -rf " WORKING_CONFIG "/vpn";
  if (rl_command::execute(cmd) == false) {
      XLOG_ERROR("XrlRLVPNNode: error on execution: %s", cmd.c_str());
  }

  //handles shutdown of system and deletion of nodes?
  _status = PROC_SHUTDOWN;
  return XrlCmdError::OKAY();
}

XrlCmdError
XrlRLVPNNode::rl_vpn_0_1_end_commit()
{
  //handles shutdown of system and deletion of nodes?
  //here is where we'll grab the message return
  return XrlCmdError::OKAY();//XrlCmdError::COMMAND_FAILED("FOO");
}


/**
 *
 */
XrlCmdError 
XrlRLVPNNode::rl_vpn_0_1_delete_vpn(const string &dir)
{
  string cmd("/etc/init.d/ipsec stop");
  if (rl_command::execute(cmd) == false) {
      XLOG_ERROR("XrlRLVPNNode: error on execution: %s", cmd.c_str());
  }
  unlink(dir.c_str());
  return XrlCmdError::OKAY();
}


//
// Finder-related events
//
/**
 * Called when Finder connection is established.
 *
 * Note that this method overwrites an XrlRouter virtual method.
 */
void
XrlRLVPNNode::finder_connect_event()
{
    //printf("%s\n",__PRETTY_FUNCTION__);
    _is_finder_alive = true;
}

/**
 * Called when Finder disconnect occurs.
 *
 * Note that this method overwrites an XrlRouter virtual method.
 */
void
XrlRLVPNNode::finder_disconnect_event()
{
    XLOG_ERROR("Finder disconnect event. Exiting immediately...");
    //printf("%s\n",__PRETTY_FUNCTION__);

    _is_finder_alive = false;
}

//
// XRL target methods
//

/**
 *  Get name of Xrl Target
 */
XrlCmdError
XrlRLVPNNode::common_0_1_get_target_name(
    // Output values, 
    string&	name)
{
    //printf("%s\n",__PRETTY_FUNCTION__);
    name = my_xrl_target_name();

    return XrlCmdError::OKAY();
}

/**
 *  Get version string from Xrl Target
 */
XrlCmdError
XrlRLVPNNode::common_0_1_get_version(
    // Output values, 
    string&	version)
{
    //printf("%s\n",__PRETTY_FUNCTION__);
    version = XORP_MODULE_VERSION;

    return XrlCmdError::OKAY();
}

/**
 *  Get status of Xrl Target
 */
XrlCmdError
XrlRLVPNNode::common_0_1_get_status(
    // Output values, 
    uint32_t&	status, 
    string&	reason)
{
  reason = " ";
  status = _status;

  if (PROC_SHUTDOWN == _status) {
    _status = PROC_DONE;
  }

  return XrlCmdError::OKAY();
}

/**
 *  Request clean shutdown of Xrl Target
 */
XrlCmdError
XrlRLVPNNode::common_0_1_shutdown()
{
    string error_msg;
    //printf("%s\n",__PRETTY_FUNCTION__);
    /*
    if (shutdown() != true) {
	error_msg = c_format("Failed to shutdown RLVPN");
	return XrlCmdError::COMMAND_FAILED(error_msg);
    }
    */
    return XrlCmdError::OKAY();
}

/**
 *  Announce target birth to observer.
 *
 *  @param target_class the target class name.
 *
 *  @param target_instance the target instance name.
 */
XrlCmdError
XrlRLVPNNode::finder_event_observer_0_1_xrl_target_birth(
    // Input values,
    const string&   target_class,
    const string&   target_instance)
{
    //printf("%s\n",__PRETTY_FUNCTION__);
    return XrlCmdError::OKAY();
    UNUSED(target_class);
    UNUSED(target_instance);
}

/**
 *  Announce target death to observer.
 *
 *  @param target_class the target class name.
 *
 *  @param target_instance the target instance name.
 */
XrlCmdError
XrlRLVPNNode::finder_event_observer_0_1_xrl_target_death(
    // Input values,
    const string&   target_class,
    const string&   target_instance)
{
    //printf("%s\n",__PRETTY_FUNCTION__);
    return XrlCmdError::OKAY();
    UNUSED(target_class);
    UNUSED(target_instance);
}

