rl_system_common_get_target_name()
{
    if [ $# -ne 0 ] ; then
        echo "Usage: rl_system_common_get_target_name"
        exit 1
    fi

    XRL="finder://rl_system/common/0.1/get_target_name"
    call_xrl_wrapper -p all "${XRL}"
}

rl_system_common_get_version()
{
    if [ $# -ne 0 ] ; then
        echo "Usage: rl_system_common_get_version"
        exit 1
    fi

    XRL="finder://rl_system/common/0.1/get_version"
    call_xrl_wrapper -p all "${XRL}"
}

rl_system_common_get_status()
{
    if [ $# -ne 0 ] ; then
        echo "Usage: rl_system_common_get_status"
        exit 1
    fi

    XRL="finder://rl_system/common/0.1/get_status"
    call_xrl_wrapper -p all "${XRL}"
}

rl_system_common_shutdown()
{
    if [ $# -ne 0 ] ; then
        echo "Usage: rl_system_common_shutdown"
        exit 1
    fi

    XRL="finder://rl_system/common/0.1/shutdown"
    call_xrl_wrapper -p all "${XRL}"
}

rl_system_rl_system_enable_rl_system()
{
    if [ $# -ne 1 ] ; then
        echo "Usage: rl_system_rl_system_enable_rl_system <enable:bool>"
        exit 1
    fi

    XRL="finder://rl_system/rl_system/0.1/enable_rl_system?enable:bool=$1"
    call_xrl_wrapper -p all "${XRL}"
}

rl_system_rl_system_start_rl_system()
{
    if [ $# -ne 0 ] ; then
        echo "Usage: rl_system_rl_system_start_rl_system"
        exit 1
    fi

    XRL="finder://rl_system/rl_system/0.1/start_rl_system"
    call_xrl_wrapper -p all "${XRL}"
}

rl_system_rl_system_stop_rl_system()
{
    if [ $# -ne 0 ] ; then
        echo "Usage: rl_system_rl_system_stop_rl_system"
        exit 1
    fi

    XRL="finder://rl_system/rl_system/0.1/stop_rl_system"
    call_xrl_wrapper -p all "${XRL}"
}

rl_system_rl_system_shutdown_system()
{
    if [ $# -ne 0 ] ; then
        echo "Usage: rl_system_rl_system_shutdown_system"
        exit 1
    fi

    XRL="finder://rl_system/rl_system/0.1/shutdown_system"
    call_xrl_wrapper -p all "${XRL}"
}

rl_system_rl_system_start_commit()
{
    if [ $# -ne 0 ] ; then
        echo "Usage: rl_system_rl_system_start_commit"
        exit 1
    fi

    XRL="finder://rl_system/rl_system/0.1/start_commit"
    call_xrl_wrapper -p all "${XRL}"
}

rl_system_rl_system_end_commit()
{
    if [ $# -ne 0 ] ; then
        echo "Usage: rl_system_rl_system_end_commit"
        exit 1
    fi

    XRL="finder://rl_system/rl_system/0.1/end_commit"
    call_xrl_wrapper -p all "${XRL}"
}

rl_system_rl_system_add_interface()
{
    if [ $# -ne 1 ] ; then
        echo "Usage: rl_system_rl_system_add_interface <address:ipv4>"
        exit 1
    fi

    XRL="finder://rl_system/rl_system/0.1/add_interface?address:ipv4=$1"
    call_xrl_wrapper -p all "${XRL}"
}

rl_system_rl_system_enable_log_trace_all()
{
    if [ $# -ne 1 ] ; then
        echo "Usage: rl_system_rl_system_enable_log_trace_all <enable:bool>"
        exit 1
    fi

    XRL="finder://rl_system/rl_system/0.1/enable_log_trace_all?enable:bool=$1"
    call_xrl_wrapper -p all "${XRL}"
}

rl_system_rl_system_set_host_name()
{
    if [ $# -ne 2 ] ; then
        echo "Usage: rl_system_rl_system_set_host_name <name:txt> <domain_name:txt>"
        exit 1
    fi

    XRL="finder://rl_system/rl_system/0.1/set_host_name?name:txt=$1&domain_name:txt=$2"
    call_xrl_wrapper -p all "${XRL}"
}

rl_system_rl_system_delete_host_name()
{
    if [ $# -ne 2 ] ; then
        echo "Usage: rl_system_rl_system_delete_host_name <name:txt> <domain_name:txt>"
        exit 1
    fi

    XRL="finder://rl_system/rl_system/0.1/delete_host_name?name:txt=$1&domain_name:txt=$2"
    call_xrl_wrapper -p all "${XRL}"
}

rl_system_rl_system_set_domain_name()
{
    if [ $# -ne 1 ] ; then
        echo "Usage: rl_system_rl_system_set_domain_name <name:txt>"
        exit 1
    fi

    XRL="finder://rl_system/rl_system/0.1/set_domain_name?name:txt=$1"
    call_xrl_wrapper -p all "${XRL}"
}

rl_system_rl_system_delete_domain_name()
{
    if [ $# -ne 1 ] ; then
        echo "Usage: rl_system_rl_system_delete_domain_name <name:txt>"
        exit 1
    fi

    XRL="finder://rl_system/rl_system/0.1/delete_domain_name?name:txt=$1"
    call_xrl_wrapper -p all "${XRL}"
}

rl_system_rl_system_set_domain_search()
{
    if [ $# -ne 1 ] ; then
        echo "Usage: rl_system_rl_system_set_domain_search <name:txt>"
        exit 1
    fi

    XRL="finder://rl_system/rl_system/0.1/set_domain_search?name:txt=$1"
    call_xrl_wrapper -p all "${XRL}"
}

rl_system_rl_system_delete_domain_search()
{
    if [ $# -ne 1 ] ; then
        echo "Usage: rl_system_rl_system_delete_domain_search <name:txt>"
        exit 1
    fi

    XRL="finder://rl_system/rl_system/0.1/delete_domain_search?name:txt=$1"
    call_xrl_wrapper -p all "${XRL}"
}

rl_system_rl_system_add_name_server()
{
    if [ $# -ne 1 ] ; then
        echo "Usage: rl_system_rl_system_add_name_server <address:ipv4>"
        exit 1
    fi

    XRL="finder://rl_system/rl_system/0.1/add_name_server?address:ipv4=$1"
    call_xrl_wrapper -p all "${XRL}"
}

rl_system_rl_system_delete_name_server()
{
    if [ $# -ne 1 ] ; then
        echo "Usage: rl_system_rl_system_delete_name_server <address:ipv4>"
        exit 1
    fi

    XRL="finder://rl_system/rl_system/0.1/delete_name_server?address:ipv4=$1"
    call_xrl_wrapper -p all "${XRL}"
}

rl_system_rl_system_set_timezone()
{
    if [ $# -ne 1 ] ; then
        echo "Usage: rl_system_rl_system_set_timezone <name:txt>"
        exit 1
    fi

    XRL="finder://rl_system/rl_system/0.1/set_timezone?name:txt=$1"
    call_xrl_wrapper -p all "${XRL}"
}

rl_system_rl_system_delete_timezone()
{
    if [ $# -ne 1 ] ; then
        echo "Usage: rl_system_rl_system_delete_timezone <name:txt>"
        exit 1
    fi

    XRL="finder://rl_system/rl_system/0.1/delete_timezone?name:txt=$1"
    call_xrl_wrapper -p all "${XRL}"
}

rl_system_rl_system_set_ntp()
{
    if [ $# -ne 1 ] ; then
        echo "Usage: rl_system_rl_system_set_ntp <host:txt>"
        exit 1
    fi

    XRL="finder://rl_system/rl_system/0.1/set_ntp?host:txt=$1"
    call_xrl_wrapper -p all "${XRL}"
}

rl_system_rl_system_delete_ntp()
{
    if [ $# -ne 1 ] ; then
        echo "Usage: rl_system_rl_system_delete_ntp <host:txt>"
        exit 1
    fi

    XRL="finder://rl_system/rl_system/0.1/delete_ntp?host:txt=$1"
    call_xrl_wrapper -p all "${XRL}"
}

rl_system_rl_system_set_static_host_map_inet()
{
    if [ $# -ne 2 ] ; then
        echo "Usage: rl_system_rl_system_set_static_host_map_inet <host_name:txt> <address:ipv4>"
        exit 1
    fi

    XRL="finder://rl_system/rl_system/0.1/set_static_host_map_inet?host_name:txt=$1&address:ipv4=$2"
    call_xrl_wrapper -p all "${XRL}"
}

rl_system_rl_system_delete_static_host_map_inet()
{
    if [ $# -ne 2 ] ; then
        echo "Usage: rl_system_rl_system_delete_static_host_map_inet <host_name:txt> <address:ipv4>"
        exit 1
    fi

    XRL="finder://rl_system/rl_system/0.1/delete_static_host_map_inet?host_name:txt=$1&address:ipv4=$2"
    call_xrl_wrapper -p all "${XRL}"
}

rl_system_rl_system_set_static_host_map_inet_alias()
{
    if [ $# -ne 3 ] ; then
        echo "Usage: rl_system_rl_system_set_static_host_map_inet_alias <host_name:txt> <address:ipv4> <name:txt>"
        exit 1
    fi

    XRL="finder://rl_system/rl_system/0.1/set_static_host_map_inet_alias?host_name:txt=$1&address:ipv4=$2&name:txt=$3"
    call_xrl_wrapper -p all "${XRL}"
}

rl_system_rl_system_delete_static_host_map_inet_alias()
{
    if [ $# -ne 3 ] ; then
        echo "Usage: rl_system_rl_system_delete_static_host_map_inet_alias <host_name:txt> <address:ipv4> <name:txt>"
        exit 1
    fi

    XRL="finder://rl_system/rl_system/0.1/delete_static_host_map_inet_alias?host_name:txt=$1&address:ipv4=$2&name:txt=$3"
    call_xrl_wrapper -p all "${XRL}"
}

rl_system_rl_system_set_gateway_address()
{
    if [ $# -ne 1 ] ; then
        echo "Usage: rl_system_rl_system_set_gateway_address <gateway_address:ipv4>"
        exit 1
    fi

    XRL="finder://rl_system/rl_system/0.1/set_gateway_address?gateway_address:ipv4=$1"
    call_xrl_wrapper -p all "${XRL}"
}

rl_system_rl_system_delete_gateway_address()
{
    if [ $# -ne 1 ] ; then
        echo "Usage: rl_system_rl_system_delete_gateway_address <gateway_address:ipv4>"
        exit 1
    fi

    XRL="finder://rl_system/rl_system/0.1/delete_gateway_address?gateway_address:ipv4=$1"
    call_xrl_wrapper -p all "${XRL}"
}

rl_system_rl_system_delete_syslog()
{
    if [ $# -ne 0 ] ; then
        echo "Usage: rl_system_rl_system_delete_syslog"
        exit 1
    fi

    XRL="finder://rl_system/rl_system/0.1/delete_syslog"
    call_xrl_wrapper -p all "${XRL}"
}

rl_system_rl_system_set_syslog_console()
{
    if [ $# -ne 2 ] ; then
        echo "Usage: rl_system_rl_system_set_syslog_console <facility:txt> <level:txt>"
        exit 1
    fi

    XRL="finder://rl_system/rl_system/0.1/set_syslog_console?facility:txt=$1&level:txt=$2"
    call_xrl_wrapper -p all "${XRL}"
}

rl_system_rl_system_delete_syslog_console()
{
    if [ $# -ne 2 ] ; then
        echo "Usage: rl_system_rl_system_delete_syslog_console <facility:txt> <level:txt>"
        exit 1
    fi

    XRL="finder://rl_system/rl_system/0.1/delete_syslog_console?facility:txt=$1&level:txt=$2"
    call_xrl_wrapper -p all "${XRL}"
}

rl_system_rl_system_set_syslog_file_facility()
{
    if [ $# -ne 3 ] ; then
        echo "Usage: rl_system_rl_system_set_syslog_file_facility <file:txt> <facility:txt> <level:txt>"
        exit 1
    fi

    XRL="finder://rl_system/rl_system/0.1/set_syslog_file_facility?file:txt=$1&facility:txt=$2&level:txt=$3"
    call_xrl_wrapper -p all "${XRL}"
}

rl_system_rl_system_delete_syslog_file_facility()
{
    if [ $# -ne 3 ] ; then
        echo "Usage: rl_system_rl_system_delete_syslog_file_facility <file:txt> <facility:txt> <level:txt>"
        exit 1
    fi

    XRL="finder://rl_system/rl_system/0.1/delete_syslog_file_facility?file:txt=$1&facility:txt=$2&level:txt=$3"
    call_xrl_wrapper -p all "${XRL}"
}

rl_system_rl_system_set_syslog_file_archive()
{
    if [ $# -ne 3 ] ; then
        echo "Usage: rl_system_rl_system_set_syslog_file_archive <file:txt> <files:u32> <size:u32>"
        exit 1
    fi

    XRL="finder://rl_system/rl_system/0.1/set_syslog_file_archive?file:txt=$1&files:u32=$2&size:u32=$3"
    call_xrl_wrapper -p all "${XRL}"
}

rl_system_rl_system_delete_syslog_file_archive()
{
    if [ $# -ne 3 ] ; then
        echo "Usage: rl_system_rl_system_delete_syslog_file_archive <file:txt> <files:u32> <size:u32>"
        exit 1
    fi

    XRL="finder://rl_system/rl_system/0.1/delete_syslog_file_archive?file:txt=$1&files:u32=$2&size:u32=$3"
    call_xrl_wrapper -p all "${XRL}"
}

rl_system_rl_system_set_syslog_host_facility()
{
    if [ $# -ne 3 ] ; then
        echo "Usage: rl_system_rl_system_set_syslog_host_facility <host:txt> <facility:txt> <level:txt>"
        exit 1
    fi

    XRL="finder://rl_system/rl_system/0.1/set_syslog_host_facility?host:txt=$1&facility:txt=$2&level:txt=$3"
    call_xrl_wrapper -p all "${XRL}"
}

rl_system_rl_system_delete_syslog_host_facility()
{
    if [ $# -ne 3 ] ; then
        echo "Usage: rl_system_rl_system_delete_syslog_host_facility <host:txt> <facility:txt> <level:txt>"
        exit 1
    fi

    XRL="finder://rl_system/rl_system/0.1/delete_syslog_host_facility?host:txt=$1&facility:txt=$2&level:txt=$3"
    call_xrl_wrapper -p all "${XRL}"
}

rl_system_rl_system_set_syslog_host_log_prefix()
{
    if [ $# -ne 2 ] ; then
        echo "Usage: rl_system_rl_system_set_syslog_host_log_prefix <host:txt> <log_prefix:txt>"
        exit 1
    fi

    XRL="finder://rl_system/rl_system/0.1/set_syslog_host_log_prefix?host:txt=$1&log_prefix:txt=$2"
    call_xrl_wrapper -p all "${XRL}"
}

rl_system_rl_system_delete_syslog_host_log_prefix()
{
    if [ $# -ne 2 ] ; then
        echo "Usage: rl_system_rl_system_delete_syslog_host_log_prefix <host:txt> <log_prefix:txt>"
        exit 1
    fi

    XRL="finder://rl_system/rl_system/0.1/delete_syslog_host_log_prefix?host:txt=$1&log_prefix:txt=$2"
    call_xrl_wrapper -p all "${XRL}"
}

rl_system_rl_system_set_syslog_user()
{
    if [ $# -ne 3 ] ; then
        echo "Usage: rl_system_rl_system_set_syslog_user <user:txt> <facility:txt> <level:txt>"
        exit 1
    fi

    XRL="finder://rl_system/rl_system/0.1/set_syslog_user?user:txt=$1&facility:txt=$2&level:txt=$3"
    call_xrl_wrapper -p all "${XRL}"
}

rl_system_rl_system_delete_syslog_user()
{
    if [ $# -ne 3 ] ; then
        echo "Usage: rl_system_rl_system_delete_syslog_user <user:txt> <facility:txt> <level:txt>"
        exit 1
    fi

    XRL="finder://rl_system/rl_system/0.1/delete_syslog_user?user:txt=$1&facility:txt=$2&level:txt=$3"
    call_xrl_wrapper -p all "${XRL}"
}

rl_system_rl_system_set_system_login_user()
{
    if [ $# -ne 4 ] ; then
        echo "Usage: rl_system_rl_system_set_system_login_user <user:txt> <full_name:txt> <encrypted_pw:txt> <plaintext_pw:txt>"
        exit 1
    fi

    XRL="finder://rl_system/rl_system/0.1/set_system_login_user?user:txt=$1&full_name:txt=$2&encrypted_pw:txt=$3&plaintext_pw:txt=$4"
    call_xrl_wrapper -p all "${XRL}"
}

rl_system_rl_system_delete_system_login_user()
{
    if [ $# -ne 4 ] ; then
        echo "Usage: rl_system_rl_system_delete_system_login_user <user:txt> <full_name:txt> <encrypted_pw:txt> <plaintext_pw:txt>"
        exit 1
    fi

    XRL="finder://rl_system/rl_system/0.1/delete_system_login_user?user:txt=$1&full_name:txt=$2&encrypted_pw:txt=$3&plaintext_pw:txt=$4"
    call_xrl_wrapper -p all "${XRL}"
}

rl_system_rl_system_delete_system_login()
{
    if [ $# -ne 0 ] ; then
        echo "Usage: rl_system_rl_system_delete_system_login"
        exit 1
    fi

    XRL="finder://rl_system/rl_system/0.1/delete_system_login"
    call_xrl_wrapper -p all "${XRL}"
}

rl_system_rl_system_set_system_login_authentication_order()
{
    if [ $# -ne 1 ] ; then
        echo "Usage: rl_system_rl_system_set_system_login_authentication_order <authentication_order:txt>"
        exit 1
    fi

    XRL="finder://rl_system/rl_system/0.1/set_system_login_authentication_order?authentication_order:txt=$1"
    call_xrl_wrapper -p all "${XRL}"
}

rl_system_rl_system_set_system_login_radius_server()
{
    if [ $# -ne 4 ] ; then
        echo "Usage: rl_system_rl_system_set_system_login_radius_server <address:ipv4> <port:u32> <secret:txt> <timeout:u32>"
        exit 1
    fi

    XRL="finder://rl_system/rl_system/0.1/set_system_login_radius_server?address:ipv4=$1&port:u32=$2&secret:txt=$3&timeout:u32=$4"
    call_xrl_wrapper -p all "${XRL}"
}

rl_system_rl_system_delete_system_login_radius_server()
{
    if [ $# -ne 4 ] ; then
        echo "Usage: rl_system_rl_system_delete_system_login_radius_server <address:ipv4> <port:u32> <secret:txt> <timeout:u32>"
        exit 1
    fi

    XRL="finder://rl_system/rl_system/0.1/delete_system_login_radius_server?address:ipv4=$1&port:u32=$2&secret:txt=$3&timeout:u32=$4"
    call_xrl_wrapper -p all "${XRL}"
}

rl_system_rl_system_set_system_login_tacplus_server()
{
    if [ $# -ne 2 ] ; then
        echo "Usage: rl_system_rl_system_set_system_login_tacplus_server <server:ipv4> <secret:txt>"
        exit 1
    fi

    XRL="finder://rl_system/rl_system/0.1/set_system_login_tacplus_server?server:ipv4=$1&secret:txt=$2"
    call_xrl_wrapper -p all "${XRL}"
}

rl_system_rl_system_delete_system_login_tacplus_server()
{
    if [ $# -ne 2 ] ; then
        echo "Usage: rl_system_rl_system_delete_system_login_tacplus_server <server:ipv4> <secret:txt>"
        exit 1
    fi

    XRL="finder://rl_system/rl_system/0.1/delete_system_login_tacplus_server?server:ipv4=$1&secret:txt=$2"
    call_xrl_wrapper -p all "${XRL}"
}

rl_system_rl_system_start_system_bridging_bridge_group()
{
    if [ $# -ne 1 ] ; then
        echo "Usage: rl_system_rl_system_start_system_bridging_bridge_group <bridge_group:txt>"
        exit 1
    fi

    XRL="finder://rl_system/rl_system/0.1/start_system_bridging_bridge_group?bridge_group:txt=$1"
    call_xrl_wrapper -p all "${XRL}"
}

rl_system_rl_system_commit_system_bridging_bridge_group()
{
    if [ $# -ne 1 ] ; then
        echo "Usage: rl_system_rl_system_commit_system_bridging_bridge_group <bridge_group:txt>"
        exit 1
    fi

    XRL="finder://rl_system/rl_system/0.1/commit_system_bridging_bridge_group?bridge_group:txt=$1"
    call_xrl_wrapper -p all "${XRL}"
}

rl_system_rl_system_set_system_bridging_bridge_group_stp()
{
    if [ $# -ne 2 ] ; then
        echo "Usage: rl_system_rl_system_set_system_bridging_bridge_group_stp <bridge_group:txt> <stp:bool>"
        exit 1
    fi

    XRL="finder://rl_system/rl_system/0.1/set_system_bridging_bridge_group_stp?bridge_group:txt=$1&stp:bool=$2"
    call_xrl_wrapper -p all "${XRL}"
}

rl_system_rl_system_set_system_bridging_bridge_group_forwarding_delay()
{
    if [ $# -ne 2 ] ; then
        echo "Usage: rl_system_rl_system_set_system_bridging_bridge_group_forwarding_delay <bridge_group:txt> <forwarding_delay:u32>"
        exit 1
    fi

    XRL="finder://rl_system/rl_system/0.1/set_system_bridging_bridge_group_forwarding_delay?bridge_group:txt=$1&forwarding_delay:u32=$2"
    call_xrl_wrapper -p all "${XRL}"
}

rl_system_rl_system_set_system_bridging_bridge_group_hello_time()
{
    if [ $# -ne 2 ] ; then
        echo "Usage: rl_system_rl_system_set_system_bridging_bridge_group_hello_time <bridge_group:txt> <hello_time:u32>"
        exit 1
    fi

    XRL="finder://rl_system/rl_system/0.1/set_system_bridging_bridge_group_hello_time?bridge_group:txt=$1&hello_time:u32=$2"
    call_xrl_wrapper -p all "${XRL}"
}

rl_system_rl_system_set_system_bridging_bridge_group_max_hello_age()
{
    if [ $# -ne 2 ] ; then
        echo "Usage: rl_system_rl_system_set_system_bridging_bridge_group_max_hello_age <bridge_group:txt> <max_hello_age:u32>"
        exit 1
    fi

    XRL="finder://rl_system/rl_system/0.1/set_system_bridging_bridge_group_max_hello_age?bridge_group:txt=$1&max_hello_age:u32=$2"
    call_xrl_wrapper -p all "${XRL}"
}

rl_system_rl_system_set_interfaces_bridge_priority()
{
    if [ $# -ne 3 ] ; then
        echo "Usage: rl_system_rl_system_set_interfaces_bridge_priority <interface:txt> <group:txt> <priority:u32>"
        exit 1
    fi

    XRL="finder://rl_system/rl_system/0.1/set_interfaces_bridge_priority?interface:txt=$1&group:txt=$2&priority:u32=$3"
    call_xrl_wrapper -p all "${XRL}"
}

rl_system_rl_system_set_interfaces_bridge_cost()
{
    if [ $# -ne 3 ] ; then
        echo "Usage: rl_system_rl_system_set_interfaces_bridge_cost <interface:txt> <group:txt> <cost:u32>"
        exit 1
    fi

    XRL="finder://rl_system/rl_system/0.1/set_interfaces_bridge_cost?interface:txt=$1&group:txt=$2&cost:u32=$3"
    call_xrl_wrapper -p all "${XRL}"
}

rl_system_rl_system_set_package_repository_component()
{
    if [ $# -ne 7 ] ; then
        echo "Usage: rl_system_rl_system_set_package_repository_component <repository:txt> <host_name:txt> <component:txt> <method:txt> <username:txt> <encrypted_password:txt> <plaintext_password:txt>"
        exit 1
    fi

    XRL="finder://rl_system/rl_system/0.1/set_package_repository_component?repository:txt=$1&host_name:txt=$2&component:txt=$3&method:txt=$4&username:txt=$5&encrypted_password:txt=$6&plaintext_password:txt=$7"
    call_xrl_wrapper -p all "${XRL}"
}

rl_system_rl_system_delete_package_repository_component()
{
    if [ $# -ne 7 ] ; then
        echo "Usage: rl_system_rl_system_delete_package_repository_component <repository:txt> <host_name:txt> <component:txt> <method:txt> <username:txt> <encrypted_password:txt> <plaintext_password:txt>"
        exit 1
    fi

    XRL="finder://rl_system/rl_system/0.1/delete_package_repository_component?repository:txt=$1&host_name:txt=$2&component:txt=$3&method:txt=$4&username:txt=$5&encrypted_password:txt=$6&plaintext_password:txt=$7"
    call_xrl_wrapper -p all "${XRL}"
}

