/*
 * Module: rl_system_node.hh
 *
 * **** License ****
 * Version: VPL 1.0
 *
 * The contents of this file are subject to the Vyatta Public License
 * Version 1.0 ("License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.vyatta.com/vpl
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
 * the License for the specific language governing rights and limitations
 * under the License.
 *
 * This code was originally developed by Vyatta, Inc.
 * Portions created by Vyatta are Copyright (C) 2005, 2006, 2007 Vyatta, Inc.
 * All Rights Reserved.
 *
 * Author: Michael Larson
 * Date: 2005
 * Description:
 *
 * **** End License ****
 *
 */
#ifndef __RL_SYSTEM_RL_SYSTEM_NODE_HH__
#define __RL_SYSTEM_RL_SYSTEM_NODE_HH__

#include <string>
#include <set>
#include <libxipc/xrl_error.hh>
#include <libxorp/ipv4.hh>

class RLSystemNode
{
public:
  typedef set<string> NTPColl;
  typedef set<string>::iterator NTPIter;

public:
  RLSystemNode();
  ~RLSystemNode();

  XrlCmdError
  reset();

  XrlCmdError
  start_commit();

  XrlCmdError
  end_commit();

  XrlCmdError 
  set_host_name(const std::string &name, const std::string &domain_name);
  XrlCmdError
  delete_host_name(const std::string &name, const std::string &domain_name);

  XrlCmdError
  set_domain_name(const std::string &name);
  XrlCmdError
  delete_domain_name(const std::string &name);

  XrlCmdError
  set_domain_search(const std::string &name);
  XrlCmdError
  delete_domain_search(const std::string &name);

  XrlCmdError
  add_name_server(const IPv4 &address);
  XrlCmdError
  delete_name_server(const IPv4 &address);

  XrlCmdError
  set_ntp(const string& host);
  XrlCmdError
  delete_ntp(const string& host);

  XrlCmdError
  set_timezone(const std::string &name);
  XrlCmdError
  delete_timezone(const std::string &name);

  XrlCmdError
  set_static_host_map_host_name_inet(const string &host_name, const IPv4 &address);
  XrlCmdError
  delete_static_host_map_host_name_inet(const string &host_name, const IPv4 &address);
  
  XrlCmdError
  set_static_host_map_host_name_inet_alias(const string &host_name, const IPv4 &address, const string& name);
  XrlCmdError
  delete_static_host_map_host_name_inet_alias(const string &host_name, const IPv4 &address, const string& name);
  
  XrlCmdError
  set_gateway(const IPv4 &address);
  XrlCmdError
  delete_gateway(const IPv4 &address);
  
    XrlCmdError
    set_login_auth_order(const string &authentication_order);

  XrlCmdError 
  set_system_login_user(
			const string &user,
			const string &full_name,
			const string &encrypted_pw,
			const string &plaintext_pw);
  
  XrlCmdError 
  delete_system_login_user(
			   const string &user,
			   const string &full_name,
			   const string &encrypted_pw,
			   const string &plaintext_pw);

  XrlCmdError
  delete_system_login_all();
  
  XrlCmdError 
  set_login_radius_server(
				 const IPv4 &address,
				 const uint32_t &port,
				 const string &secret,
				 const uint32_t &timeout);
  
  XrlCmdError 
  delete_login_radius_server(
				    const IPv4 &address,
				    const uint32_t &port,
				    const string &secret,
				    const uint32_t &timeout);
  
  XrlCmdError 
  set_login_tacplus_server(const IPv4 &address, const string &secret);
  
  XrlCmdError 
  delete_login_tacplus_server(const IPv4 &address, const string &secret);

  XrlCmdError 
  set_package_repository_component(
			const string &repository, 
			const string &host_name, 
			const string &component, 
			const string &method, 
			const string &username, 
			const string &encrypted_password, 
			const string &plaintext_password);

  XrlCmdError 
  delete_package_repository_component(
			const string &repository,
			const string &host_name,  
			const string &component, 
			const string &method, 
			const string &username, 
			const string &encrypted_password, 
			const string &plaintext_password);

private:
  string _resolv_filename;
  string _hostname_filename;
  string _localtime_filename;
  string _localtime_file_dir;
  string _hosts_filename;
  string _radius_filename;
  string _crontab_filename;
  string _pam_filename;
  string _hosts_tag;
  string _rdate_log_dir;
  string _shadow_pw_file;
  string _ntp_conf_file;
  string _apt_sources_list;

  NTPColl _ntp_coll;
  bool _ntp_config_changed;
};

#endif //__RL_SYSTEM_RL_SYSTEM_NODE_HH__
