/*
 * Module: rl_syslog_node.hh
 *
 * **** License ****
 * Version: VPL 1.0
 *
 * The contents of this file are subject to the Vyatta Public License
 * Version 1.0 ("License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.vyatta.com/vpl
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
 * the License for the specific language governing rights and limitations
 * under the License.
 *
 * This code was originally developed by Vyatta, Inc.
 * Portions created by Vyatta are Copyright (C) 2005, 2006, 2007 Vyatta, Inc.
 * All Rights Reserved.
 *
 * Author: Michael Larson
 * Date: 2005
 * Description:
 *
 * **** End License ****
 *
 */

#ifndef __RL_SYSLOG_RL_SYSLOG_NODE_HH__
#define __RL_SYSLOG_RL_SYSLOG_NODE_HH__

#include <string>
#include <libxipc/xrl_error.hh>
#include <libxorp/ipv4.hh>

class RLSyslogNode
{
public:
  RLSyslogNode();
  ~RLSyslogNode();

  XrlCmdError
  reset();

  XrlCmdError
  delete_syslog();

  XrlCmdError
  set_syslog_console(const string &facility, const string &level);

  XrlCmdError
  delete_syslog_console(const string &facility, const string &level);

  XrlCmdError
  set_syslog_system(const string &facility, const string &level);

  XrlCmdError
  delete_syslog_system(const string &facility, const string &level);

  XrlCmdError
  set_syslog_system_archive(const uint32_t &files,
		  const uint32_t &size);

  XrlCmdError
  delete_syslog_system_archive(const uint32_t &files,
		  const uint32_t &size);

  XrlCmdError
  set_syslog_file(const string &file,
		  const string &facility,
		  const string &level);

  XrlCmdError
  delete_syslog_file(const string &file,
		     const string &facility,
		     const string &level);
  
  XrlCmdError
  set_syslog_file(const string &file,
		  const uint32_t &files,
		  const uint32_t &size);

  XrlCmdError
  delete_syslog_file(const string &file,
		  const uint32_t &files,
		  const uint32_t &size);

  XrlCmdError
  set_syslog_host(const string& host,			   
		  const string& facility,
		  const string& level);

  XrlCmdError
  delete_syslog_host(const string& host,			   
		     const string& facility,
		     const string& level);
  
  XrlCmdError
  set_syslog_host(const string& host,			   
		  const string& prefix);

  XrlCmdError
  delete_syslog_host(const string& host,			   
		  const string& prefix);

  XrlCmdError
  set_syslog_user(const string& host,			   
		  const string& facility,
		  const string& level);

  XrlCmdError
  delete_syslog_user(const string& host,			   
		     const string& facility,
		     const string& level);

private: //methods
  XrlCmdError
  update_syslog(const string &match_one, const string &match_two, const string &update_line);

  XrlCmdError
  update_logrotate(const string &match, const uint32_t &files, const uint32_t &size, bool set);

private: //variables
  string _syslog_filename;
  string _syslog_logrotate_dir;
  string _rl_syslog_conf;
  string _rl_syslog_file_dir;
  string _rl_syslog_system_file;
};

#endif //__RL_SYSLOG_RL_SYSLOG_NODE_HH__
