/*
 * Module: rl_cmds.cc
 *
 * **** License ****
 * Version: VPL 1.0
 *
 * The contents of this file are subject to the Vyatta Public License
 * Version 1.0 ("License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.vyatta.com/vpl
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
 * the License for the specific language governing rights and limitations
 * under the License.
 *
 * This code was originally developed by Vyatta, Inc.
 * Portions created by Vyatta are Copyright (C) 2005, 2006, 2007 Vyatta, Inc.
 * All Rights Reserved.
 *
 * Author: Michael Larson
 * Date: 2005
 * Description:
 *
 * **** End License ****
 *
 */
#include <stdio.h>
#include <errno.h>
#include <dirent.h>
#include <string>
#include <list>
#include <vector>
#include <iostream>
#include <iomanip>
#include <fstream>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include "config.h"
#include "rl_system_module.h"
#include <libxorp/xlog.h>
#include <librl_common/rl_str_proc.hh>
#include <librl_common/rl_fileaccess.hh>
#include <librl_common/rl_validate.hh>
#include <librl_common/rl_command.hh>

using namespace std;

std::list<string>
process_interface_output(const std::list<string> &input);

std::vector<string>
get_ser_iface(const string &serial, string &proto) ;

int main(int argc, char* argv[])
{
    //  XorpUnexpectedHandler x(xorp_unexpected_handler);
    //
    // Initialize and start xlog
    //
    xlog_init(argv[0], NULL);
    xlog_set_verbose(XLOG_VERBOSE_LOW);		// Least verbose messages
    // XXX: verbosity of the error messages temporary increased
    xlog_level_set_verbose(XLOG_LEVEL_ERROR, XLOG_VERBOSE_HIGH);
    xlog_add_default_output();
    xlog_start();
    
    /*
      To handle the parsing of the log file locations
    */
    try {
	if (argc < 2) {
	    printf("rl_cmds: No arguments received, exiting\n");
	    XLOG_ERROR("rl_cmds: No arguments received, exiting");
	    return 1;
	}
	
	/*
	 * Now check for debug options
	 */
	if (strncmp(argv[argc-1], "-d", 2) == 0) {
	    printf("debug option (disabled)\n");
	    //nothing here now
	}
	
	if (strncmp(argv[1], "showlogmessages", 9) == 0) {
	    string cmd("cat `ls /var/log/message* | sort -r`");
	    rl_command::execute(cmd);
	}
	else if (strncmp(argv[1], "showlogsys", 9) == 0) {
	    const string filename(argv[2]);
	    if (filename.empty() == false) {
	      if (filename.find(".") == string::npos && filename.find("/") == string::npos) {
		string cmd("cat /var/log/user/" + filename);
		rl_command::execute(cmd);
	      }
	      else {
		printf("Illegal characters in filename\n");
		XLOG_ERROR("Illegal characters in filename");
	      }
	    }
	}
	else if (strncmp(argv[1], "showleases", 9) == 0) {
	    const string filename(argv[2]);
	    if (filename.empty() == false) {
	      //		string cmd("/bin/busybox dumpleases -r -f /var/log/dhcpd/" + filename + ".leases");
	      string cmd;
	      struct stat buf;
	      if (stat("/var/log/dhcpd.leases", &buf) == 0) {
		if (filename == "*") {
		  cmd = "cat /var/log/dhcpd.leases";
		}
		else {
		  cmd = "cat /var/log/dhcpd.leases | grep " + filename;
		}
		rl_command::execute(cmd);
	      }
	    }
	}
	else if (strncmp(argv[1], "checkvrrp", 9) == 0) {
	  string vrrp_proc("vrrpd");
	  if (rl_utils::find_process(vrrp_proc) == true) {
	    fprintf(stderr, "Cannot delete address without removing vrrp configuration first\n");
	    return 1;
	  }
	  //	  XLOG_ERROR("rl_interface::check_vrrp didn't find the file --blah: %s", file.c_str());
	  return 0;
	}
	else if (strncmp(argv[1], "clearvrrp", 9) == 0) {
	  string interface;
	  if (argc > 2) {
	    interface = string(argv[2]);
	    //grab interface
	  }

	  string vrrp_proc("vrrpd");
	  if (rl_utils::find_process(vrrp_proc) == false) {
	    fprintf(stderr, "VRRP is not configured\n");
	    return 1;
	  }

	  /*
	    removes all vrrpd files in the /var/log/vrrpd directory. Also needs
	    to force a restart of the vrrpd daemons.
	  */
	  //clear all vrrpd...

	  //restart all vrrpd processes
	  string cmd;
	  string file("/var/vrrpd_state");
	  FILE *fd = fopen(file.c_str(), "r");
	  if (fd != NULL) {
	    char line[256];
	    while (fgets(line, 255, fd) != NULL) {
	      //now restart the process
	      if (!interface.empty()) {
		if (string(line).find(interface) != string::npos) {
		  cmd = string(SBINDIR "/vrrpd.init restart ") + string(line) + " > /dev/null 2> /dev/null";
		  rl_command::execute(cmd.c_str());
		}
	      }
	      else {
		cmd = string(SBINDIR "/vrrpd.init restart ") + string(line) + " > /dev/null 2> /dev/null";
		rl_command::execute(cmd.c_str());
	      }
	    }
	    fclose(fd);
	  }
	}
	else if (strncmp(argv[1], "showvrrpstats", 9) == 0) {
	    /*
	      reads single file and displays results
	    */
	    DIR *dir;
	    bool output_flag = false;
	    struct dirent *ent;
	    if ((dir = opendir("/var/log/vrrpd"))) {
		//iterate over the directory and display the contents of the file...
		while ((ent = readdir(dir))) {
		    //now printf out contents of file
		    if (strncmp(ent->d_name, "vrrpd", 5) == 0) {
			string file = string("/var/log/vrrpd/") + string(ent->d_name);
			FILE *fd = fopen(file.c_str(), "r");
			if (fd != NULL) {
			    char line[256];
			    while (fgets(line, 255, fd) != NULL) {
				string output_line(line);
				printf(output_line.c_str());
				output_flag = true;
			    }
			    fclose(fd);
			}
			printf("\n");
		    }
		    errno = 0;
		}
		closedir(dir);
	    }
	    if (output_flag == false) {
	      printf("\n");
	    }
	}
	else if (strncmp(argv[1], "deletefile", 9) == 0) {
	    const string filename(argv[2]);

	    if (rl_validate::domain_name(filename) == true) {
	      if (filename.empty() == false) {
		struct stat buf;
		string file_plus_dir = "/var/log/user/" + filename;
		if (stat(file_plus_dir.c_str(), &buf) == 0) {
		  string cmd("rm -f " + file_plus_dir);
		  rl_command::execute(cmd);

		  cmd = SBINDIR "/sysklogd.init restart 1> /dev/null 2> /dev/null";
		  rl_command::execute(cmd);
		}
		else {
		  printf("file does not exist: %s\n", filename.c_str());
		}
	      }
	    }
	}
	else if (strncmp(argv[1], "showntpassociations", 9) == 0) {
	  string proc_name(argv[0]);
	  string process("ntpd");
	  if (rl_utils::find_process(process) == false) {
	    fprintf(stderr, "ntp is not configured\n");
	    return 1;
	  }

	  string cmd("ntpq -p");
	  rl_command::execute(cmd);
	}
	else if (strncmp(argv[1], "setdatentp", 9) == 0) {
	    const string address(argv[2]);
	    if (address.empty() == false) {
		string cmd ("ntpdate " + address);
		rl_command::execute(cmd);
	    }
	}
	else if (strncmp(argv[1], "setdateuser", 9) == 0) {
	    const string date(argv[2]);
	    if (date.empty() == false) {
		string cmd ("date " + date);
		rl_command::execute(cmd);
	    }
	}
	else if (strncmp(argv[1], "showdateuser", 9) == 0) {
	    string cmd ("date");
	    rl_command::execute(cmd);
	}
	else if (strncmp(argv[1], "shownatpools", 9) == 0) {
	    string cmd(IPTABLES_PATH "/iptables -t nat -L -n");
	    rl_command::execute(cmd);
	}
	else if (strncmp(argv[1], "shownatstatistics", 9) == 0) {
	    string cmd(IPTABLES_PATH "/iptables -t nat -L -v -x -n");
	    rl_command::execute(cmd);
	}
	else if (strncmp(argv[1], "clearnattranslations", 9) == 0) {
	    string cmd = string(IPTABLES_PATH "/iptables-restore /etc/iptables_nat  1> /dev/null 2> /dev/null");
	    rl_command::execute(cmd);
	}
	else if (strncmp(argv[1], "showbridge", 9) == 0) {
	    string cmd;
	    if (argv[2] == '\0') {
		cmd = "brctl show";
	    } else {
		cmd = "brctl showmacs " + string(argv[2]);
	    }
	    rl_command::execute(cmd);
	}
	else if (strncmp(argv[1], "showintphy", 9) == 0) {
	  list<string> output, input;
	  string cmd = PKGLIBEXECDIR "/show_interfaces";
	  if (argc > 2) { 
	    cmd += string(" -i") + string(argv[2]);
	  }
	  //r_command::execute(cmd); execute a popen and process the every third line for the interface
	  FILE *f = popen(cmd.c_str(), "r");
	  if (f) {
	    char buf[300];
	    while(fgets(buf, 300, f) != NULL) { 
	      //	      printf("a: %s\n", buf);
	      input.push_back(string(buf));
	    }
	  }
	  if (pclose(f) != 0) {
	    printf("failure in command execution\n");
	  }
	  output = process_interface_output(input);
	  list<string>::iterator iter = output.begin();
	  while (iter != output.end()) {
	    string new_cmd("ethtool " + *iter);
	    if (argc == 4) {
	      new_cmd += string(".") + argv[3];
	    }
	    rl_command::execute(new_cmd);
	    ++iter;
	  }
	}
	else if (strncmp(argv[1], "showinterfaces", 9) == 0) {
	  list<string> output, input;
	  string cmd = PKGLIBEXECDIR "/show_interfaces";
	  if (argc > 2) { 
	    cmd += string(" -i") + string(argv[2]);
	  }
	  //r_command::execute(cmd); execute a popen and process the every third line for the interface
	  FILE *f = popen(cmd.c_str(), "r");
	  if (f) {
	    char buf[300];
	    while(fgets(buf, 300, f) != NULL) { 
	      //	      printf("a: %s\n", buf);
	      input.push_back(string(buf));
	    }
	  }
	  if (pclose(f) != 0) {
	    printf("failure in command execution\n");
	  }
	  output = process_interface_output(input);
	  list<string>::iterator iter = output.begin();
	  while (iter != output.end()) {
	    string new_cmd("ip -s addr show " + *iter);
	    if (argc == 4) {
	      new_cmd += string(".") + argv[3];
	    }
	    rl_command::execute(new_cmd);
	    ++iter;
	  }
	}
	else if (strncmp(argv[1], "showsnmpstatistics", 9) == 0) {
	  struct stat buf;
	  if (stat("/proc/snmpstats", &buf) == 0) {
	    string cmd("cat /proc/snmpstats");
	    rl_command::execute(cmd);
	  }
	  else {
	    printf("SNMP is not configured\n");
	  }
	}
	else if (strncmp(argv[1], "clearsnmpstatistics", 9) == 0) {
	  //need to send message to kernel space here!
	  struct stat buf;
	  if (stat("/proc/snmpstats", &buf) == 0) {
	    string cmd("echo '1' > /proc/snmpstats");
	    rl_command::execute(cmd);
	  }
	  else {
	    printf("SNMP is not configured\n");
	  }
	}
	else if (strncmp(argv[1], "rebootsystem", 9) == 0) {
	    string cmd("reboot");
	    rl_command::execute(cmd);
	}
	else if (strncmp(argv[1], "clearlease", 9) == 0) {
	  if (argc <= 2) {
	    return 1;
	  }
	  
	  string match_str = string(argv[2]);
	  
	  //stop dhcpd
	  string cmd = SBINDIR "/dhcpd.init stop 1> /dev/null 2> /dev/null";
	  rl_command::execute(cmd);
	  
	  if (string(argv[2]) == "all") {
	    match_str = string("");
	  }
	  
	  {
	    //open file and clear matched lease
	    FILE *fd_rd, *fd_wr;
	    rl_fileaccess fa("/var/log/dhcpd.leases");
	    bool success = fa.get(fd_rd, fd_wr);
	    if (success == false) {
	      XLOG_ERROR("RLServiceNode: failed to open file /var/log/dhcpd.leases");
	      return 1;
	    }
	    
	    bool found = false;
	    char line[256];
	    while (fgets(line, 255, fd_rd) != NULL) {
	      string match_line(line);
	      if (match_line.find(match_str + " {") == string::npos) {
		if (found == true && match_line.find(string("}")) != string::npos) {
		  found = false;
		  continue;
		}
	      }
	      else {
		found = true;
	      }
	      
	      if (found == false) {
		fputs(line, fd_wr);
	      }
	    }
	  }
	  //restart dhcp
	  cmd = SBINDIR "/dhcpd.init start 1> /dev/null 2> /dev/null";
	  rl_command::execute(cmd);
	}
	else if (strncmp(argv[1], "clrserall", 9) == 0) {
	  string proto, cmd, iface(argv[2]);
	  vector<string> coll = get_ser_iface(iface, proto);
	  vector<string>::iterator iter = coll.begin();
	  while (iter != coll.end()) {
	    string serial = iface + "." + *iter;
	    
	    if (proto == "ppp") {
	      cmd = "/usr/sbin/wanpipemon -i " + serial + " -c fg";
	      rl_command::execute(cmd);
	      
	      cmd = "/usr/sbin/wanpipemon -i " + serial + " -c fd";
	      rl_command::execute(cmd);
	      
	    }
	    else if (proto == "hdlc") {
	      //no specific hdlc commands
	    }
	    else if (proto == "frame") {
	      cmd = "/usr/sbin/wanpipemon -i " + serial + " -c fg";
	      rl_command::execute(cmd);
	      
	      cmd = "/usr/sbin/wanpipemon -i " + serial + " -c fe";
	      rl_command::execute(cmd);
	      
	      cmd = "/usr/sbin/wanpipemon -i " + serial + " -c fi";
	      rl_command::execute(cmd);
	      
	      cmd = "/usr/sbin/wanpipemon -i " + serial + " -c fd";
	      rl_command::execute(cmd);
	    }	    
	    else {
	      //nothing
	    }

	    cmd = "/usr/sbin/wanpipemon -i " + serial + " -c fc";
	    rl_command::execute(cmd);
	    
	    cmd = "/usr/sbin/wanpipemon -i " + serial + " -c fpm";
	    rl_command::execute(cmd);
	    ++iter;
	  }
	}
	else if (strncmp(argv[1], "clrserphys", 9) == 0) {
	  string proto, cmd, iface(argv[2]);
	  vector<string> coll = get_ser_iface(iface, proto);
	  
	  vector<string>::iterator iter = coll.begin();
	  while (iter != coll.end()) {
	    string serial = iface + "." + *iter;

	    if (proto == "ppp") {
	      cmd = "/usr/sbin/wanpipemon -i " + serial + " -c fg";
	      rl_command::execute(cmd);
	      
	      cmd = "/usr/sbin/wanpipemon -i " + serial + " -c fd";
	      rl_command::execute(cmd);
	    }
	    else if (proto == "hdlc") {
	      //no specific hdlc commands
	    }
	    else if (proto == "frame") {
	      cmd = "/usr/sbin/wanpipemon -i " + serial + " -c fg";
	      rl_command::execute(cmd);
	      
	      cmd = "/usr/sbin/wanpipemon -i " + serial + " -c fe";
	      rl_command::execute(cmd);
	      
	      cmd = "/usr/sbin/wanpipemon -i " + serial + " -c fd";
	      rl_command::execute(cmd);
	    }
	    else {
	      //nothing
	    }
	    
	    cmd = "/usr/sbin/wanpipemon -i " + serial + " -c fc";
	    rl_command::execute(cmd);
	    
	    cmd = "/usr/sbin/wanpipemon -i " + serial + " -c fpm";
	    rl_command::execute(cmd);
	    ++iter;
	  }
	}
	else if (strncmp(argv[1], "clrserppp", 9) == 0) {
	  string iface = string(argv[2]) + ".1";
	  string serial(argv[2]);
	  string cmd, proto;

	  vector<string> coll = get_ser_iface(serial, proto);
	  if (proto != "ppp") {
	    printf("PPP is not configured on this interface\n");
	    exit(0);
	  }

	  cmd = "/usr/sbin/wanpipemon -i " + iface + " -c fg";
	  rl_command::execute(cmd);
	  
	  cmd = "/usr/sbin/wanpipemon -i " + iface + " -c fc";
	  rl_command::execute(cmd);
	  
	  cmd = "/usr/sbin/wanpipemon -i " + iface + " -c fp";
	  rl_command::execute(cmd);
	  
	  cmd = "/usr/sbin/wanpipemon -i " + iface + " -c flcp";
	  rl_command::execute(cmd);
	  
	  cmd = "/usr/sbin/wanpipemon -i " + iface + " -c fipc";
	  rl_command::execute(cmd);
	  
	  cmd = "/usr/sbin/wanpipemon -i " + iface + " -c fpap";
	  rl_command::execute(cmd);
	  
	  cmd = "/usr/sbin/wanpipemon -i " + iface + " -c fchp";
	  rl_command::execute(cmd);
	}
	else if (strncmp(argv[1], "clrserhdlc", 9) == 0) {
	  string iface = string(argv[2]) + ".1";
	  string serial(argv[2]);
	  string cmd, proto;
	  vector<string> coll = get_ser_iface(serial, proto);
	  if (proto != "hdlc") {
	    printf("HDLC is not configured on this interface\n");
	    exit(0);
	  }

	  cmd = "/usr/sbin/wanpipemon -i " + iface + " -c fc";
	  rl_command::execute(cmd);
	  
	  cmd = "/usr/sbin/wanpipemon -i " + iface + " -c fo";
	  rl_command::execute(cmd);
	  
	  cmd = "/usr/sbin/wanpipemon -i " + iface + " -c fs";
	  rl_command::execute(cmd);
	}
	else if (strncmp(argv[1], "clrserframe", 9) == 0) {
	  string iface(argv[2]);
	  string serial(argv[2]);
	  string cmd, proto;

	  vector<string> coll = get_ser_iface(serial, proto);
	  if (proto != "frame") {
	    printf("Frame is not configured on this interface\n");
	    exit(0);
	  }

	  vector<string>::iterator iter = coll.begin();
	  while (iter != coll.end()) {
	    cmd = "/usr/sbin/wanpipemon -i " + iface + "." + *iter + " -c fg";
	    rl_command::execute(cmd);
	    
	    cmd = "/usr/sbin/wanpipemon -i " + iface + "." + *iter + " -c fc";
	    rl_command::execute(cmd);
	    
	    cmd = "/usr/sbin/wanpipemon -i " + iface + "." + *iter + " -c fe";
	    rl_command::execute(cmd);
	    
	    cmd = "/usr/sbin/wanpipemon -i " + iface + "." + *iter + " -c fi -d " + *iter;
	    rl_command::execute(cmd);
	    ++iter;
	  }
	}
	else if (strncmp(argv[1], "resetbgpall", 11) == 0) {
	  string cmd = PKGLIBEXECDIR "/call_xrl finder://bgp/bgp/0.2/reset_peer";
	  rl_command::execute(cmd);
	}
	else if (strncmp(argv[1], "resetbgpip", 10) == 0) {
	  string cmd = PKGLIBEXECDIR "/call_xrl finder://bgp/bgp/0.2/reset_peer_ip?peer:ipv4=" + string(argv[2]);
	  rl_command::execute(cmd);
	}
	else if (strncmp(argv[1], "resetbgpas", 10) == 0) {
	  string cmd = PKGLIBEXECDIR "/call_xrl finder://bgp/bgp/0.2/reset_peer_as?as:u32=" + string(argv[2]);
	  rl_command::execute(cmd);
	}
	else {
	  printf("no match for argument, exiting\n");
	  XLOG_ERROR("rl_cmds: no match for argument, exiting\n");
	}
    }
    catch(...) {
      XLOG_ERROR("rl_cmds: Unknown exception thrown");
    }
    return 0;
}

/**
 *
 **/
std::list<string>
process_interface_output(const std::list<string> &input)
{
  list<string> output;
  list<string>::const_iterator iter = input.begin();
  while (iter != input.end()) {
    //parse the output
    if (iter->find_first_not_of(" ") == 0) {
      unsigned int end = iter->find_first_of("/");
      if (end == string::npos) {
	end = iter->find_first_of(":", 0);
      }
      if (end != string::npos) {
	output.push_back(iter->substr(0, end));
      }
    }
    ++iter;
  }
  return output;
}

std::vector<string>
get_ser_iface(const string &serial, string &proto) 
{
  std::vector<string> coll;

  string cmd = PKGLIBEXECDIR "/print_serial_data " + serial;
  FILE *f = popen(cmd.c_str(), "r");

  if (f) {
    char buf[2048];
    while (fgets(buf, 2047, f) != NULL) { 
      string line(buf);


      if (line.find("hdlc") != string::npos) {
	proto = "hdlc";
      }
      else if (line.find("ppp") != string::npos) {
	proto = "ppp";
      }
      else {
	proto = "frame";
      }

      StrProc proc_str(line, "%3B");

      vector<string> del_coll = proc_str.get();
      vector<string>::iterator i = del_coll.begin();
      while (i != del_coll.end()) {
	if (i->find("vif") != string::npos) {
	  string tmp = i->substr(6, i->length()-6);
	  coll.push_back(tmp);
	}
	++i;
      }
    }
    if (f) {
      pclose(f);
    }
  }
  return coll;
}
