/*
 * Module: rl_bridge.hh
 *
 * **** License ****
 * Version: VPL 1.0
 *
 * The contents of this file are subject to the Vyatta Public License
 * Version 1.0 ("License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.vyatta.com/vpl
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
 * the License for the specific language governing rights and limitations
 * under the License.
 *
 * This code was originally developed by Vyatta, Inc.
 * Portions created by Vyatta are Copyright (C) 2005, 2006, 2007 Vyatta, Inc.
 * All Rights Reserved.
 *
 * Author: Michael Larson
 * Date: 2005
 * Description:
 *
 * **** End License ****
 *
 */
#ifndef __RL_SYSTEM_RL_BRIDGE_NODE_HH__
#define __RL_SYSTEM_RL_BRIDGE_NODE_HH__

#include <map>
#include <string>
#include <libxipc/xrl_error.hh>
#include <libxorp/ipv4.hh>

class ZeroInterfaceAddress
{
public:
  ZeroInterfaceAddress(const string &interface);
  ~ZeroInterfaceAddress();

  bool
  success() {return (address_.empty() == false);}

private:
  string
  set_interface(const string address);

private:
  string interface_;
  string address_;
};

class BridgeInterfaceData
{
public:
  uint32_t cost_;
  uint32_t priority_;
  string bridge_;
};

class BridgeData
{
public:
  uint32_t max_hello_age_;
  uint32_t hello_time_;
  uint32_t forwarding_delay_;
  bool stp_;
  bool added_;
};

class RLBridge
{
public:
  typedef map<string, BridgeData> BridgeDataColl;
  typedef map<string, BridgeData>::iterator BridgeDataIter;

  typedef map<string, BridgeInterfaceData> BridgeInterfaceColl;
  typedef map<string, BridgeInterfaceData>::iterator BridgeInterfaceIter;  

public:
  RLBridge();
  ~RLBridge();

  XrlCmdError
  reset();

  XrlCmdError
  start(const string &group);

  XrlCmdError
  commit(const string &group);

  XrlCmdError
  set_stp(const string &group, const bool &stp);

  XrlCmdError
  set_forwarding_delay(const string &group, const uint32_t &forwarding_delay);

  XrlCmdError
  set_hello_time(const string &group, const uint32_t &hello_time);

  XrlCmdError
  set_max_hello_age(const string &group, const uint32_t &max_hello_age);

  XrlCmdError 
  set_priority(const string &interface, const string &group, const uint32_t &priority);

  XrlCmdError 
  set_cost(const string &interface, const string &group, const uint32_t &cost);

private: //methods

private:
  BridgeDataColl bridge_data_coll_;
  BridgeInterfaceColl bridge_interface_coll_;
};

#endif //__RL_SYSTEM_RL_BRIDGE_NODE_HH__
