rl_service_common_get_target_name()
{
    if [ $# -ne 0 ] ; then
        echo "Usage: rl_service_common_get_target_name"
        exit 1
    fi

    XRL="finder://rl_service/common/0.1/get_target_name"
    call_xrl_wrapper -p all "${XRL}"
}

rl_service_common_get_version()
{
    if [ $# -ne 0 ] ; then
        echo "Usage: rl_service_common_get_version"
        exit 1
    fi

    XRL="finder://rl_service/common/0.1/get_version"
    call_xrl_wrapper -p all "${XRL}"
}

rl_service_common_get_status()
{
    if [ $# -ne 0 ] ; then
        echo "Usage: rl_service_common_get_status"
        exit 1
    fi

    XRL="finder://rl_service/common/0.1/get_status"
    call_xrl_wrapper -p all "${XRL}"
}

rl_service_common_shutdown()
{
    if [ $# -ne 0 ] ; then
        echo "Usage: rl_service_common_shutdown"
        exit 1
    fi

    XRL="finder://rl_service/common/0.1/shutdown"
    call_xrl_wrapper -p all "${XRL}"
}

rl_service_rl_service_enable_rl_service()
{
    if [ $# -ne 1 ] ; then
        echo "Usage: rl_service_rl_service_enable_rl_service <enable:bool>"
        exit 1
    fi

    XRL="finder://rl_service/rl_service/0.1/enable_rl_service?enable:bool=$1"
    call_xrl_wrapper -p all "${XRL}"
}

rl_service_rl_service_start_rl_service()
{
    if [ $# -ne 0 ] ; then
        echo "Usage: rl_service_rl_service_start_rl_service"
        exit 1
    fi

    XRL="finder://rl_service/rl_service/0.1/start_rl_service"
    call_xrl_wrapper -p all "${XRL}"
}

rl_service_rl_service_stop_rl_service()
{
    if [ $# -ne 0 ] ; then
        echo "Usage: rl_service_rl_service_stop_rl_service"
        exit 1
    fi

    XRL="finder://rl_service/rl_service/0.1/stop_rl_service"
    call_xrl_wrapper -p all "${XRL}"
}

rl_service_rl_service_shutdown_service()
{
    if [ $# -ne 0 ] ; then
        echo "Usage: rl_service_rl_service_shutdown_service"
        exit 1
    fi

    XRL="finder://rl_service/rl_service/0.1/shutdown_service"
    call_xrl_wrapper -p all "${XRL}"
}

rl_service_rl_service_add_interface()
{
    if [ $# -ne 1 ] ; then
        echo "Usage: rl_service_rl_service_add_interface <address:ipv4>"
        exit 1
    fi

    XRL="finder://rl_service/rl_service/0.1/add_interface?address:ipv4=$1"
    call_xrl_wrapper -p all "${XRL}"
}

rl_service_rl_service_enable_log_trace_all()
{
    if [ $# -ne 1 ] ; then
        echo "Usage: rl_service_rl_service_enable_log_trace_all <enable:bool>"
        exit 1
    fi

    XRL="finder://rl_service/rl_service/0.1/enable_log_trace_all?enable:bool=$1"
    call_xrl_wrapper -p all "${XRL}"
}

rl_service_rl_service_delete_service_dhcp_server()
{
    if [ $# -ne 0 ] ; then
        echo "Usage: rl_service_rl_service_delete_service_dhcp_server"
        exit 1
    fi

    XRL="finder://rl_service/rl_service/0.1/delete_service_dhcp_server"
    call_xrl_wrapper -p all "${XRL}"
}

rl_service_rl_service_delete_service_dhcp_server_name()
{
    if [ $# -ne 1 ] ; then
        echo "Usage: rl_service_rl_service_delete_service_dhcp_server_name <name:txt>"
        exit 1
    fi

    XRL="finder://rl_service/rl_service/0.1/delete_service_dhcp_server_name?name:txt=$1"
    call_xrl_wrapper -p all "${XRL}"
}

rl_service_rl_service_start_service_dhcp_server_name()
{
    if [ $# -ne 1 ] ; then
        echo "Usage: rl_service_rl_service_start_service_dhcp_server_name <name:txt>"
        exit 1
    fi

    XRL="finder://rl_service/rl_service/0.1/start_service_dhcp_server_name?name:txt=$1"
    call_xrl_wrapper -p all "${XRL}"
}

rl_service_rl_service_commit_service_dhcp_server_name()
{
    if [ $# -ne 1 ] ; then
        echo "Usage: rl_service_rl_service_commit_service_dhcp_server_name <name:txt>"
        exit 1
    fi

    XRL="finder://rl_service/rl_service/0.1/commit_service_dhcp_server_name?name:txt=$1"
    call_xrl_wrapper -p all "${XRL}"
}

rl_service_rl_service_set_service_dhcp_server_name_start_stop()
{
    if [ $# -ne 3 ] ; then
        echo "Usage: rl_service_rl_service_set_service_dhcp_server_name_start_stop <name:txt> <start:ipv4> <stop:ipv4>"
        exit 1
    fi

    XRL="finder://rl_service/rl_service/0.1/set_service_dhcp_server_name_start_stop?name:txt=$1&start:ipv4=$2&stop:ipv4=$3"
    call_xrl_wrapper -p all "${XRL}"
}

rl_service_rl_service_delete_service_dhcp_server_name_start_stop()
{
    if [ $# -ne 3 ] ; then
        echo "Usage: rl_service_rl_service_delete_service_dhcp_server_name_start_stop <name:txt> <start:ipv4> <stop:ipv4>"
        exit 1
    fi

    XRL="finder://rl_service/rl_service/0.1/delete_service_dhcp_server_name_start_stop?name:txt=$1&start:ipv4=$2&stop:ipv4=$3"
    call_xrl_wrapper -p all "${XRL}"
}

rl_service_rl_service_set_service_dhcp_server_name_exclude()
{
    if [ $# -ne 2 ] ; then
        echo "Usage: rl_service_rl_service_set_service_dhcp_server_name_exclude <name:txt> <exclude:ipv4>"
        exit 1
    fi

    XRL="finder://rl_service/rl_service/0.1/set_service_dhcp_server_name_exclude?name:txt=$1&exclude:ipv4=$2"
    call_xrl_wrapper -p all "${XRL}"
}

rl_service_rl_service_delete_service_dhcp_server_name_exclude()
{
    if [ $# -ne 2 ] ; then
        echo "Usage: rl_service_rl_service_delete_service_dhcp_server_name_exclude <name:txt> <exclude:ipv4>"
        exit 1
    fi

    XRL="finder://rl_service/rl_service/0.1/delete_service_dhcp_server_name_exclude?name:txt=$1&exclude:ipv4=$2"
    call_xrl_wrapper -p all "${XRL}"
}

rl_service_rl_service_set_service_dhcp_server_name_static_mac()
{
    if [ $# -ne 3 ] ; then
        echo "Usage: rl_service_rl_service_set_service_dhcp_server_name_static_mac <name:txt> <static_addr:ipv4> <mac:mac>"
        exit 1
    fi

    XRL="finder://rl_service/rl_service/0.1/set_service_dhcp_server_name_static_mac?name:txt=$1&static_addr:ipv4=$2&mac:mac=$3"
    call_xrl_wrapper -p all "${XRL}"
}

rl_service_rl_service_delete_service_dhcp_server_name_static_mac()
{
    if [ $# -ne 3 ] ; then
        echo "Usage: rl_service_rl_service_delete_service_dhcp_server_name_static_mac <name:txt> <static_addr:ipv4> <mac:mac>"
        exit 1
    fi

    XRL="finder://rl_service/rl_service/0.1/delete_service_dhcp_server_name_static_mac?name:txt=$1&static_addr:ipv4=$2&mac:mac=$3"
    call_xrl_wrapper -p all "${XRL}"
}

rl_service_rl_service_set_service_dhcp_server_name_default()
{
    if [ $# -ne 2 ] ; then
        echo "Usage: rl_service_rl_service_set_service_dhcp_server_name_default <name:txt> <default_router:ipv4>"
        exit 1
    fi

    XRL="finder://rl_service/rl_service/0.1/set_service_dhcp_server_name_default?name:txt=$1&default_router:ipv4=$2"
    call_xrl_wrapper -p all "${XRL}"
}

rl_service_rl_service_delete_service_dhcp_server_name_default()
{
    if [ $# -ne 2 ] ; then
        echo "Usage: rl_service_rl_service_delete_service_dhcp_server_name_default <name:txt> <default_router:ipv4>"
        exit 1
    fi

    XRL="finder://rl_service/rl_service/0.1/delete_service_dhcp_server_name_default?name:txt=$1&default_router:ipv4=$2"
    call_xrl_wrapper -p all "${XRL}"
}

rl_service_rl_service_set_service_dhcp_server_name_network_mask()
{
    if [ $# -ne 2 ] ; then
        echo "Usage: rl_service_rl_service_set_service_dhcp_server_name_network_mask <name:txt> <network_mask:u32>"
        exit 1
    fi

    XRL="finder://rl_service/rl_service/0.1/set_service_dhcp_server_name_network_mask?name:txt=$1&network_mask:u32=$2"
    call_xrl_wrapper -p all "${XRL}"
}

rl_service_rl_service_delete_service_dhcp_server_name_network_mask()
{
    if [ $# -ne 2 ] ; then
        echo "Usage: rl_service_rl_service_delete_service_dhcp_server_name_network_mask <name:txt> <network_mask:u32>"
        exit 1
    fi

    XRL="finder://rl_service/rl_service/0.1/delete_service_dhcp_server_name_network_mask?name:txt=$1&network_mask:u32=$2"
    call_xrl_wrapper -p all "${XRL}"
}

rl_service_rl_service_set_service_dhcp_server_name_dns()
{
    if [ $# -ne 2 ] ; then
        echo "Usage: rl_service_rl_service_set_service_dhcp_server_name_dns <name:txt> <dns_server:ipv4>"
        exit 1
    fi

    XRL="finder://rl_service/rl_service/0.1/set_service_dhcp_server_name_dns?name:txt=$1&dns_server:ipv4=$2"
    call_xrl_wrapper -p all "${XRL}"
}

rl_service_rl_service_delete_service_dhcp_server_name_dns()
{
    if [ $# -ne 2 ] ; then
        echo "Usage: rl_service_rl_service_delete_service_dhcp_server_name_dns <name:txt> <dns_server:ipv4>"
        exit 1
    fi

    XRL="finder://rl_service/rl_service/0.1/delete_service_dhcp_server_name_dns?name:txt=$1&dns_server:ipv4=$2"
    call_xrl_wrapper -p all "${XRL}"
}

rl_service_rl_service_set_service_dhcp_server_name_wins()
{
    if [ $# -ne 2 ] ; then
        echo "Usage: rl_service_rl_service_set_service_dhcp_server_name_wins <name:txt> <wins_server:ipv4>"
        exit 1
    fi

    XRL="finder://rl_service/rl_service/0.1/set_service_dhcp_server_name_wins?name:txt=$1&wins_server:ipv4=$2"
    call_xrl_wrapper -p all "${XRL}"
}

rl_service_rl_service_delete_service_dhcp_server_name_wins()
{
    if [ $# -ne 2 ] ; then
        echo "Usage: rl_service_rl_service_delete_service_dhcp_server_name_wins <name:txt> <wins_server:ipv4>"
        exit 1
    fi

    XRL="finder://rl_service/rl_service/0.1/delete_service_dhcp_server_name_wins?name:txt=$1&wins_server:ipv4=$2"
    call_xrl_wrapper -p all "${XRL}"
}

rl_service_rl_service_set_service_dhcp_server_name_lease()
{
    if [ $# -ne 2 ] ; then
        echo "Usage: rl_service_rl_service_set_service_dhcp_server_name_lease <name:txt> <lease:u32>"
        exit 1
    fi

    XRL="finder://rl_service/rl_service/0.1/set_service_dhcp_server_name_lease?name:txt=$1&lease:u32=$2"
    call_xrl_wrapper -p all "${XRL}"
}

rl_service_rl_service_delete_service_dhcp_server_name_lease()
{
    if [ $# -ne 2 ] ; then
        echo "Usage: rl_service_rl_service_delete_service_dhcp_server_name_lease <name:txt> <lease:u32>"
        exit 1
    fi

    XRL="finder://rl_service/rl_service/0.1/delete_service_dhcp_server_name_lease?name:txt=$1&lease:u32=$2"
    call_xrl_wrapper -p all "${XRL}"
}

rl_service_rl_service_set_service_dhcp_server_name_interface()
{
    if [ $# -ne 2 ] ; then
        echo "Usage: rl_service_rl_service_set_service_dhcp_server_name_interface <name:txt> <interface:txt>"
        exit 1
    fi

    XRL="finder://rl_service/rl_service/0.1/set_service_dhcp_server_name_interface?name:txt=$1&interface:txt=$2"
    call_xrl_wrapper -p all "${XRL}"
}

rl_service_rl_service_delete_service_dhcp_server_name_interface()
{
    if [ $# -ne 2 ] ; then
        echo "Usage: rl_service_rl_service_delete_service_dhcp_server_name_interface <name:txt> <interface:txt>"
        exit 1
    fi

    XRL="finder://rl_service/rl_service/0.1/delete_service_dhcp_server_name_interface?name:txt=$1&interface:txt=$2"
    call_xrl_wrapper -p all "${XRL}"
}

rl_service_rl_service_set_service_dhcp_server_name_domain_name()
{
    if [ $# -ne 2 ] ; then
        echo "Usage: rl_service_rl_service_set_service_dhcp_server_name_domain_name <name:txt> <domain_name:txt>"
        exit 1
    fi

    XRL="finder://rl_service/rl_service/0.1/set_service_dhcp_server_name_domain_name?name:txt=$1&domain_name:txt=$2"
    call_xrl_wrapper -p all "${XRL}"
}

rl_service_rl_service_delete_service_dhcp_server_name_domain_name()
{
    if [ $# -ne 2 ] ; then
        echo "Usage: rl_service_rl_service_delete_service_dhcp_server_name_domain_name <name:txt> <domain_name:txt>"
        exit 1
    fi

    XRL="finder://rl_service/rl_service/0.1/delete_service_dhcp_server_name_domain_name?name:txt=$1&domain_name:txt=$2"
    call_xrl_wrapper -p all "${XRL}"
}

rl_service_rl_service_set_service_dhcp_server_name_authoritative()
{
    if [ $# -ne 2 ] ; then
        echo "Usage: rl_service_rl_service_set_service_dhcp_server_name_authoritative <name:txt> <enable:txt>"
        exit 1
    fi

    XRL="finder://rl_service/rl_service/0.1/set_service_dhcp_server_name_authoritative?name:txt=$1&enable:txt=$2"
    call_xrl_wrapper -p all "${XRL}"
}

rl_service_rl_service_delete_service_dhcp_relay_interface()
{
    if [ $# -ne 1 ] ; then
        echo "Usage: rl_service_rl_service_delete_service_dhcp_relay_interface <interface:txt>"
        exit 1
    fi

    XRL="finder://rl_service/rl_service/0.1/delete_service_dhcp_relay_interface?interface:txt=$1"
    call_xrl_wrapper -p all "${XRL}"
}

rl_service_rl_service_start_service_dhcp_relay()
{
    if [ $# -ne 1 ] ; then
        echo "Usage: rl_service_rl_service_start_service_dhcp_relay <interface:txt>"
        exit 1
    fi

    XRL="finder://rl_service/rl_service/0.1/start_service_dhcp_relay?interface:txt=$1"
    call_xrl_wrapper -p all "${XRL}"
}

rl_service_rl_service_commit_service_dhcp_relay()
{
    if [ $# -ne 1 ] ; then
        echo "Usage: rl_service_rl_service_commit_service_dhcp_relay <interface:txt>"
        exit 1
    fi

    XRL="finder://rl_service/rl_service/0.1/commit_service_dhcp_relay?interface:txt=$1"
    call_xrl_wrapper -p all "${XRL}"
}

rl_service_rl_service_set_service_dhcp_relay_interface_server()
{
    if [ $# -ne 2 ] ; then
        echo "Usage: rl_service_rl_service_set_service_dhcp_relay_interface_server <interface:txt> <server:ipv4>"
        exit 1
    fi

    XRL="finder://rl_service/rl_service/0.1/set_service_dhcp_relay_interface_server?interface:txt=$1&server:ipv4=$2"
    call_xrl_wrapper -p all "${XRL}"
}

rl_service_rl_service_delete_service_dhcp_relay_interface_server()
{
    if [ $# -ne 2 ] ; then
        echo "Usage: rl_service_rl_service_delete_service_dhcp_relay_interface_server <interface:txt> <server:ipv4>"
        exit 1
    fi

    XRL="finder://rl_service/rl_service/0.1/delete_service_dhcp_relay_interface_server?interface:txt=$1&server:ipv4=$2"
    call_xrl_wrapper -p all "${XRL}"
}

rl_service_rl_service_set_service_dhcp_relay_interface_relay_options_port()
{
    if [ $# -ne 2 ] ; then
        echo "Usage: rl_service_rl_service_set_service_dhcp_relay_interface_relay_options_port <interface:txt> <port:u32>"
        exit 1
    fi

    XRL="finder://rl_service/rl_service/0.1/set_service_dhcp_relay_interface_relay_options_port?interface:txt=$1&port:u32=$2"
    call_xrl_wrapper -p all "${XRL}"
}

rl_service_rl_service_delete_service_dhcp_relay_interface_relay_options_port()
{
    if [ $# -ne 2 ] ; then
        echo "Usage: rl_service_rl_service_delete_service_dhcp_relay_interface_relay_options_port <interface:txt> <port:u32>"
        exit 1
    fi

    XRL="finder://rl_service/rl_service/0.1/delete_service_dhcp_relay_interface_relay_options_port?interface:txt=$1&port:u32=$2"
    call_xrl_wrapper -p all "${XRL}"
}

rl_service_rl_service_set_service_dhcp_relay_interface_relay_options_max_size()
{
    if [ $# -ne 2 ] ; then
        echo "Usage: rl_service_rl_service_set_service_dhcp_relay_interface_relay_options_max_size <interface:txt> <max_size:u32>"
        exit 1
    fi

    XRL="finder://rl_service/rl_service/0.1/set_service_dhcp_relay_interface_relay_options_max_size?interface:txt=$1&max_size:u32=$2"
    call_xrl_wrapper -p all "${XRL}"
}

rl_service_rl_service_delete_service_dhcp_relay_interface_relay_options_max_size()
{
    if [ $# -ne 2 ] ; then
        echo "Usage: rl_service_rl_service_delete_service_dhcp_relay_interface_relay_options_max_size <interface:txt> <max_size:u32>"
        exit 1
    fi

    XRL="finder://rl_service/rl_service/0.1/delete_service_dhcp_relay_interface_relay_options_max_size?interface:txt=$1&max_size:u32=$2"
    call_xrl_wrapper -p all "${XRL}"
}

rl_service_rl_service_set_service_dhcp_relay_interface_relay_options_hop_count()
{
    if [ $# -ne 2 ] ; then
        echo "Usage: rl_service_rl_service_set_service_dhcp_relay_interface_relay_options_hop_count <interface:txt> <hop_count:u32>"
        exit 1
    fi

    XRL="finder://rl_service/rl_service/0.1/set_service_dhcp_relay_interface_relay_options_hop_count?interface:txt=$1&hop_count:u32=$2"
    call_xrl_wrapper -p all "${XRL}"
}

rl_service_rl_service_delete_service_dhcp_relay_interface_relay_options_hop_count()
{
    if [ $# -ne 2 ] ; then
        echo "Usage: rl_service_rl_service_delete_service_dhcp_relay_interface_relay_options_hop_count <interface:txt> <hop_count:u32>"
        exit 1
    fi

    XRL="finder://rl_service/rl_service/0.1/delete_service_dhcp_relay_interface_relay_options_hop_count?interface:txt=$1&hop_count:u32=$2"
    call_xrl_wrapper -p all "${XRL}"
}

rl_service_rl_service_set_service_dhcp_relay_interface_relay_options_relay_agents_packets()
{
    if [ $# -ne 2 ] ; then
        echo "Usage: rl_service_rl_service_set_service_dhcp_relay_interface_relay_options_relay_agents_packets <interface:txt> <relay_agents_packets:txt>"
        exit 1
    fi

    XRL="finder://rl_service/rl_service/0.1/set_service_dhcp_relay_interface_relay_options_relay_agents_packets?interface:txt=$1&relay_agents_packets:txt=$2"
    call_xrl_wrapper -p all "${XRL}"
}

rl_service_rl_service_delete_service_dhcp_relay_interface_relay_options_relay_agents_packets()
{
    if [ $# -ne 2 ] ; then
        echo "Usage: rl_service_rl_service_delete_service_dhcp_relay_interface_relay_options_relay_agents_packets <interface:txt> <relay_agents_packets:txt>"
        exit 1
    fi

    XRL="finder://rl_service/rl_service/0.1/delete_service_dhcp_relay_interface_relay_options_relay_agents_packets?interface:txt=$1&relay_agents_packets:txt=$2"
    call_xrl_wrapper -p all "${XRL}"
}

rl_service_rl_service_set_service_http()
{
    if [ $# -ne 1 ] ; then
        echo "Usage: rl_service_rl_service_set_service_http <port:u32>"
        exit 1
    fi

    XRL="finder://rl_service/rl_service/0.1/set_service_http?port:u32=$1"
    call_xrl_wrapper -p all "${XRL}"
}

rl_service_rl_service_delete_service_http()
{
    if [ $# -ne 1 ] ; then
        echo "Usage: rl_service_rl_service_delete_service_http <port:u32>"
        exit 1
    fi

    XRL="finder://rl_service/rl_service/0.1/delete_service_http?port:u32=$1"
    call_xrl_wrapper -p all "${XRL}"
}

rl_service_rl_service_set_service_ssh()
{
    if [ $# -ne 2 ] ; then
        echo "Usage: rl_service_rl_service_set_service_ssh <port:u32> <protocol_version:txt>"
        exit 1
    fi

    XRL="finder://rl_service/rl_service/0.1/set_service_ssh?port:u32=$1&protocol_version:txt=$2"
    call_xrl_wrapper -p all "${XRL}"
}

rl_service_rl_service_delete_service_ssh()
{
    if [ $# -ne 2 ] ; then
        echo "Usage: rl_service_rl_service_delete_service_ssh <port:u32> <protocol_version:txt>"
        exit 1
    fi

    XRL="finder://rl_service/rl_service/0.1/delete_service_ssh?port:u32=$1&protocol_version:txt=$2"
    call_xrl_wrapper -p all "${XRL}"
}

rl_service_rl_service_set_service_telnet()
{
    if [ $# -ne 1 ] ; then
        echo "Usage: rl_service_rl_service_set_service_telnet <port:u32>"
        exit 1
    fi

    XRL="finder://rl_service/rl_service/0.1/set_service_telnet?port:u32=$1"
    call_xrl_wrapper -p all "${XRL}"
}

rl_service_rl_service_delete_service_telnet()
{
    if [ $# -ne 1 ] ; then
        echo "Usage: rl_service_rl_service_delete_service_telnet <port:u32>"
        exit 1
    fi

    XRL="finder://rl_service/rl_service/0.1/delete_service_telnet?port:u32=$1"
    call_xrl_wrapper -p all "${XRL}"
}

rl_service_rl_service_start_service_nat_rule()
{
    if [ $# -ne 1 ] ; then
        echo "Usage: rl_service_rl_service_start_service_nat_rule <rule:u32>"
        exit 1
    fi

    XRL="finder://rl_service/rl_service/0.1/start_service_nat_rule?rule:u32=$1"
    call_xrl_wrapper -p all "${XRL}"
}

rl_service_rl_service_commit_service_nat_rule()
{
    if [ $# -ne 1 ] ; then
        echo "Usage: rl_service_rl_service_commit_service_nat_rule <rule:u32>"
        exit 1
    fi

    XRL="finder://rl_service/rl_service/0.1/commit_service_nat_rule?rule:u32=$1"
    call_xrl_wrapper -p all "${XRL}"
}

rl_service_rl_service_delete_service_nat_rule()
{
    if [ $# -ne 1 ] ; then
        echo "Usage: rl_service_rl_service_delete_service_nat_rule <rule:u32>"
        exit 1
    fi

    XRL="finder://rl_service/rl_service/0.1/delete_service_nat_rule?rule:u32=$1"
    call_xrl_wrapper -p all "${XRL}"
}

rl_service_rl_service_set_service_nat_rule_type()
{
    if [ $# -ne 1 ] ; then
        echo "Usage: rl_service_rl_service_set_service_nat_rule_type <type:txt>"
        exit 1
    fi

    XRL="finder://rl_service/rl_service/0.1/set_service_nat_rule_type?type:txt=$1"
    call_xrl_wrapper -p all "${XRL}"
}

rl_service_rl_service_delete_service_nat_rule_type()
{
    if [ $# -ne 1 ] ; then
        echo "Usage: rl_service_rl_service_delete_service_nat_rule_type <type:txt>"
        exit 1
    fi

    XRL="finder://rl_service/rl_service/0.1/delete_service_nat_rule_type?type:txt=$1"
    call_xrl_wrapper -p all "${XRL}"
}

rl_service_rl_service_set_service_nat_rule_translation_type()
{
    if [ $# -ne 1 ] ; then
        echo "Usage: rl_service_rl_service_set_service_nat_rule_translation_type <translation_type:txt>"
        exit 1
    fi

    XRL="finder://rl_service/rl_service/0.1/set_service_nat_rule_translation_type?translation_type:txt=$1"
    call_xrl_wrapper -p all "${XRL}"
}

rl_service_rl_service_delete_service_nat_rule_translation_type()
{
    if [ $# -ne 1 ] ; then
        echo "Usage: rl_service_rl_service_delete_service_nat_rule_translation_type <translation_type:txt>"
        exit 1
    fi

    XRL="finder://rl_service/rl_service/0.1/delete_service_nat_rule_translation_type?translation_type:txt=$1"
    call_xrl_wrapper -p all "${XRL}"
}

rl_service_rl_service_set_service_nat_rule_inbound_interface()
{
    if [ $# -ne 1 ] ; then
        echo "Usage: rl_service_rl_service_set_service_nat_rule_inbound_interface <interface:txt>"
        exit 1
    fi

    XRL="finder://rl_service/rl_service/0.1/set_service_nat_rule_inbound_interface?interface:txt=$1"
    call_xrl_wrapper -p all "${XRL}"
}

rl_service_rl_service_delete_service_nat_rule_inbound_interface()
{
    if [ $# -ne 1 ] ; then
        echo "Usage: rl_service_rl_service_delete_service_nat_rule_inbound_interface <interface:txt>"
        exit 1
    fi

    XRL="finder://rl_service/rl_service/0.1/delete_service_nat_rule_inbound_interface?interface:txt=$1"
    call_xrl_wrapper -p all "${XRL}"
}

rl_service_rl_service_set_service_nat_rule_outbound_interface()
{
    if [ $# -ne 1 ] ; then
        echo "Usage: rl_service_rl_service_set_service_nat_rule_outbound_interface <interface:txt>"
        exit 1
    fi

    XRL="finder://rl_service/rl_service/0.1/set_service_nat_rule_outbound_interface?interface:txt=$1"
    call_xrl_wrapper -p all "${XRL}"
}

rl_service_rl_service_delete_service_nat_rule_outbound_interface()
{
    if [ $# -ne 1 ] ; then
        echo "Usage: rl_service_rl_service_delete_service_nat_rule_outbound_interface <interface:txt>"
        exit 1
    fi

    XRL="finder://rl_service/rl_service/0.1/delete_service_nat_rule_outbound_interface?interface:txt=$1"
    call_xrl_wrapper -p all "${XRL}"
}

rl_service_rl_service_set_service_nat_rule_protocol()
{
    if [ $# -ne 1 ] ; then
        echo "Usage: rl_service_rl_service_set_service_nat_rule_protocol <protocol:txt>"
        exit 1
    fi

    XRL="finder://rl_service/rl_service/0.1/set_service_nat_rule_protocol?protocol:txt=$1"
    call_xrl_wrapper -p all "${XRL}"
}

rl_service_rl_service_delete_service_nat_rule_protocol()
{
    if [ $# -ne 1 ] ; then
        echo "Usage: rl_service_rl_service_delete_service_nat_rule_protocol <protocol:txt>"
        exit 1
    fi

    XRL="finder://rl_service/rl_service/0.1/delete_service_nat_rule_protocol?protocol:txt=$1"
    call_xrl_wrapper -p all "${XRL}"
}

rl_service_rl_service_set_service_nat_rule_source_address_address()
{
    if [ $# -ne 1 ] ; then
        echo "Usage: rl_service_rl_service_set_service_nat_rule_source_address_address <address:ipv4>"
        exit 1
    fi

    XRL="finder://rl_service/rl_service/0.1/set_service_nat_rule_source_address_address?address:ipv4=$1"
    call_xrl_wrapper -p all "${XRL}"
}

rl_service_rl_service_delete_service_nat_rule_source_address_address()
{
    if [ $# -ne 1 ] ; then
        echo "Usage: rl_service_rl_service_delete_service_nat_rule_source_address_address <address:ipv4>"
        exit 1
    fi

    XRL="finder://rl_service/rl_service/0.1/delete_service_nat_rule_source_address_address?address:ipv4=$1"
    call_xrl_wrapper -p all "${XRL}"
}

rl_service_rl_service_set_service_nat_rule_source_address_network()
{
    if [ $# -ne 1 ] ; then
        echo "Usage: rl_service_rl_service_set_service_nat_rule_source_address_network <network:ipv4net>"
        exit 1
    fi

    XRL="finder://rl_service/rl_service/0.1/set_service_nat_rule_source_address_network?network:ipv4net=$1"
    call_xrl_wrapper -p all "${XRL}"
}

rl_service_rl_service_delete_service_nat_rule_source_address_network()
{
    if [ $# -ne 1 ] ; then
        echo "Usage: rl_service_rl_service_delete_service_nat_rule_source_address_network <network:ipv4net>"
        exit 1
    fi

    XRL="finder://rl_service/rl_service/0.1/delete_service_nat_rule_source_address_network?network:ipv4net=$1"
    call_xrl_wrapper -p all "${XRL}"
}

rl_service_rl_service_set_service_nat_rule_source_port_port()
{
    if [ $# -ne 1 ] ; then
        echo "Usage: rl_service_rl_service_set_service_nat_rule_source_port_port <port:u32>"
        exit 1
    fi

    XRL="finder://rl_service/rl_service/0.1/set_service_nat_rule_source_port_port?port:u32=$1"
    call_xrl_wrapper -p all "${XRL}"
}

rl_service_rl_service_delete_service_nat_rule_source_port_port()
{
    if [ $# -ne 1 ] ; then
        echo "Usage: rl_service_rl_service_delete_service_nat_rule_source_port_port <port:u32>"
        exit 1
    fi

    XRL="finder://rl_service/rl_service/0.1/delete_service_nat_rule_source_port_port?port:u32=$1"
    call_xrl_wrapper -p all "${XRL}"
}

rl_service_rl_service_set_service_nat_rule_source_port_name()
{
    if [ $# -ne 1 ] ; then
        echo "Usage: rl_service_rl_service_set_service_nat_rule_source_port_name <name:txt>"
        exit 1
    fi

    XRL="finder://rl_service/rl_service/0.1/set_service_nat_rule_source_port_name?name:txt=$1"
    call_xrl_wrapper -p all "${XRL}"
}

rl_service_rl_service_delete_service_nat_rule_source_port_name()
{
    if [ $# -ne 1 ] ; then
        echo "Usage: rl_service_rl_service_delete_service_nat_rule_source_port_name <name:txt>"
        exit 1
    fi

    XRL="finder://rl_service/rl_service/0.1/delete_service_nat_rule_source_port_name?name:txt=$1"
    call_xrl_wrapper -p all "${XRL}"
}

rl_service_rl_service_set_service_nat_rule_source_port_range()
{
    if [ $# -ne 2 ] ; then
        echo "Usage: rl_service_rl_service_set_service_nat_rule_source_port_range <start:u32> <stop:u32>"
        exit 1
    fi

    XRL="finder://rl_service/rl_service/0.1/set_service_nat_rule_source_port_range?start:u32=$1&stop:u32=$2"
    call_xrl_wrapper -p all "${XRL}"
}

rl_service_rl_service_delete_service_nat_rule_source_port_range()
{
    if [ $# -ne 2 ] ; then
        echo "Usage: rl_service_rl_service_delete_service_nat_rule_source_port_range <start:u32> <stop:u32>"
        exit 1
    fi

    XRL="finder://rl_service/rl_service/0.1/delete_service_nat_rule_source_port_range?start:u32=$1&stop:u32=$2"
    call_xrl_wrapper -p all "${XRL}"
}

rl_service_rl_service_set_service_nat_rule_destination_address_address()
{
    if [ $# -ne 1 ] ; then
        echo "Usage: rl_service_rl_service_set_service_nat_rule_destination_address_address <address:ipv4>"
        exit 1
    fi

    XRL="finder://rl_service/rl_service/0.1/set_service_nat_rule_destination_address_address?address:ipv4=$1"
    call_xrl_wrapper -p all "${XRL}"
}

rl_service_rl_service_delete_service_nat_rule_destination_address_address()
{
    if [ $# -ne 1 ] ; then
        echo "Usage: rl_service_rl_service_delete_service_nat_rule_destination_address_address <address:ipv4>"
        exit 1
    fi

    XRL="finder://rl_service/rl_service/0.1/delete_service_nat_rule_destination_address_address?address:ipv4=$1"
    call_xrl_wrapper -p all "${XRL}"
}

rl_service_rl_service_set_service_nat_rule_destination_address_network()
{
    if [ $# -ne 1 ] ; then
        echo "Usage: rl_service_rl_service_set_service_nat_rule_destination_address_network <network:ipv4net>"
        exit 1
    fi

    XRL="finder://rl_service/rl_service/0.1/set_service_nat_rule_destination_address_network?network:ipv4net=$1"
    call_xrl_wrapper -p all "${XRL}"
}

rl_service_rl_service_delete_service_nat_rule_destination_address_network()
{
    if [ $# -ne 1 ] ; then
        echo "Usage: rl_service_rl_service_delete_service_nat_rule_destination_address_network <network:ipv4net>"
        exit 1
    fi

    XRL="finder://rl_service/rl_service/0.1/delete_service_nat_rule_destination_address_network?network:ipv4net=$1"
    call_xrl_wrapper -p all "${XRL}"
}

rl_service_rl_service_set_service_nat_rule_destination_port_port()
{
    if [ $# -ne 1 ] ; then
        echo "Usage: rl_service_rl_service_set_service_nat_rule_destination_port_port <port:u32>"
        exit 1
    fi

    XRL="finder://rl_service/rl_service/0.1/set_service_nat_rule_destination_port_port?port:u32=$1"
    call_xrl_wrapper -p all "${XRL}"
}

rl_service_rl_service_delete_service_nat_rule_destination_port_port()
{
    if [ $# -ne 1 ] ; then
        echo "Usage: rl_service_rl_service_delete_service_nat_rule_destination_port_port <port:u32>"
        exit 1
    fi

    XRL="finder://rl_service/rl_service/0.1/delete_service_nat_rule_destination_port_port?port:u32=$1"
    call_xrl_wrapper -p all "${XRL}"
}

rl_service_rl_service_set_service_nat_rule_destination_port_name()
{
    if [ $# -ne 1 ] ; then
        echo "Usage: rl_service_rl_service_set_service_nat_rule_destination_port_name <name:txt>"
        exit 1
    fi

    XRL="finder://rl_service/rl_service/0.1/set_service_nat_rule_destination_port_name?name:txt=$1"
    call_xrl_wrapper -p all "${XRL}"
}

rl_service_rl_service_delete_service_nat_rule_destination_port_name()
{
    if [ $# -ne 1 ] ; then
        echo "Usage: rl_service_rl_service_delete_service_nat_rule_destination_port_name <name:txt>"
        exit 1
    fi

    XRL="finder://rl_service/rl_service/0.1/delete_service_nat_rule_destination_port_name?name:txt=$1"
    call_xrl_wrapper -p all "${XRL}"
}

rl_service_rl_service_set_service_nat_rule_destination_port_range()
{
    if [ $# -ne 2 ] ; then
        echo "Usage: rl_service_rl_service_set_service_nat_rule_destination_port_range <start:u32> <stop:u32>"
        exit 1
    fi

    XRL="finder://rl_service/rl_service/0.1/set_service_nat_rule_destination_port_range?start:u32=$1&stop:u32=$2"
    call_xrl_wrapper -p all "${XRL}"
}

rl_service_rl_service_delete_service_nat_rule_destination_port_range()
{
    if [ $# -ne 2 ] ; then
        echo "Usage: rl_service_rl_service_delete_service_nat_rule_destination_port_range <start:u32> <stop:u32>"
        exit 1
    fi

    XRL="finder://rl_service/rl_service/0.1/delete_service_nat_rule_destination_port_range?start:u32=$1&stop:u32=$2"
    call_xrl_wrapper -p all "${XRL}"
}

rl_service_rl_service_set_service_nat_rule_inside_address_address()
{
    if [ $# -ne 1 ] ; then
        echo "Usage: rl_service_rl_service_set_service_nat_rule_inside_address_address <address:ipv4>"
        exit 1
    fi

    XRL="finder://rl_service/rl_service/0.1/set_service_nat_rule_inside_address_address?address:ipv4=$1"
    call_xrl_wrapper -p all "${XRL}"
}

rl_service_rl_service_delete_service_nat_rule_inside_address_address()
{
    if [ $# -ne 1 ] ; then
        echo "Usage: rl_service_rl_service_delete_service_nat_rule_inside_address_address <address:ipv4>"
        exit 1
    fi

    XRL="finder://rl_service/rl_service/0.1/delete_service_nat_rule_inside_address_address?address:ipv4=$1"
    call_xrl_wrapper -p all "${XRL}"
}

rl_service_rl_service_set_service_nat_rule_inside_address_network()
{
    if [ $# -ne 1 ] ; then
        echo "Usage: rl_service_rl_service_set_service_nat_rule_inside_address_network <network:ipv4net>"
        exit 1
    fi

    XRL="finder://rl_service/rl_service/0.1/set_service_nat_rule_inside_address_network?network:ipv4net=$1"
    call_xrl_wrapper -p all "${XRL}"
}

rl_service_rl_service_delete_service_nat_rule_inside_address_network()
{
    if [ $# -ne 1 ] ; then
        echo "Usage: rl_service_rl_service_delete_service_nat_rule_inside_address_network <network:ipv4net>"
        exit 1
    fi

    XRL="finder://rl_service/rl_service/0.1/delete_service_nat_rule_inside_address_network?network:ipv4net=$1"
    call_xrl_wrapper -p all "${XRL}"
}

rl_service_rl_service_set_service_nat_rule_outside_address_address()
{
    if [ $# -ne 1 ] ; then
        echo "Usage: rl_service_rl_service_set_service_nat_rule_outside_address_address <address:ipv4>"
        exit 1
    fi

    XRL="finder://rl_service/rl_service/0.1/set_service_nat_rule_outside_address_address?address:ipv4=$1"
    call_xrl_wrapper -p all "${XRL}"
}

rl_service_rl_service_delete_service_nat_rule_outside_address_address()
{
    if [ $# -ne 1 ] ; then
        echo "Usage: rl_service_rl_service_delete_service_nat_rule_outside_address_address <address:ipv4>"
        exit 1
    fi

    XRL="finder://rl_service/rl_service/0.1/delete_service_nat_rule_outside_address_address?address:ipv4=$1"
    call_xrl_wrapper -p all "${XRL}"
}

rl_service_rl_service_set_service_nat_rule_outside_address_network()
{
    if [ $# -ne 1 ] ; then
        echo "Usage: rl_service_rl_service_set_service_nat_rule_outside_address_network <network:ipv4net>"
        exit 1
    fi

    XRL="finder://rl_service/rl_service/0.1/set_service_nat_rule_outside_address_network?network:ipv4net=$1"
    call_xrl_wrapper -p all "${XRL}"
}

rl_service_rl_service_delete_service_nat_rule_outside_address_network()
{
    if [ $# -ne 1 ] ; then
        echo "Usage: rl_service_rl_service_delete_service_nat_rule_outside_address_network <network:ipv4net>"
        exit 1
    fi

    XRL="finder://rl_service/rl_service/0.1/delete_service_nat_rule_outside_address_network?network:ipv4net=$1"
    call_xrl_wrapper -p all "${XRL}"
}

rl_service_rl_service_set_service_nat_rule_outside_address_range()
{
    if [ $# -ne 2 ] ; then
        echo "Usage: rl_service_rl_service_set_service_nat_rule_outside_address_range <start:ipv4> <stop:ipv4>"
        exit 1
    fi

    XRL="finder://rl_service/rl_service/0.1/set_service_nat_rule_outside_address_range?start:ipv4=$1&stop:ipv4=$2"
    call_xrl_wrapper -p all "${XRL}"
}

rl_service_rl_service_delete_service_nat_rule_outside_address_range()
{
    if [ $# -ne 2 ] ; then
        echo "Usage: rl_service_rl_service_delete_service_nat_rule_outside_address_range <start:ipv4> <stop:ipv4>"
        exit 1
    fi

    XRL="finder://rl_service/rl_service/0.1/delete_service_nat_rule_outside_address_range?start:ipv4=$1&stop:ipv4=$2"
    call_xrl_wrapper -p all "${XRL}"
}

rl_service_rl_service_get_nat_rule_list()
{
    if [ $# -ne 1 ] ; then
        echo "Usage: rl_service_rl_service_get_nat_rule_list <filter:u32>"
        exit 1
    fi

    XRL="finder://rl_service/rl_service/0.1/get_nat_rule_list?filter:u32=$1"
    call_xrl_wrapper -p all "${XRL}"
}

