/**
 * Module: xrl_rl_service_node.hh
 *
 * Author: Michael Larson
 * Date: 2005
 */

#ifndef __RL_SERVICE_XRL_RL_SERVICE_NODE_HH__
#define __RL_SERVICE_XRL_RL_SERVICE_NODE_HH__


//
// RLService XRL-aware node definition.
//

#include "libxorp/status_codes.h"
#include "libxipc/xrl_std_router.hh"
#include "xrl/interfaces/finder_event_notifier_xif.hh"

#include "xrl/targets/rl_service_base.hh"

#include "rl_service_node.hh"

//
// The top-level class that wraps-up everything together under one roof
//
class XrlRLServiceNode :     public XrlStdRouter, /* used for dispatch of xrl messages */
			    public XrlRlServiceTargetBase { /* used for defined interface */
public:
    XrlRLServiceNode(EventLoop&	eventloop,
		    const string&	class_name,
		    const string&	finder_hostname,
		    uint16_t	        finder_port,
		    const string&	finder_target);
    ~XrlRLServiceNode();

    /**
     * Startup the node operation.
     *
     * @return true on success, false on failure.
     */
    bool	startup();

    /**
     * Shutdown the node operation.
     *
     * @return true on success, false on failure.
     */
    XrlCmdError	rl_service_0_1_shutdown_service();

    /**
     * Get a reference to the XrlRouter instance.
     *
     * @return a reference to the XrlRouter (@ref XrlRouter) instance.
     */
    XrlRouter&	xrl_router() { return *this; }

    /**
     * Test if the node processing is done.
     * 
     * @return true if the node processing is done, otherwise false.
     */
    bool	is_done() const { return (_status == PROC_DONE); }

protected:
    //
    // XRL target methods
    //

    /**
     *  Get name of Xrl Target
     */
    XrlCmdError common_0_1_get_target_name(
	// Output values, 
	string&	name);

    /**
     *  Get version string from Xrl Target
     */
    XrlCmdError common_0_1_get_version(
	// Output values, 
	string&	version);

    /**
     *  Get status of Xrl Target
     */
    XrlCmdError common_0_1_get_status(
	// Output values, 
	uint32_t&	status, 
	string&	reason);

    /**
     *  Request clean shutdown of Xrl Target
     */
    XrlCmdError common_0_1_shutdown();

    /**
     *  Announce target birth to observer.
     *
     *  @param target_class the target class name.
     *
     *  @param target_instance the target instance name.
     */
    XrlCmdError finder_event_observer_0_1_xrl_target_birth(
	// Input values,
	const string&	target_class,
	const string&	target_instance);

    /**
     *  Announce target death to observer.
     *
     *  @param target_class the target class name.
     *
     *  @param target_instance the target instance name.
     */
    XrlCmdError finder_event_observer_0_1_xrl_target_death(
	// Input values,
	const string&	target_class,
	const string&	target_instance);

    /**
     *  Enable/disable/start/stop RLService
     *
     *  @param enable if true, then enable RLService, otherwise disable it.
     */
    XrlCmdError rl_service_0_1_enable_rl_service(
	// Input values,
	const bool&	enable);

    XrlCmdError rl_service_0_1_start_rl_service();

    XrlCmdError rl_service_0_1_stop_rl_service();

    /**
     *  Configure an interface
     *
     *  @param address of interface
     */
    XrlCmdError rl_service_0_1_add_interface(
	// Input values,
	const IPv4&	address);

    /**
     *  Enable/disable the RLService trace log for all operations.
     *
     *  @param enable if true, then enable the trace log, otherwise disable it.
     */
    XrlCmdError rl_service_0_1_enable_log_trace_all(
	// Input values,
	const bool&	enable);

  XrlCmdError rl_service_0_1_delete_service_dhcp_server();

  XrlCmdError rl_service_0_1_start_service_dhcp_server_name(
							   //Input values,
							   const string &name);

  XrlCmdError rl_service_0_1_commit_service_dhcp_server_name(
							    //Input values,
							    const string &name);
  
  XrlCmdError rl_service_0_1_delete_service_dhcp_server_name(
							    //Input values,
							    const string &name);
  
  XrlCmdError rl_service_0_1_set_service_dhcp_server_name_start_stop(
								    //Input values,
								    const string &name,
								    const IPv4 &start,
								    const IPv4 &stop);
  
  XrlCmdError rl_service_0_1_delete_service_dhcp_server_name_start_stop(
								    //Input values,
								    const string &name,
								    const IPv4 &start,
								    const IPv4 &stop);
  
  XrlCmdError rl_service_0_1_set_service_dhcp_server_name_exclude(
								    //Input values,
								    const string &name,
								    const IPv4 &exclude);
  
  XrlCmdError rl_service_0_1_delete_service_dhcp_server_name_exclude(
								    //Input values,
								    const string &name,
								    const IPv4 &exclude);
  
  XrlCmdError rl_service_0_1_set_service_dhcp_server_name_static_mac(
								    //Input values,
								    const string &name,
								    const IPv4 &static_addr,
								    const Mac &mac);
  
  XrlCmdError rl_service_0_1_delete_service_dhcp_server_name_static_mac(
								    //Input values,
								    const string &name,
								    const IPv4 &static_addr,
								    const Mac &mac);
  
  XrlCmdError rl_service_0_1_set_service_dhcp_server_name_default(
								//Input values,
								const string &name,
								const IPv4 &default_router);
  
  XrlCmdError rl_service_0_1_delete_service_dhcp_server_name_default(
								   //Input values,
								   const string &name,
								   const IPv4 &default_router);
  
  XrlCmdError rl_service_0_1_set_service_dhcp_server_name_network_mask(
								//Input values,
								const string &name,
								const uint32_t &network_mask);
  
  XrlCmdError rl_service_0_1_delete_service_dhcp_server_name_network_mask(
								   //Input values,
								   const string &name,
								   const uint32_t &network_mask);
  
  XrlCmdError rl_service_0_1_set_service_dhcp_server_name_dns(
							    //Input values,
							    const string &name,
							    const IPv4 &dns_server);

  XrlCmdError rl_service_0_1_delete_service_dhcp_server_name_dns(
							       //Input values,
							       const string &name,
							       const IPv4 &dns_server);
  
  XrlCmdError rl_service_0_1_set_service_dhcp_server_name_wins(
							       //Input values,
							       const string &name,
							       const IPv4 &wins_server);

    XrlCmdError rl_service_0_1_delete_service_dhcp_server_name_wins(
								  //Input values,
								  const string &name,
								  const IPv4 &wins_server);

  XrlCmdError rl_service_0_1_set_service_dhcp_server_name_lease(
							//Input values,
							const string &name,
							const uint32_t &lease);

  XrlCmdError rl_service_0_1_delete_service_dhcp_server_name_lease(
							   //Input values,
							   const string &name,
							   const uint32_t &lease);

  XrlCmdError rl_service_0_1_set_service_dhcp_server_name_interface(
							//Input values,
							const string &name,
							const string &interface);

  XrlCmdError rl_service_0_1_delete_service_dhcp_server_name_interface(
							   //Input values,
							   const string &name,
							   const string &interface);

  XrlCmdError rl_service_0_1_set_service_dhcp_server_name_domain_name(
							//Input values,
							const string &name,
							const string &domain_name);

  XrlCmdError rl_service_0_1_delete_service_dhcp_server_name_domain_name(
							   //Input values,
							   const string &name,
							   const string &domain_name);

  XrlCmdError rl_service_0_1_set_service_dhcp_server_name_authoritative(
							//Input values,
							const string &name,
							const string &enable);

  XrlCmdError rl_service_0_1_delete_service_dhcp_relay_interface(
				      const string &interface);

  XrlCmdError rl_service_0_1_start_service_dhcp_relay(
						       const string &interface);

  XrlCmdError rl_service_0_1_commit_service_dhcp_relay(
							  const string &interface);

  XrlCmdError rl_service_0_1_set_service_dhcp_relay_interface_server(
						      //Input values,
						      const string &interface,
						      const IPv4 &server);
  
  XrlCmdError rl_service_0_1_delete_service_dhcp_relay_interface_server(
							 const string &interface,
							 const IPv4 &server);
  
  XrlCmdError rl_service_0_1_set_service_dhcp_relay_interface_relay_options_port(
								  const string &interface,
								  const uint32_t &port);
  
  XrlCmdError rl_service_0_1_delete_service_dhcp_relay_interface_relay_options_port(
								     const string &interface,
								     const uint32_t &port);
  
  XrlCmdError rl_service_0_1_set_service_dhcp_relay_interface_relay_options_max_size(
								      const string &interface,
								      const uint32_t &max_size);
  
  XrlCmdError rl_service_0_1_delete_service_dhcp_relay_interface_relay_options_max_size(
									 const string &interface,
									 const uint32_t &max_size);

  XrlCmdError rl_service_0_1_set_service_dhcp_relay_interface_relay_options_hop_count(
								       const string &interface,
								       const uint32_t &hop_count);
  
  XrlCmdError rl_service_0_1_delete_service_dhcp_relay_interface_relay_options_hop_count(
									  const string &interface,
									  const uint32_t &hop_count);


  XrlCmdError rl_service_0_1_set_service_dhcp_relay_interface_relay_options_relay_agents_packets(
										  const string &interface,
										  const string &relay_agents_packets);
  
  XrlCmdError rl_service_0_1_delete_service_dhcp_relay_interface_relay_options_relay_agents_packets(
										     const string &interface,
										     const string &relay_agents_packets);



    XrlCmdError rl_service_0_1_set_service_http(
					       //Input values,
					       const uint32_t &port);
    XrlCmdError rl_service_0_1_delete_service_http(
					       //Input values,
					       const uint32_t &port);

    XrlCmdError rl_service_0_1_set_service_ssh(
					       //Input values,
					       const uint32_t &port,
					       const string &protocol_version);
    XrlCmdError rl_service_0_1_delete_service_ssh(
					       //Input values,
					       const uint32_t &port,
					       const string &protocol_version);

    XrlCmdError rl_service_0_1_set_service_telnet(
						 //Input values,
						 const uint32_t &port);
    XrlCmdError rl_service_0_1_delete_service_telnet(
						    //Input values,
						    const uint32_t &port);


  XrlCmdError rl_service_0_1_start_service_nat_rule(
						    //Input values,
						    const uint32_t &rule);

  XrlCmdError rl_service_0_1_commit_service_nat_rule(
						    //Input values,
						    const uint32_t &rule);

  XrlCmdError rl_service_0_1_delete_service_nat_rule(
						    //Input values,
						    const uint32_t &rule);


  XrlCmdError rl_service_0_1_set_service_nat_rule_type(
						       //Input values,
						       const string &type);

  XrlCmdError rl_service_0_1_delete_service_nat_rule_type(
						       //Input values,
						       const string &type);

  XrlCmdError rl_service_0_1_set_service_nat_rule_translation_type(
						       //Input values,
						       const string &translation_type);

  XrlCmdError rl_service_0_1_delete_service_nat_rule_translation_type(
						       //Input values,
						       const string &translation_type);

  XrlCmdError rl_service_0_1_set_service_nat_rule_inbound_interface(
						       //Input values,
						       const string &interface);

  XrlCmdError rl_service_0_1_delete_service_nat_rule_inbound_interface(
						       //Input values,
						       const string &interface);

  XrlCmdError rl_service_0_1_set_service_nat_rule_outbound_interface(
						       //Input values,
						       const string &interface);

  XrlCmdError rl_service_0_1_delete_service_nat_rule_outbound_interface(
						       //Input values,
						       const string &interface);

  XrlCmdError rl_service_0_1_set_service_nat_rule_protocol(
						       //Input values,
						       const string &protocol);

  XrlCmdError rl_service_0_1_delete_service_nat_rule_protocol(
						       //Input values,
						       const string &protocol);
 
  XrlCmdError rl_service_0_1_set_service_nat_rule_source_address_address(
									 //Input values,
									 const IPv4 &address);
  
  XrlCmdError rl_service_0_1_delete_service_nat_rule_source_address_address(
									    //Input values,
									    const IPv4 &address);
  
 
  XrlCmdError rl_service_0_1_set_service_nat_rule_source_address_network(
									 //Input values,
									 const IPv4Net &network);
  
  XrlCmdError rl_service_0_1_delete_service_nat_rule_source_address_network(
									    //Input values,
									    const IPv4Net &network);
  
  XrlCmdError rl_service_0_1_set_service_nat_rule_source_port_port(
								   //Input values,
								   const uint32_t &port);
  
  XrlCmdError rl_service_0_1_delete_service_nat_rule_source_port_port(
								      //Input values,
								      const uint32_t &port);
  
  XrlCmdError rl_service_0_1_set_service_nat_rule_source_port_name(
								   //Input values,
								   const string &name);
  
  XrlCmdError rl_service_0_1_delete_service_nat_rule_source_port_name(
								      //Input values,
								      const string &name);
  
  XrlCmdError rl_service_0_1_set_service_nat_rule_source_port_range(
								   //Input values,
								    const uint32_t &start,
								    const uint32_t &stop);
  
  XrlCmdError rl_service_0_1_delete_service_nat_rule_source_port_range(
								      //Input values,
								    const uint32_t &start,
								    const uint32_t &stop);
  
 
  XrlCmdError rl_service_0_1_set_service_nat_rule_destination_address_address(
									      //Input values,
									      const IPv4 &address);
  
  XrlCmdError rl_service_0_1_delete_service_nat_rule_destination_address_address(
										 //Input values,
										 const IPv4 &address);
  
  XrlCmdError rl_service_0_1_set_service_nat_rule_destination_address_network(
									      //Input values,
									      const IPv4Net &network);
  
  XrlCmdError rl_service_0_1_delete_service_nat_rule_destination_address_network(
										 //Input values,
										 const IPv4Net &network);
  
  XrlCmdError rl_service_0_1_set_service_nat_rule_destination_port_port(
								   //Input values,
								   const uint32_t &port);
  
  XrlCmdError rl_service_0_1_delete_service_nat_rule_destination_port_port(
								      //Input values,
								      const uint32_t &port);
  
  XrlCmdError rl_service_0_1_set_service_nat_rule_destination_port_name(
								   //Input values,
								   const string &name);
  
  XrlCmdError rl_service_0_1_delete_service_nat_rule_destination_port_name(
								      //Input values,
								      const string &name);
  
  XrlCmdError rl_service_0_1_set_service_nat_rule_destination_port_range(
								   //Input values,
								    const uint32_t &start,
								    const uint32_t &stop);
  
  XrlCmdError rl_service_0_1_delete_service_nat_rule_destination_port_range(
								      //Input values,
								    const uint32_t &start,
								    const uint32_t &stop);
  
  XrlCmdError rl_service_0_1_set_service_nat_rule_inside_address_address(
						       //Input values,
						       const IPv4 &address);

  XrlCmdError rl_service_0_1_delete_service_nat_rule_inside_address_address(
						       //Input values,
						       const IPv4 &address);

  XrlCmdError rl_service_0_1_set_service_nat_rule_inside_address_network(
						       //Input values,
						       const IPv4Net &network);

  XrlCmdError rl_service_0_1_delete_service_nat_rule_inside_address_network(
						       //Input values,
						       const IPv4Net &network);

  XrlCmdError rl_service_0_1_set_service_nat_rule_outside_address_address(
						       //Input values,
						       const IPv4 &address);

  XrlCmdError rl_service_0_1_delete_service_nat_rule_outside_address_address(
						       //Input values,
						       const IPv4 &address);

  XrlCmdError rl_service_0_1_set_service_nat_rule_outside_address_network(
						       //Input values,
						       const IPv4Net &network);

  XrlCmdError rl_service_0_1_delete_service_nat_rule_outside_address_network(
									     //Input values,
									     const IPv4Net &network);
  
  XrlCmdError rl_service_0_1_set_service_nat_rule_outside_address_range(
									//Input values,
									const IPv4 &start,
									const IPv4 &stop);
  
  XrlCmdError rl_service_0_1_delete_service_nat_rule_outside_address_range(
									   //Input values,
									   const IPv4 &start,
									   const IPv4 &stop);
  
  XrlCmdError rl_service_0_1_get_nat_rule_list(
					       //output values,
					       const uint32_t &filter, 
					       XrlAtomList &rules);
  
private:
    /**
     * Called when Finder connection is established.
     *
     * Note that this method overwrites an XrlRouter virtual method.
     */
    virtual void finder_connect_event();

    /**
     * Called when Finder disconnect occurs.
     *
     * Note that this method overwrites an XrlRouter virtual method.
     */
  virtual void finder_disconnect_event();
  
    const string& my_xrl_target_name() {
      return XrlRlServiceTargetBase::name();
    }
  
  EventLoop&		_eventloop;
  const string	_class_name;
  const string	_instance_name;
  const string	_finder_target;
  
  XrlFinderEventNotifierV0p1Client	_xrl_finder_client;
  
  static const TimeVal RETRY_TIMEVAL;
  
  bool		_is_finder_alive;
  
  RLServiceNode     _rl_service_node;

  uint32_t         _status;
};

#endif // __RL_SERVICE_XRL_RL_SERVICE_NODE_HH__
