rl_serial_common_get_target_name()
{
    if [ $# -ne 0 ] ; then
        echo "Usage: rl_serial_common_get_target_name"
        exit 1
    fi

    XRL="finder://rl_serial/common/0.1/get_target_name"
    call_xrl_wrapper -p all "${XRL}"
}

rl_serial_common_get_version()
{
    if [ $# -ne 0 ] ; then
        echo "Usage: rl_serial_common_get_version"
        exit 1
    fi

    XRL="finder://rl_serial/common/0.1/get_version"
    call_xrl_wrapper -p all "${XRL}"
}

rl_serial_common_get_status()
{
    if [ $# -ne 0 ] ; then
        echo "Usage: rl_serial_common_get_status"
        exit 1
    fi

    XRL="finder://rl_serial/common/0.1/get_status"
    call_xrl_wrapper -p all "${XRL}"
}

rl_serial_common_shutdown()
{
    if [ $# -ne 0 ] ; then
        echo "Usage: rl_serial_common_shutdown"
        exit 1
    fi

    XRL="finder://rl_serial/common/0.1/shutdown"
    call_xrl_wrapper -p all "${XRL}"
}

rl_serial_rl_serial_enable_rl_serial()
{
    if [ $# -ne 1 ] ; then
        echo "Usage: rl_serial_rl_serial_enable_rl_serial <enable:bool>"
        exit 1
    fi

    XRL="finder://rl_serial/rl_serial/0.1/enable_rl_serial?enable:bool=$1"
    call_xrl_wrapper -p all "${XRL}"
}

rl_serial_rl_serial_start_rl_serial()
{
    if [ $# -ne 0 ] ; then
        echo "Usage: rl_serial_rl_serial_start_rl_serial"
        exit 1
    fi

    XRL="finder://rl_serial/rl_serial/0.1/start_rl_serial"
    call_xrl_wrapper -p all "${XRL}"
}

rl_serial_rl_serial_stop_rl_serial()
{
    if [ $# -ne 0 ] ; then
        echo "Usage: rl_serial_rl_serial_stop_rl_serial"
        exit 1
    fi

    XRL="finder://rl_serial/rl_serial/0.1/stop_rl_serial"
    call_xrl_wrapper -p all "${XRL}"
}

rl_serial_rl_serial_shutdown_interfaces()
{
    if [ $# -ne 0 ] ; then
        echo "Usage: rl_serial_rl_serial_shutdown_interfaces"
        exit 1
    fi

    XRL="finder://rl_serial/rl_serial/0.1/shutdown_interfaces"
    call_xrl_wrapper -p all "${XRL}"
}

rl_serial_rl_serial_add_interface()
{
    if [ $# -ne 1 ] ; then
        echo "Usage: rl_serial_rl_serial_add_interface <address:ipv4>"
        exit 1
    fi

    XRL="finder://rl_serial/rl_serial/0.1/add_interface?address:ipv4=$1"
    call_xrl_wrapper -p all "${XRL}"
}

rl_serial_rl_serial_enable_log_trace_all()
{
    if [ $# -ne 1 ] ; then
        echo "Usage: rl_serial_rl_serial_enable_log_trace_all <enable:bool>"
        exit 1
    fi

    XRL="finder://rl_serial/rl_serial/0.1/enable_log_trace_all?enable:bool=$1"
    call_xrl_wrapper -p all "${XRL}"
}

rl_serial_rl_serial_delete_serial()
{
    if [ $# -ne 1 ] ; then
        echo "Usage: rl_serial_rl_serial_delete_serial <serial:txt>"
        exit 1
    fi

    XRL="finder://rl_serial/rl_serial/0.1/delete_serial?serial:txt=$1"
    call_xrl_wrapper -p all "${XRL}"
}

rl_serial_rl_serial_start_serial_transaction()
{
    if [ $# -ne 1 ] ; then
        echo "Usage: rl_serial_rl_serial_start_serial_transaction <serial:txt>"
        exit 1
    fi

    XRL="finder://rl_serial/rl_serial/0.1/start_serial_transaction?serial:txt=$1"
    call_xrl_wrapper -p all "${XRL}"
}

rl_serial_rl_serial_commit_serial_transaction()
{
    if [ $# -ne 1 ] ; then
        echo "Usage: rl_serial_rl_serial_commit_serial_transaction <serial:txt>"
        exit 1
    fi

    XRL="finder://rl_serial/rl_serial/0.1/commit_serial_transaction?serial:txt=$1"
    call_xrl_wrapper -p all "${XRL}"
}

rl_serial_rl_serial_set_encapsulation()
{
    if [ $# -ne 2 ] ; then
        echo "Usage: rl_serial_rl_serial_set_encapsulation <serial:txt> <encapsulation:txt>"
        exit 1
    fi

    XRL="finder://rl_serial/rl_serial/0.1/set_encapsulation?serial:txt=$1&encapsulation:txt=$2"
    call_xrl_wrapper -p all "${XRL}"
}

rl_serial_rl_serial_delete_proto()
{
    if [ $# -ne 2 ] ; then
        echo "Usage: rl_serial_rl_serial_delete_proto <serial:txt> <proto:txt>"
        exit 1
    fi

    XRL="finder://rl_serial/rl_serial/0.1/delete_proto?serial:txt=$1&proto:txt=$2"
    call_xrl_wrapper -p all "${XRL}"
}

rl_serial_rl_serial_delete_vif()
{
    if [ $# -ne 3 ] ; then
        echo "Usage: rl_serial_rl_serial_delete_vif <serial:txt> <proto:txt> <vif:u32>"
        exit 1
    fi

    XRL="finder://rl_serial/rl_serial/0.1/delete_vif?serial:txt=$1&proto:txt=$2&vif:u32=$3"
    call_xrl_wrapper -p all "${XRL}"
}

rl_serial_rl_serial_create_address4()
{
    if [ $# -ne 6 ] ; then
        echo "Usage: rl_serial_rl_serial_create_address4 <serial:txt> <proto:txt> <vif:u32> <address:ipv4> <remote_address:ipv4> <prefix_length:u32>"
        exit 1
    fi

    XRL="finder://rl_serial/rl_serial/0.1/create_address4?serial:txt=$1&proto:txt=$2&vif:u32=$3&address:ipv4=$4&remote_address:ipv4=$5&prefix_length:u32=$6"
    call_xrl_wrapper -p all "${XRL}"
}

rl_serial_rl_serial_delete_address4()
{
    if [ $# -ne 6 ] ; then
        echo "Usage: rl_serial_rl_serial_delete_address4 <serial:txt> <proto:txt> <vif:u32> <address:ipv4> <remote_address:ipv4> <prefix_length:u32>"
        exit 1
    fi

    XRL="finder://rl_serial/rl_serial/0.1/delete_address4?serial:txt=$1&proto:txt=$2&vif:u32=$3&address:ipv4=$4&remote_address:ipv4=$5&prefix_length:u32=$6"
    call_xrl_wrapper -p all "${XRL}"
}

rl_serial_rl_serial_set_dlci()
{
    if [ $# -ne 4 ] ; then
        echo "Usage: rl_serial_rl_serial_set_dlci <serial:txt> <proto:txt> <vif:u32> <dlci:u32>"
        exit 1
    fi

    XRL="finder://rl_serial/rl_serial/0.1/set_dlci?serial:txt=$1&proto:txt=$2&vif:u32=$3&dlci:u32=$4"
    call_xrl_wrapper -p all "${XRL}"
}

rl_serial_rl_serial_set_cir()
{
    if [ $# -ne 4 ] ; then
        echo "Usage: rl_serial_rl_serial_set_cir <serial:txt> <proto:txt> <vif:u32> <cir:u32>"
        exit 1
    fi

    XRL="finder://rl_serial/rl_serial/0.1/set_cir?serial:txt=$1&proto:txt=$2&vif:u32=$3&cir:u32=$4"
    call_xrl_wrapper -p all "${XRL}"
}

rl_serial_rl_serial_set_burst()
{
    if [ $# -ne 4 ] ; then
        echo "Usage: rl_serial_rl_serial_set_burst <serial:txt> <proto:txt> <vif:u32> <burst:u32>"
        exit 1
    fi

    XRL="finder://rl_serial/rl_serial/0.1/set_burst?serial:txt=$1&proto:txt=$2&vif:u32=$3&burst:u32=$4"
    call_xrl_wrapper -p all "${XRL}"
}

rl_serial_rl_serial_set_excess()
{
    if [ $# -ne 4 ] ; then
        echo "Usage: rl_serial_rl_serial_set_excess <serial:txt> <proto:txt> <vif:u32> <excess:u32>"
        exit 1
    fi

    XRL="finder://rl_serial/rl_serial/0.1/set_excess?serial:txt=$1&proto:txt=$2&vif:u32=$3&excess:u32=$4"
    call_xrl_wrapper -p all "${XRL}"
}

rl_serial_rl_serial_set_tx_inverse_arp()
{
    if [ $# -ne 4 ] ; then
        echo "Usage: rl_serial_rl_serial_set_tx_inverse_arp <serial:txt> <proto:txt> <vif:u32> <tx_inverse_arp:u32>"
        exit 1
    fi

    XRL="finder://rl_serial/rl_serial/0.1/set_tx_inverse_arp?serial:txt=$1&proto:txt=$2&vif:u32=$3&tx_inverse_arp:u32=$4"
    call_xrl_wrapper -p all "${XRL}"
}

rl_serial_rl_serial_set_rx_inverse_arp()
{
    if [ $# -ne 4 ] ; then
        echo "Usage: rl_serial_rl_serial_set_rx_inverse_arp <serial:txt> <proto:txt> <vif:u32> <rx_inverse_arp:txt>"
        exit 1
    fi

    XRL="finder://rl_serial/rl_serial/0.1/set_rx_inverse_arp?serial:txt=$1&proto:txt=$2&vif:u32=$3&rx_inverse_arp:txt=$4"
    call_xrl_wrapper -p all "${XRL}"
}

rl_serial_rl_serial_set_card_type()
{
    if [ $# -ne 2 ] ; then
        echo "Usage: rl_serial_rl_serial_set_card_type <serial:txt> <card_type:txt>"
        exit 1
    fi

    XRL="finder://rl_serial/rl_serial/0.1/set_card_type?serial:txt=$1&card_type:txt=$2"
    call_xrl_wrapper -p all "${XRL}"
}

rl_serial_rl_serial_delete_physical()
{
    if [ $# -ne 1 ] ; then
        echo "Usage: rl_serial_rl_serial_delete_physical <serial:txt>"
        exit 1
    fi

    XRL="finder://rl_serial/rl_serial/0.1/delete_physical?serial:txt=$1"
    call_xrl_wrapper -p all "${XRL}"
}

rl_serial_rl_serial_set_t1_options_lbo()
{
    if [ $# -ne 2 ] ; then
        echo "Usage: rl_serial_rl_serial_set_t1_options_lbo <serial:txt> <lbo:txt>"
        exit 1
    fi

    XRL="finder://rl_serial/rl_serial/0.1/set_t1_options_lbo?serial:txt=$1&lbo:txt=$2"
    call_xrl_wrapper -p all "${XRL}"
}

rl_serial_rl_serial_set_t1_options_line_coding()
{
    if [ $# -ne 2 ] ; then
        echo "Usage: rl_serial_rl_serial_set_t1_options_line_coding <serial:txt> <line_coding:txt>"
        exit 1
    fi

    XRL="finder://rl_serial/rl_serial/0.1/set_t1_options_line_coding?serial:txt=$1&line_coding:txt=$2"
    call_xrl_wrapper -p all "${XRL}"
}

rl_serial_rl_serial_set_t1_options_timeslots()
{
    if [ $# -ne 3 ] ; then
        echo "Usage: rl_serial_rl_serial_set_t1_options_timeslots <serial:txt> <start:u32> <stop:u32>"
        exit 1
    fi

    XRL="finder://rl_serial/rl_serial/0.1/set_t1_options_timeslots?serial:txt=$1&start:u32=$2&stop:u32=$3"
    call_xrl_wrapper -p all "${XRL}"
}

rl_serial_rl_serial_set_t1_options_mtu()
{
    if [ $# -ne 2 ] ; then
        echo "Usage: rl_serial_rl_serial_set_t1_options_mtu <serial:txt> <mtu:u32>"
        exit 1
    fi

    XRL="finder://rl_serial/rl_serial/0.1/set_t1_options_mtu?serial:txt=$1&mtu:u32=$2"
    call_xrl_wrapper -p all "${XRL}"
}

rl_serial_rl_serial_set_t1_options_clock()
{
    if [ $# -ne 2 ] ; then
        echo "Usage: rl_serial_rl_serial_set_t1_options_clock <serial:txt> <clock:txt>"
        exit 1
    fi

    XRL="finder://rl_serial/rl_serial/0.1/set_t1_options_clock?serial:txt=$1&clock:txt=$2"
    call_xrl_wrapper -p all "${XRL}"
}

rl_serial_rl_serial_set_e1_options_framing()
{
    if [ $# -ne 2 ] ; then
        echo "Usage: rl_serial_rl_serial_set_e1_options_framing <serial:txt> <framing:txt>"
        exit 1
    fi

    XRL="finder://rl_serial/rl_serial/0.1/set_e1_options_framing?serial:txt=$1&framing:txt=$2"
    call_xrl_wrapper -p all "${XRL}"
}

rl_serial_rl_serial_set_e1_options_line_coding()
{
    if [ $# -ne 2 ] ; then
        echo "Usage: rl_serial_rl_serial_set_e1_options_line_coding <serial:txt> <line_coding:txt>"
        exit 1
    fi

    XRL="finder://rl_serial/rl_serial/0.1/set_e1_options_line_coding?serial:txt=$1&line_coding:txt=$2"
    call_xrl_wrapper -p all "${XRL}"
}

rl_serial_rl_serial_set_e1_options_timeslots()
{
    if [ $# -ne 3 ] ; then
        echo "Usage: rl_serial_rl_serial_set_e1_options_timeslots <serial:txt> <start:u32> <stop:u32>"
        exit 1
    fi

    XRL="finder://rl_serial/rl_serial/0.1/set_e1_options_timeslots?serial:txt=$1&start:u32=$2&stop:u32=$3"
    call_xrl_wrapper -p all "${XRL}"
}

rl_serial_rl_serial_set_e1_options_mtu()
{
    if [ $# -ne 2 ] ; then
        echo "Usage: rl_serial_rl_serial_set_e1_options_mtu <serial:txt> <mtu:u32>"
        exit 1
    fi

    XRL="finder://rl_serial/rl_serial/0.1/set_e1_options_mtu?serial:txt=$1&mtu:u32=$2"
    call_xrl_wrapper -p all "${XRL}"
}

rl_serial_rl_serial_set_e1_options_clock()
{
    if [ $# -ne 2 ] ; then
        echo "Usage: rl_serial_rl_serial_set_e1_options_clock <serial:txt> <clock:txt>"
        exit 1
    fi

    XRL="finder://rl_serial/rl_serial/0.1/set_e1_options_clock?serial:txt=$1&clock:txt=$2"
    call_xrl_wrapper -p all "${XRL}"
}

rl_serial_rl_serial_set_t3_options_framing()
{
    if [ $# -ne 2 ] ; then
        echo "Usage: rl_serial_rl_serial_set_t3_options_framing <serial:txt> <framing:txt>"
        exit 1
    fi

    XRL="finder://rl_serial/rl_serial/0.1/set_t3_options_framing?serial:txt=$1&framing:txt=$2"
    call_xrl_wrapper -p all "${XRL}"
}

rl_serial_rl_serial_set_t3_options_line_coding()
{
    if [ $# -ne 2 ] ; then
        echo "Usage: rl_serial_rl_serial_set_t3_options_line_coding <serial:txt> <line_coding:txt>"
        exit 1
    fi

    XRL="finder://rl_serial/rl_serial/0.1/set_t3_options_line_coding?serial:txt=$1&line_coding:txt=$2"
    call_xrl_wrapper -p all "${XRL}"
}

rl_serial_rl_serial_set_e3_options_framing()
{
    if [ $# -ne 2 ] ; then
        echo "Usage: rl_serial_rl_serial_set_e3_options_framing <serial:txt> <framing:txt>"
        exit 1
    fi

    XRL="finder://rl_serial/rl_serial/0.1/set_e3_options_framing?serial:txt=$1&framing:txt=$2"
    call_xrl_wrapper -p all "${XRL}"
}

rl_serial_rl_serial_set_e3_options_line_coding()
{
    if [ $# -ne 2 ] ; then
        echo "Usage: rl_serial_rl_serial_set_e3_options_line_coding <serial:txt> <line_coding:txt>"
        exit 1
    fi

    XRL="finder://rl_serial/rl_serial/0.1/set_e3_options_line_coding?serial:txt=$1&line_coding:txt=$2"
    call_xrl_wrapper -p all "${XRL}"
}

rl_serial_rl_serial_set_ppp_authentication()
{
    if [ $# -ne 3 ] ; then
        echo "Usage: rl_serial_rl_serial_set_ppp_authentication <serial:txt> <proto:txt> <type:txt>"
        exit 1
    fi

    XRL="finder://rl_serial/rl_serial/0.1/set_ppp_authentication?serial:txt=$1&proto:txt=$2&type:txt=$3"
    call_xrl_wrapper -p all "${XRL}"
}

rl_serial_rl_serial_set_ppp_auth_parameters_user_id()
{
    if [ $# -ne 3 ] ; then
        echo "Usage: rl_serial_rl_serial_set_ppp_auth_parameters_user_id <serial:txt> <proto:txt> <user_id:txt>"
        exit 1
    fi

    XRL="finder://rl_serial/rl_serial/0.1/set_ppp_auth_parameters_user_id?serial:txt=$1&proto:txt=$2&user_id:txt=$3"
    call_xrl_wrapper -p all "${XRL}"
}

rl_serial_rl_serial_set_ppp_auth_parameters_password()
{
    if [ $# -ne 3 ] ; then
        echo "Usage: rl_serial_rl_serial_set_ppp_auth_parameters_password <serial:txt> <proto:txt> <password:txt>"
        exit 1
    fi

    XRL="finder://rl_serial/rl_serial/0.1/set_ppp_auth_parameters_password?serial:txt=$1&proto:txt=$2&password:txt=$3"
    call_xrl_wrapper -p all "${XRL}"
}

rl_serial_rl_serial_set_ppp_auth_parameters_system_name()
{
    if [ $# -ne 3 ] ; then
        echo "Usage: rl_serial_rl_serial_set_ppp_auth_parameters_system_name <serial:txt> <proto:txt> <system_name:txt>"
        exit 1
    fi

    XRL="finder://rl_serial/rl_serial/0.1/set_ppp_auth_parameters_system_name?serial:txt=$1&proto:txt=$2&system_name:txt=$3"
    call_xrl_wrapper -p all "${XRL}"
}

rl_serial_rl_serial_set_cisco_hdlc_keepalives()
{
    if [ $# -ne 4 ] ; then
        echo "Usage: rl_serial_rl_serial_set_cisco_hdlc_keepalives <serial:txt> <proto:txt> <require_rx:txt> <timer:u32>"
        exit 1
    fi

    XRL="finder://rl_serial/rl_serial/0.1/set_cisco_hdlc_keepalives?serial:txt=$1&proto:txt=$2&require_rx:txt=$3&timer:u32=$4"
    call_xrl_wrapper -p all "${XRL}"
}

rl_serial_rl_serial_set_frame_relay_signaling()
{
    if [ $# -ne 3 ] ; then
        echo "Usage: rl_serial_rl_serial_set_frame_relay_signaling <serial:txt> <proto:txt> <signaling:txt>"
        exit 1
    fi

    XRL="finder://rl_serial/rl_serial/0.1/set_frame_relay_signaling?serial:txt=$1&proto:txt=$2&signaling:txt=$3"
    call_xrl_wrapper -p all "${XRL}"
}

rl_serial_rl_serial_set_frame_relay_signaling_options_n391dte()
{
    if [ $# -ne 3 ] ; then
        echo "Usage: rl_serial_rl_serial_set_frame_relay_signaling_options_n391dte <serial:txt> <proto:txt> <n391dte:u32>"
        exit 1
    fi

    XRL="finder://rl_serial/rl_serial/0.1/set_frame_relay_signaling_options_n391dte?serial:txt=$1&proto:txt=$2&n391dte:u32=$3"
    call_xrl_wrapper -p all "${XRL}"
}

rl_serial_rl_serial_set_frame_relay_signaling_options_n392dte()
{
    if [ $# -ne 3 ] ; then
        echo "Usage: rl_serial_rl_serial_set_frame_relay_signaling_options_n392dte <serial:txt> <proto:txt> <n392dte:u32>"
        exit 1
    fi

    XRL="finder://rl_serial/rl_serial/0.1/set_frame_relay_signaling_options_n392dte?serial:txt=$1&proto:txt=$2&n392dte:u32=$3"
    call_xrl_wrapper -p all "${XRL}"
}

rl_serial_rl_serial_set_frame_relay_signaling_options_n393dte()
{
    if [ $# -ne 3 ] ; then
        echo "Usage: rl_serial_rl_serial_set_frame_relay_signaling_options_n393dte <serial:txt> <proto:txt> <n393dte:u32>"
        exit 1
    fi

    XRL="finder://rl_serial/rl_serial/0.1/set_frame_relay_signaling_options_n393dte?serial:txt=$1&proto:txt=$2&n393dte:u32=$3"
    call_xrl_wrapper -p all "${XRL}"
}

rl_serial_rl_serial_set_frame_relay_signaling_options_t391dte()
{
    if [ $# -ne 3 ] ; then
        echo "Usage: rl_serial_rl_serial_set_frame_relay_signaling_options_t391dte <serial:txt> <proto:txt> <t391dte:u32>"
        exit 1
    fi

    XRL="finder://rl_serial/rl_serial/0.1/set_frame_relay_signaling_options_t391dte?serial:txt=$1&proto:txt=$2&t391dte:u32=$3"
    call_xrl_wrapper -p all "${XRL}"
}

rl_serial_rl_serial_set_serial_firewall_name()
{
    if [ $# -ne 5 ] ; then
        echo "Usage: rl_serial_rl_serial_set_serial_firewall_name <serial:txt> <vif:u32> <proto:txt> <firewall_name:txt> <filter:txt>"
        exit 1
    fi

    XRL="finder://rl_serial/rl_serial/0.1/set_serial_firewall_name?serial:txt=$1&vif:u32=$2&proto:txt=$3&firewall_name:txt=$4&filter:txt=$5"
    call_xrl_wrapper -p all "${XRL}"
}

rl_serial_rl_serial_delete_serial_firewall_name()
{
    if [ $# -ne 5 ] ; then
        echo "Usage: rl_serial_rl_serial_delete_serial_firewall_name <serial:txt> <vif:u32> <proto:txt> <firewall_name:txt> <filter:txt>"
        exit 1
    fi

    XRL="finder://rl_serial/rl_serial/0.1/delete_serial_firewall_name?serial:txt=$1&vif:u32=$2&proto:txt=$3&firewall_name:txt=$4&filter:txt=$5"
    call_xrl_wrapper -p all "${XRL}"
}

rl_serial_rl_serial_get_serial_data()
{
    if [ $# -ne 1 ] ; then
        echo "Usage: rl_serial_rl_serial_get_serial_data <name:txt>"
        exit 1
    fi

    XRL="finder://rl_serial/rl_serial/0.1/get_serial_data?name:txt=$1"
    call_xrl_wrapper -p all "${XRL}"
}

