rl_protocols_common_get_target_name()
{
    if [ $# -ne 0 ] ; then
        echo "Usage: rl_protocols_common_get_target_name"
        exit 1
    fi

    XRL="finder://rl_protocols/common/0.1/get_target_name"
    call_xrl_wrapper -p all "${XRL}"
}

rl_protocols_common_get_version()
{
    if [ $# -ne 0 ] ; then
        echo "Usage: rl_protocols_common_get_version"
        exit 1
    fi

    XRL="finder://rl_protocols/common/0.1/get_version"
    call_xrl_wrapper -p all "${XRL}"
}

rl_protocols_common_get_status()
{
    if [ $# -ne 0 ] ; then
        echo "Usage: rl_protocols_common_get_status"
        exit 1
    fi

    XRL="finder://rl_protocols/common/0.1/get_status"
    call_xrl_wrapper -p all "${XRL}"
}

rl_protocols_common_shutdown()
{
    if [ $# -ne 0 ] ; then
        echo "Usage: rl_protocols_common_shutdown"
        exit 1
    fi

    XRL="finder://rl_protocols/common/0.1/shutdown"
    call_xrl_wrapper -p all "${XRL}"
}

rl_protocols_rl_protocols_enable_rl_protocols()
{
    if [ $# -ne 1 ] ; then
        echo "Usage: rl_protocols_rl_protocols_enable_rl_protocols <enable:bool>"
        exit 1
    fi

    XRL="finder://rl_protocols/rl_protocols/0.1/enable_rl_protocols?enable:bool=$1"
    call_xrl_wrapper -p all "${XRL}"
}

rl_protocols_rl_protocols_start_rl_protocols()
{
    if [ $# -ne 0 ] ; then
        echo "Usage: rl_protocols_rl_protocols_start_rl_protocols"
        exit 1
    fi

    XRL="finder://rl_protocols/rl_protocols/0.1/start_rl_protocols"
    call_xrl_wrapper -p all "${XRL}"
}

rl_protocols_rl_protocols_stop_rl_protocols()
{
    if [ $# -ne 0 ] ; then
        echo "Usage: rl_protocols_rl_protocols_stop_rl_protocols"
        exit 1
    fi

    XRL="finder://rl_protocols/rl_protocols/0.1/stop_rl_protocols"
    call_xrl_wrapper -p all "${XRL}"
}

rl_protocols_rl_protocols_shutdown_protocols()
{
    if [ $# -ne 0 ] ; then
        echo "Usage: rl_protocols_rl_protocols_shutdown_protocols"
        exit 1
    fi

    XRL="finder://rl_protocols/rl_protocols/0.1/shutdown_protocols"
    call_xrl_wrapper -p all "${XRL}"
}

rl_protocols_rl_protocols_add_interface()
{
    if [ $# -ne 1 ] ; then
        echo "Usage: rl_protocols_rl_protocols_add_interface <address:ipv4>"
        exit 1
    fi

    XRL="finder://rl_protocols/rl_protocols/0.1/add_interface?address:ipv4=$1"
    call_xrl_wrapper -p all "${XRL}"
}

rl_protocols_rl_protocols_enable_log_trace_all()
{
    if [ $# -ne 1 ] ; then
        echo "Usage: rl_protocols_rl_protocols_enable_log_trace_all <enable:bool>"
        exit 1
    fi

    XRL="finder://rl_protocols/rl_protocols/0.1/enable_log_trace_all?enable:bool=$1"
    call_xrl_wrapper -p all "${XRL}"
}

rl_protocols_rl_protocols_start_protocols_snmp_community_transaction()
{
    if [ $# -ne 0 ] ; then
        echo "Usage: rl_protocols_rl_protocols_start_protocols_snmp_community_transaction"
        exit 1
    fi

    XRL="finder://rl_protocols/rl_protocols/0.1/start_protocols_snmp_community_transaction"
    call_xrl_wrapper -p all "${XRL}"
}

rl_protocols_rl_protocols_commit_protocols_snmp_community_transaction()
{
    if [ $# -ne 0 ] ; then
        echo "Usage: rl_protocols_rl_protocols_commit_protocols_snmp_community_transaction"
        exit 1
    fi

    XRL="finder://rl_protocols/rl_protocols/0.1/commit_protocols_snmp_community_transaction"
    call_xrl_wrapper -p all "${XRL}"
}

rl_protocols_rl_protocols_set_protocols_snmp_community_authorization()
{
    if [ $# -ne 2 ] ; then
        echo "Usage: rl_protocols_rl_protocols_set_protocols_snmp_community_authorization <authorization:txt> <community:txt>"
        exit 1
    fi

    XRL="finder://rl_protocols/rl_protocols/0.1/set_protocols_snmp_community_authorization?authorization:txt=$1&community:txt=$2"
    call_xrl_wrapper -p all "${XRL}"
}

rl_protocols_rl_protocols_delete_protocols_snmp_community_authorization()
{
    if [ $# -ne 2 ] ; then
        echo "Usage: rl_protocols_rl_protocols_delete_protocols_snmp_community_authorization <authorization:txt> <community:txt>"
        exit 1
    fi

    XRL="finder://rl_protocols/rl_protocols/0.1/delete_protocols_snmp_community_authorization?authorization:txt=$1&community:txt=$2"
    call_xrl_wrapper -p all "${XRL}"
}

rl_protocols_rl_protocols_set_protocols_snmp_community_client()
{
    if [ $# -ne 2 ] ; then
        echo "Usage: rl_protocols_rl_protocols_set_protocols_snmp_community_client <client:ipv4> <community:txt>"
        exit 1
    fi

    XRL="finder://rl_protocols/rl_protocols/0.1/set_protocols_snmp_community_client?client:ipv4=$1&community:txt=$2"
    call_xrl_wrapper -p all "${XRL}"
}

rl_protocols_rl_protocols_delete_protocols_snmp_community_client()
{
    if [ $# -ne 2 ] ; then
        echo "Usage: rl_protocols_rl_protocols_delete_protocols_snmp_community_client <client:ipv4> <community:txt>"
        exit 1
    fi

    XRL="finder://rl_protocols/rl_protocols/0.1/delete_protocols_snmp_community_client?client:ipv4=$1&community:txt=$2"
    call_xrl_wrapper -p all "${XRL}"
}

rl_protocols_rl_protocols_set_protocols_snmp_community_network()
{
    if [ $# -ne 2 ] ; then
        echo "Usage: rl_protocols_rl_protocols_set_protocols_snmp_community_network <network:ipv4net> <community:txt>"
        exit 1
    fi

    XRL="finder://rl_protocols/rl_protocols/0.1/set_protocols_snmp_community_network?network:ipv4net=$1&community:txt=$2"
    call_xrl_wrapper -p all "${XRL}"
}

rl_protocols_rl_protocols_delete_protocols_snmp_community_network()
{
    if [ $# -ne 2 ] ; then
        echo "Usage: rl_protocols_rl_protocols_delete_protocols_snmp_community_network <network:ipv4net> <community:txt>"
        exit 1
    fi

    XRL="finder://rl_protocols/rl_protocols/0.1/delete_protocols_snmp_community_network?network:ipv4net=$1&community:txt=$2"
    call_xrl_wrapper -p all "${XRL}"
}

rl_protocols_rl_protocols_delete_protocols_snmp_community()
{
    if [ $# -ne 1 ] ; then
        echo "Usage: rl_protocols_rl_protocols_delete_protocols_snmp_community <community:txt>"
        exit 1
    fi

    XRL="finder://rl_protocols/rl_protocols/0.1/delete_protocols_snmp_community?community:txt=$1"
    call_xrl_wrapper -p all "${XRL}"
}

rl_protocols_rl_protocols_set_protocols_snmp_trap_target()
{
    if [ $# -ne 1 ] ; then
        echo "Usage: rl_protocols_rl_protocols_set_protocols_snmp_trap_target <trap_target:ipv4>"
        exit 1
    fi

    XRL="finder://rl_protocols/rl_protocols/0.1/set_protocols_snmp_trap_target?trap_target:ipv4=$1"
    call_xrl_wrapper -p all "${XRL}"
}

rl_protocols_rl_protocols_delete_protocols_snmp_trap_target()
{
    if [ $# -ne 1 ] ; then
        echo "Usage: rl_protocols_rl_protocols_delete_protocols_snmp_trap_target <trap_target:ipv4>"
        exit 1
    fi

    XRL="finder://rl_protocols/rl_protocols/0.1/delete_protocols_snmp_trap_target?trap_target:ipv4=$1"
    call_xrl_wrapper -p all "${XRL}"
}

rl_protocols_rl_protocols_set_protocols_snmp_contact()
{
    if [ $# -ne 1 ] ; then
        echo "Usage: rl_protocols_rl_protocols_set_protocols_snmp_contact <contact:txt>"
        exit 1
    fi

    XRL="finder://rl_protocols/rl_protocols/0.1/set_protocols_snmp_contact?contact:txt=$1"
    call_xrl_wrapper -p all "${XRL}"
}

rl_protocols_rl_protocols_delete_protocols_snmp_contact()
{
    if [ $# -ne 1 ] ; then
        echo "Usage: rl_protocols_rl_protocols_delete_protocols_snmp_contact <contact:txt>"
        exit 1
    fi

    XRL="finder://rl_protocols/rl_protocols/0.1/delete_protocols_snmp_contact?contact:txt=$1"
    call_xrl_wrapper -p all "${XRL}"
}

rl_protocols_rl_protocols_set_protocols_snmp_description()
{
    if [ $# -ne 1 ] ; then
        echo "Usage: rl_protocols_rl_protocols_set_protocols_snmp_description <description:txt>"
        exit 1
    fi

    XRL="finder://rl_protocols/rl_protocols/0.1/set_protocols_snmp_description?description:txt=$1"
    call_xrl_wrapper -p all "${XRL}"
}

rl_protocols_rl_protocols_delete_protocols_snmp_description()
{
    if [ $# -ne 1 ] ; then
        echo "Usage: rl_protocols_rl_protocols_delete_protocols_snmp_description <description:txt>"
        exit 1
    fi

    XRL="finder://rl_protocols/rl_protocols/0.1/delete_protocols_snmp_description?description:txt=$1"
    call_xrl_wrapper -p all "${XRL}"
}

rl_protocols_rl_protocols_set_protocols_snmp_location()
{
    if [ $# -ne 1 ] ; then
        echo "Usage: rl_protocols_rl_protocols_set_protocols_snmp_location <location:txt>"
        exit 1
    fi

    XRL="finder://rl_protocols/rl_protocols/0.1/set_protocols_snmp_location?location:txt=$1"
    call_xrl_wrapper -p all "${XRL}"
}

rl_protocols_rl_protocols_delete_protocols_snmp_location()
{
    if [ $# -ne 1 ] ; then
        echo "Usage: rl_protocols_rl_protocols_delete_protocols_snmp_location <location:txt>"
        exit 1
    fi

    XRL="finder://rl_protocols/rl_protocols/0.1/delete_protocols_snmp_location?location:txt=$1"
    call_xrl_wrapper -p all "${XRL}"
}

rl_protocols_rl_protocols_delete_protocols_snmp()
{
    if [ $# -ne 0 ] ; then
        echo "Usage: rl_protocols_rl_protocols_delete_protocols_snmp"
        exit 1
    fi

    XRL="finder://rl_protocols/rl_protocols/0.1/delete_protocols_snmp"
    call_xrl_wrapper -p all "${XRL}"
}

