/**
 * Module: xrl_rl_protocols_node.hh
 *
 * Author: Michael Larson
 * Date: 2005
 */

#ifndef __RL_PROTOCOLS_XRL_RL_PROTOCOLS_NODE_HH__
#define __RL_PROTOCOLS_XRL_RL_PROTOCOLS_NODE_HH__


//
// RLProtocols XRL-aware node definition.
//

#include "libxorp/status_codes.h"
#include "libxipc/xrl_std_router.hh"
#include "xrl/interfaces/finder_event_notifier_xif.hh"

#include "xrl/targets/rl_protocols_base.hh"

#include "rl_protocols_node.hh"

//
// The top-level class that wraps-up everything together under one roof
//
class XrlRLProtocolsNode :     public XrlStdRouter, /* used for dispatch of xrl messages */
			    public XrlRlProtocolsTargetBase { /* used for defined interface */
public:
  XrlRLProtocolsNode(EventLoop&	eventloop,
		     const string&	class_name,
		     const string&	finder_hostname,
		     uint16_t	        finder_port,
		     const string&	finder_target);
  ~XrlRLProtocolsNode();
  
  /**
   * Startup the node operation.
   *
   * @return true on success, false on failure.
   */
  bool	startup();
  
  /**
   * Shutdown the node operation.
   *
   * @return true on success, false on failure.
   */
  XrlCmdError	rl_protocols_0_1_shutdown_protocols();
  
  /**
   * Get a reference to the XrlRouter instance.
   *
   * @return a reference to the XrlRouter (@ref XrlRouter) instance.
   */
  XrlRouter&	xrl_router() { return *this; }
  
  /**
   * Test if the node processing is done.
   * 
   * @return true if the node processing is done, otherwise false.
   */
  bool	is_done() const { return (_status == PROC_DONE); }
  
protected:
  //
  // XRL target methods
  //
  
  /**
   *  Get name of Xrl Target
   */
  XrlCmdError common_0_1_get_target_name(
					 // Output values, 
					 string&	name);
  
  /**
     *  Get version string from Xrl Target
     */
  XrlCmdError common_0_1_get_version(
				     // Output values, 
				     string&	version);
  
  /**
   *  Get status of Xrl Target
   */
  XrlCmdError common_0_1_get_status(
				    // Output values, 
				    uint32_t&	status, 
				    string&	reason);
  
  /**
   *  Request clean shutdown of Xrl Target
   */
  XrlCmdError common_0_1_shutdown();
  
  /**
   *  Announce target birth to observer.
   *
   *  @param target_class the target class name.
   *
   *  @param target_instance the target instance name.
   */
  XrlCmdError finder_event_observer_0_1_xrl_target_birth(
							 // Input values,
							 const string&	target_class,
							 const string&	target_instance);
  
  /**
   *  Announce target death to observer.
   *
   *  @param target_class the target class name.
   *
   *  @param target_instance the target instance name.
   */
  XrlCmdError finder_event_observer_0_1_xrl_target_death(
							 // Input values,
							 const string&	target_class,
							 const string&	target_instance);
  
  /**
   *  Enable/disable/start/stop RLProtocols
   *
   *  @param enable if true, then enable RLProtocols, otherwise disable it.
   */
  XrlCmdError rl_protocols_0_1_enable_rl_protocols(
						   // Input values,
						   const bool&	enable);
  
  XrlCmdError rl_protocols_0_1_start_rl_protocols();
  
  XrlCmdError rl_protocols_0_1_stop_rl_protocols();
  
  /**
   *  Configure an interface
   *
   *  @param address of interface
   */
  XrlCmdError rl_protocols_0_1_add_interface(
					     // Input values,
					     const IPv4&	address);
  
  /**
   *  Enable/disable the RLProtocols trace log for all operations.
   *
   *  @param enable if true, then enable the trace log, otherwise disable it.
   */
  XrlCmdError rl_protocols_0_1_enable_log_trace_all(
						    // Input values,
						    const bool&	enable);
  
  
  XrlCmdError rl_protocols_0_1_start_protocols_snmp_community_transaction(
									  //Input values,
									  );
  XrlCmdError rl_protocols_0_1_commit_protocols_snmp_community_transaction(
									   //Input values,
									   );

  XrlCmdError rl_protocols_0_1_delete_protocols_snmp_community(
							       //Input values,
							       const string &community);

  XrlCmdError rl_protocols_0_1_set_protocols_snmp_community_authorization(
									  //Input values,
									  const string &authorization,
									  const string &community);
  
  XrlCmdError rl_protocols_0_1_delete_protocols_snmp_community_authorization(
									     //Input values,
									     const string &authorization,
									     const string &community);
  
  XrlCmdError rl_protocols_0_1_set_protocols_snmp_community_client(
								   //Input values,
								   const IPv4 &client,
								   const string &community);

  XrlCmdError rl_protocols_0_1_delete_protocols_snmp_community_client(
								      //Input values,
								      const IPv4 &client,
								      const string &community);
  
  XrlCmdError rl_protocols_0_1_set_protocols_snmp_community_network(
								   //Input values,
								   const IPv4Net &network,
								   const string &community);

  XrlCmdError rl_protocols_0_1_delete_protocols_snmp_community_network(
								      //Input values,
								      const IPv4Net &network,
								      const string &community);
  
    XrlCmdError rl_protocols_0_1_set_protocols_snmp_trap_target(
							     //Input values,
							     const IPv4 &trap_target);
    XrlCmdError rl_protocols_0_1_delete_protocols_snmp_trap_target(
							     //Input values,
							     const IPv4 &trap_target);

    XrlCmdError rl_protocols_0_1_set_protocols_snmp_contact(
							     //Input values,
							     const string &contact);
    XrlCmdError rl_protocols_0_1_delete_protocols_snmp_contact(
							     //Input values,
							    const string &contact);

    XrlCmdError rl_protocols_0_1_set_protocols_snmp_description(
							     //Input values,
							     const string &description);
    XrlCmdError rl_protocols_0_1_delete_protocols_snmp_description(
							     //Input values,
								const string &description);

    XrlCmdError rl_protocols_0_1_set_protocols_snmp_location(
							     //Input values,
							  const string &location);
    XrlCmdError rl_protocols_0_1_delete_protocols_snmp_location(
							     //Input values,
							     const string &location);


    XrlCmdError rl_protocols_0_1_delete_protocols_snmp(
						       //Input values
						       );
private:
  /**
   * Called when Finder connection is established.
   *
   * Note that this method overwrites an XrlRouter virtual method.
   */
  virtual void finder_connect_event();
  
  /**
   * Called when Finder disconnect occurs.
   *
   * Note that this method overwrites an XrlRouter virtual method.
   */
  virtual void finder_disconnect_event();
  
  const string& my_xrl_target_name() {
    return XrlRlProtocolsTargetBase::name();
  }
  
  EventLoop&		_eventloop;
  const string	_class_name;
  const string	_instance_name;
  const string	_finder_target;
  
  XrlFinderEventNotifierV0p1Client	_xrl_finder_client;
  
  static const TimeVal RETRY_TIMEVAL;
  
  bool		_is_finder_alive;

  RLProtocolsNode   _rl_protocols_node;
  
  uint32_t          _status;
};

#endif // __RL_PROTOCOLS_XRL_RL_PROTOCOLS_NODE_HH__
