/*
 * Module: rl_protocols_node.hh
 *
 * **** License ****
 * Version: VPL 1.0
 *
 * The contents of this file are subject to the Vyatta Public License
 * Version 1.0 ("License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.vyatta.com/vpl
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
 * the License for the specific language governing rights and limitations
 * under the License.
 *
 * This code was originally developed by Vyatta, Inc.
 * Portions created by Vyatta are Copyright (C) 2005, 2006, 2007 Vyatta, Inc.
 * All Rights Reserved.
 *
 * Author: Michael Larson
 * Date: 2005
 * Description:
 *
 * **** End License ****
 *
 */

#ifndef __RL_PROTOCOLS_RL_PROTOCOLS_NODE_HH__
#define __RL_PROTOCOLS_RL_PROTOCOLS_NODE_HH__

#include <string>
#include <map>
#include <set>
#include <libxipc/xrl_error.hh>
#include <libxorp/ipv4.hh>
#include <libxorp/ipv4net.hh>

class ClientData
{
public:
  typedef std::set<IPv4> ClientColl;
  typedef std::set<IPv4>::iterator ClientIter;
  typedef std::set<IPv4Net> NetworkColl;
  typedef std::set<IPv4Net>::iterator NetworkIter;

public:
  ClientColl _client_coll;
  NetworkColl _network_coll;
  string _authorization;
};


class RLProtocolsNode
{
public:
  typedef std::map<std::string, ClientData > SNMPColl;
  typedef std::map<std::string, ClientData >::iterator SNMPIter;

public:
  RLProtocolsNode();
  ~RLProtocolsNode();

  XrlCmdError reset();
  
  XrlCmdError start_snmp_community(
				   //Input values,
				   );
  XrlCmdError commit_snmp_community(
				    //Input values,
				    );
  
  XrlCmdError delete_snmp_community(
				    //Input values,
				    const string &community);

  XrlCmdError set_snmp_authorization(
				     //Input values,
				     const string &authorization,
				     const string &community);
  
  XrlCmdError delete_snmp_authorization(
				     //Input values,
				     const string &authorization,
				     const string &community);
  
  XrlCmdError set_snmp_community_client(
					//Input values,
					const IPv4 &client,
					const string &community);

  XrlCmdError delete_snmp_community_client(
					   //Input values,
					   const IPv4 &client,
					   const string &community);
  
  XrlCmdError set_snmp_community_network(
					//Input values,
					const IPv4Net &network,
					const string &community);

  XrlCmdError delete_snmp_community_network(
					   //Input values,
					   const IPv4Net &network,
					   const string &community);
  
  XrlCmdError set_snmp_trap_target(
				   //Input values,
				   const IPv4 &trap_target);
  
  XrlCmdError delete_snmp_trap_target(
				      //Input values,
				      const IPv4 &trap_target);
  
  XrlCmdError set_snmp_contact(
			       //Input values,
			       const string &contact);
  
  XrlCmdError delete_snmp_contact(
				  //Input values,
				  const string &contact);
  
  XrlCmdError set_snmp_description(
				   //Input values,
				   const string &description);
  
  XrlCmdError delete_snmp_description(
				      //Input values,
				      const string &description);
  
  XrlCmdError set_snmp_location(
				//Input values,
				const string &location);
  
  XrlCmdError delete_snmp_location(
				   //Input values,
				   const string &location);
  
  XrlCmdError delete_snmp(
			  //Input values,
			    );
  
private: //members
  XrlCmdError
  update_snmp(const string &match_one,
	      const string &match_two,
	      const string &update);
  

private: //variables
  string     _snmpd_config_filename;
  
  SNMPColl   _snmp_coll; 
  list<IPv4> _trap_target;
  string     _contact;
  string     _description;
  string     _location;
};

#endif //__RL_PROTOCOLS_RL_PROTOCOLS_NODE_HH__
