/*
 * Module: rl_serial_fea_mgr.hh
 *
 * **** License ****
 * Version: VPL 1.0
 *
 * The contents of this file are subject to the Vyatta Public License
 * Version 1.0 ("License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.vyatta.com/vpl
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
 * the License for the specific language governing rights and limitations
 * under the License.
 *
 * This code was originally developed by Vyatta, Inc.
 * Portions created by Vyatta are Copyright (C) 2005, 2006, 2007 Vyatta, Inc.
 * All Rights Reserved.
 *
 * Author: Michael Larson
 * Date: 2005
 * Description:
 *
 * **** End License ****
 *
 */
#ifndef __RL_RL_INTERFACES_TUNNEL_FEA_MGR_HH__
#define __RL_RL_INTERFACES_TUNNEL_FEA_MGR_HH__

#include "xrl/interfaces/fea_ifmgr_xif.hh"


class XrlRLInterfacesTunnelNode;

/**
 * Used to manage the interaction/callback from 
 * from manipulation of the fea and interfaces
 *
 **/
class RLFeaMgr
{
public:
  RLFeaMgr(
	   XrlIfmgrV0p1Client &fea_client, 
	   const std::string &fea_target, 
	   const std::string &iface, 
	   const IPv4 &address,
	   uint32_t prefix_length,
	   bool remove, 
	   XrlRLInterfacesTunnelNode *parent, 
	   XrlCmdError (XrlRLInterfacesTunnelNode::*)(const std::string&));
  ~RLFeaMgr() {;}

  /**
   * Iterates through the collection of interfaces to add/delete
   **/
  void
  process();
  void
  set_finder_state(bool state) {_is_finder_alive = state;}

  void
  set_fea_interest(bool state) {_is_fea_registered = state;}


protected:  
  void
  start_delete_interface(const std::string &iface);

  void 
  delete_start_transaction_cb(const XrlError &xrl_error, const uint32_t *tid, IPv4 address);

  void
  delete_interface(const uint32_t tid, const std::string &iface);

  void 
  send_transaction_cb(const XrlError &xrl_error);
  
  void 
  complete_transaction_cb(const XrlError &xrl_error, std::string iface);

  void
  start_add_interface(const std::string &iface);

  void 
  add_start_transaction_cb(const XrlError &xrl_error, const uint32_t *tid, IPv4 address);

  void
  add_interface(const uint32_t tid, const std::string &iface);


private:
  XrlIfmgrV0p1Client _xrl_fea_client;
  std::string _fea_target;
  std::string _iface; //interface we are currently working
  IPv4   _address;
  int    _prefix_length;
  bool _remove;
  bool _is_finder_alive;
  bool _is_fea_registered;
  XrlRLInterfacesTunnelNode *_parent;
  XrlCmdError (XrlRLInterfacesTunnelNode::*_cb)(const std::string&);
  //  void* _cb;
};


#endif //__RL_RL_SERIAL_FEA_MGR_HH__
