rl_interfaces_common_get_target_name()
{
    if [ $# -ne 0 ] ; then
        echo "Usage: rl_interfaces_common_get_target_name"
        exit 1
    fi

    XRL="finder://rl_interfaces/common/0.1/get_target_name"
    call_xrl_wrapper -p all "${XRL}"
}

rl_interfaces_common_get_version()
{
    if [ $# -ne 0 ] ; then
        echo "Usage: rl_interfaces_common_get_version"
        exit 1
    fi

    XRL="finder://rl_interfaces/common/0.1/get_version"
    call_xrl_wrapper -p all "${XRL}"
}

rl_interfaces_common_get_status()
{
    if [ $# -ne 0 ] ; then
        echo "Usage: rl_interfaces_common_get_status"
        exit 1
    fi

    XRL="finder://rl_interfaces/common/0.1/get_status"
    call_xrl_wrapper -p all "${XRL}"
}

rl_interfaces_common_shutdown()
{
    if [ $# -ne 0 ] ; then
        echo "Usage: rl_interfaces_common_shutdown"
        exit 1
    fi

    XRL="finder://rl_interfaces/common/0.1/shutdown"
    call_xrl_wrapper -p all "${XRL}"
}

rl_interfaces_rl_interfaces_enable_rl_interfaces()
{
    if [ $# -ne 1 ] ; then
        echo "Usage: rl_interfaces_rl_interfaces_enable_rl_interfaces <enable:bool>"
        exit 1
    fi

    XRL="finder://rl_interfaces/rl_interfaces/0.1/enable_rl_interfaces?enable:bool=$1"
    call_xrl_wrapper -p all "${XRL}"
}

rl_interfaces_rl_interfaces_start_rl_interfaces()
{
    if [ $# -ne 0 ] ; then
        echo "Usage: rl_interfaces_rl_interfaces_start_rl_interfaces"
        exit 1
    fi

    XRL="finder://rl_interfaces/rl_interfaces/0.1/start_rl_interfaces"
    call_xrl_wrapper -p all "${XRL}"
}

rl_interfaces_rl_interfaces_stop_rl_interfaces()
{
    if [ $# -ne 0 ] ; then
        echo "Usage: rl_interfaces_rl_interfaces_stop_rl_interfaces"
        exit 1
    fi

    XRL="finder://rl_interfaces/rl_interfaces/0.1/stop_rl_interfaces"
    call_xrl_wrapper -p all "${XRL}"
}

rl_interfaces_rl_interfaces_shutdown_interfaces()
{
    if [ $# -ne 0 ] ; then
        echo "Usage: rl_interfaces_rl_interfaces_shutdown_interfaces"
        exit 1
    fi

    XRL="finder://rl_interfaces/rl_interfaces/0.1/shutdown_interfaces"
    call_xrl_wrapper -p all "${XRL}"
}

rl_interfaces_rl_interfaces_start_interface()
{
    if [ $# -ne 1 ] ; then
        echo "Usage: rl_interfaces_rl_interfaces_start_interface <interface:txt>"
        exit 1
    fi

    XRL="finder://rl_interfaces/rl_interfaces/0.1/start_interface?interface:txt=$1"
    call_xrl_wrapper -p all "${XRL}"
}

rl_interfaces_rl_interfaces_commit_interface()
{
    if [ $# -ne 1 ] ; then
        echo "Usage: rl_interfaces_rl_interfaces_commit_interface <interface:txt>"
        exit 1
    fi

    XRL="finder://rl_interfaces/rl_interfaces/0.1/commit_interface?interface:txt=$1"
    call_xrl_wrapper -p all "${XRL}"
}

rl_interfaces_rl_interfaces_enable_log_trace_all()
{
    if [ $# -ne 1 ] ; then
        echo "Usage: rl_interfaces_rl_interfaces_enable_log_trace_all <enable:bool>"
        exit 1
    fi

    XRL="finder://rl_interfaces/rl_interfaces/0.1/enable_log_trace_all?enable:bool=$1"
    call_xrl_wrapper -p all "${XRL}"
}

rl_interfaces_rl_interfaces_start_commit()
{
    if [ $# -ne 0 ] ; then
        echo "Usage: rl_interfaces_rl_interfaces_start_commit"
        exit 1
    fi

    XRL="finder://rl_interfaces/rl_interfaces/0.1/start_commit"
    call_xrl_wrapper -p all "${XRL}"
}

rl_interfaces_rl_interfaces_end_commit()
{
    if [ $# -ne 0 ] ; then
        echo "Usage: rl_interfaces_rl_interfaces_end_commit"
        exit 1
    fi

    XRL="finder://rl_interfaces/rl_interfaces/0.1/end_commit"
    call_xrl_wrapper -p all "${XRL}"
}

rl_interfaces_rl_interfaces_delete_interfaces_vif()
{
    if [ $# -ne 1 ] ; then
        echo "Usage: rl_interfaces_rl_interfaces_delete_interfaces_vif <interface:txt>"
        exit 1
    fi

    XRL="finder://rl_interfaces/rl_interfaces/0.1/delete_interfaces_vif?interface:txt=$1"
    call_xrl_wrapper -p all "${XRL}"
}

rl_interfaces_rl_interfaces_set_interfaces_vif_vrrp_group()
{
    if [ $# -ne 7 ] ; then
        echo "Usage: rl_interfaces_rl_interfaces_set_interfaces_vif_vrrp_group <interface:txt> <authentication:txt> <group:u32> <virtual_address:ipv4> <advertise_interval:u32> <preempt:bool> <priority:u32>"
        exit 1
    fi

    XRL="finder://rl_interfaces/rl_interfaces/0.1/set_interfaces_vif_vrrp_group?interface:txt=$1&authentication:txt=$2&group:u32=$3&virtual_address:ipv4=$4&advertise_interval:u32=$5&preempt:bool=$6&priority:u32=$7"
    call_xrl_wrapper -p all "${XRL}"
}

rl_interfaces_rl_interfaces_delete_interfaces_vif_vrrp_group()
{
    if [ $# -ne 7 ] ; then
        echo "Usage: rl_interfaces_rl_interfaces_delete_interfaces_vif_vrrp_group <interface:txt> <authentication:txt> <group:u32> <virtual_address:ipv4> <advertise_interval:u32> <preempt:bool> <priority:u32>"
        exit 1
    fi

    XRL="finder://rl_interfaces/rl_interfaces/0.1/delete_interfaces_vif_vrrp_group?interface:txt=$1&authentication:txt=$2&group:u32=$3&virtual_address:ipv4=$4&advertise_interval:u32=$5&preempt:bool=$6&priority:u32=$7"
    call_xrl_wrapper -p all "${XRL}"
}

