/*
 * Module: rl_interfaces_node.hh
 *
 * **** License ****
 * Version: VPL 1.0
 *
 * The contents of this file are subject to the Vyatta Public License
 * Version 1.0 ("License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.vyatta.com/vpl
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
 * the License for the specific language governing rights and limitations
 * under the License.
 *
 * This code was originally developed by Vyatta, Inc.
 * Portions created by Vyatta are Copyright (C) 2005, 2006, 2007 Vyatta, Inc.
 * All Rights Reserved.
 *
 * Author: Michael Larson
 * Date: 2005
 * Description:
 *
 * **** End License ****
 *
 */

#ifndef __RL_INTERFACES_RL_INTERFACES_NODE_HH__
#define __RL_INTERFACES_RL_INTERFACES_NODE_HH__

#include <string>
#include <vector>
#include <map>
#include <libxipc/xrl_error.hh>
#include <libxorp/ipv4.hh>
#include <libxorp/ipv4net.hh>


class RLInterfacesNode
{
public:
  typedef map<string, string> VRRPColl;
  typedef map<string, string>::iterator VRRPIter;

public:
  RLInterfacesNode();
  ~RLInterfacesNode();

  XrlCmdError reset();

  XrlCmdError
  set_vrrp_group(
		 //Input values,
		 const string &interface,
		 const string &authentication,
		 const uint32_t &group,
		 const IPv4 &virtual_address,
		 const uint32_t &advertise_interval,
		 const bool &preempt,
		 const uint32_t &priority,
		 const bool &disable_vmac);

  XrlCmdError
  delete_vrrp_group(
		    //Input values,
		    const string &interface,
		    const string &authentication,
		    const uint32_t group,
		    const IPv4 &virtual_address,
		    const uint32_t advertise_interval,
		    const bool preempt,
		    const uint32_t priority,
		    const bool disable_vmac);

  XrlCmdError
  delete_vrrp(
	      //Input values,
	      const string &interface);


  XrlCmdError
  remove_vrrp_entry(
		    //Input values,
		    const string &interface);

  XrlCmdError
  remove_vrrp_entry(
		    //Input values,
		    const string &interface, 
		    const uint32_t &group);

  XrlCmdError
  add_vrrp_entry(
		    //Input values,
		    const string &interface,
		    const uint32_t &group,
		    const string &line);

private:
  XrlCmdError
  dump_vrrp_state();


private: //variables
  string _vrrpd_filename;
  VRRPColl _vrrp_coll;
};

#endif //__RL_INTERFACES_RL_INTERFACES_NODE_HH__

