/**
 * Module: xrl_rl_system_node.hh
 *
 * Author: Michael Larson
 * Date: 2005
 */

#ifndef __RL_FIREWALL_XRL_RL_FIREWALL_NODE_HH__
#define __RL_FIREWALL_XRL_RL_FIREWALL_NODE_HH__


//
// RLSystem XRL-aware node definition.
//

#include "libxorp/status_codes.h"
#include "libxipc/xrl_std_router.hh"
#include "xrl/interfaces/finder_event_notifier_xif.hh"

#include "xrl/targets/rl_interface_firewall_base.hh"

#include "rl_interface_firewall_node.hh"

//
// The top-level class that wraps-up everything together under one roof
//
class XrlRLInterfaceFirewallNode :     public XrlStdRouter, /* used for dispatch of xrl messages */
			      public XrlRlInterfaceFirewallTargetBase { /* used for defined interface */
public:
    XrlRLInterfaceFirewallNode(EventLoop&	eventloop,
		    const string&	class_name,
		    const string&	finder_hostname,
		    uint16_t	        finder_port,
		    const string&	finder_target);
    ~XrlRLInterfaceFirewallNode();

    /**
     * Startup the node operation.
     *
     * @return true on success, false on failure.
     */
    bool	startup();

    /**
     * Shutdown the node operation.
     *
     * @return true on success, false on failure.
     */
    XrlCmdError	rl_interface_firewall_0_1_shutdown_firewall();

    /**
     * Shutdown the node operation.
     *
     * @return true on success, false on failure.
     */
    /**
     * Get a reference to the XrlRouter instance.
     *
     * @return a reference to the XrlRouter (@ref XrlRouter) instance.
     */
    XrlRouter&	xrl_router() { return *this; }

    /**
     * Test if the node processing is done.
     * 
     * @return true if the node processing is done, otherwise false.
     */
    bool	is_done() const { return (_status == PROC_DONE); }

protected:
    //
    // XRL target methods
    //

    /**
     *  Get name of Xrl Target
     */
    XrlCmdError common_0_1_get_target_name(
	// Output values, 
	string&	name);

    /**
     *  Get version string from Xrl Target
     */
    XrlCmdError common_0_1_get_version(
	// Output values, 
	string&	version);

    /**
     *  Get status of Xrl Target
     */
    XrlCmdError common_0_1_get_status(
	// Output values, 
	uint32_t&	status, 
	string&	reason);

    /**
     *  Request clean shutdown of Xrl Target
     */
    XrlCmdError common_0_1_shutdown();

    /**
     *  Announce target birth to observer.
     *
     *  @param target_class the target class name.
     *
     *  @param target_instance the target instance name.
     */
    XrlCmdError finder_event_observer_0_1_xrl_target_birth(
	// Input values,
	const string&	target_class,
	const string&	target_instance);

    /**
     *  Announce target death to observer.
     *
     *  @param target_class the target class name.
     *
     *  @param target_instance the target instance name.
     */
    XrlCmdError finder_event_observer_0_1_xrl_target_death(
	// Input values,
	const string&	target_class,
	const string&	target_instance);

  /**
   * transactions
   **/
  XrlCmdError rl_interface_firewall_0_1_start_firewall() {return XrlCmdError::OKAY();}
  XrlCmdError rl_interface_firewall_0_1_commit_firewall() {return XrlCmdError::OKAY();}
  

  /**
   *
   *
   *
   */
  XrlCmdError rl_interface_firewall_0_1_delete_rl_interface_firewall();

    /**
     *  Enable/disable/start/stop RLSystem
     *
     *  @param enable if true, then enable RLSystem, otherwise disable it.
     */
    XrlCmdError rl_interface_firewall_0_1_enable_rl_interface_firewall(
	// Input values,
	const bool&	enable);

    XrlCmdError rl_interface_firewall_0_1_start_rl_interface_firewall();

    XrlCmdError rl_interface_firewall_0_1_stop_rl_interface_firewall();

    /**
     *  Configure an interface
     *
     *  @param address of interface
     */
    XrlCmdError rl_interface_firewall_0_1_add_interface(
	// Input values,
	const IPv4&	address);

    /**
     *  Enable/disable the RLSystem trace log for all operations.
     *
     *  @param enable if true, then enable the trace log, otherwise disable it.
     */
    XrlCmdError rl_interface_firewall_0_1_enable_log_trace_all(
	// Input values,
	const bool&	enable);

  
  XrlCmdError rl_interface_firewall_0_1_set_interfaces_interface_firewall_name(
								     //Input values,
								     const string &name,
								     const string &firewall,
								     const string &interface);
  XrlCmdError rl_interface_firewall_0_1_delete_interfaces_interface_firewall_name(
										 //Input values,
										 const string &name,
										 const string &firewall,
										 const string &interface);
								     
  XrlCmdError rl_interface_firewall_0_1_get_interfaces_interface_firewall_rule_list(
						     //Input values,
						     const string &name,
						     //output values,
						     XrlAtomList &rules);
  

  
private:
  /**
   * Called when Finder connection is established.
   *
   * Note that this method overwrites an XrlRouter virtual method.
   */
  virtual void finder_connect_event();
  
  /**
   * Called when Finder disconnect occurs.
   *
   * Note that this method overwrites an XrlRouter virtual method.
   */
  virtual void finder_disconnect_event();
  
  const string& my_xrl_target_name() {
      return XrlRlInterfaceFirewallTargetBase::name();
  }
  
  EventLoop&		_eventloop;
  const string	_class_name;
  const string	_instance_name;
  const string	_finder_target;
  
  XrlFinderEventNotifierV0p1Client	_xrl_finder_client;
  
  static const TimeVal RETRY_TIMEVAL;
  
  bool		_is_finder_alive;
  
  RLInterfaceFirewallNode    _rl_interface_firewall_node;
  
  uint32_t         _status;
};

#endif // __RL_INTERFACE_FIREWALL_XRL_RL_INTERFACE_FIREWALL_NODE_HH__
