/**
 * Module: xrl_rl_firewall_node.hh
 *
 * Author: Michael Larson
 * Date: 2005
 */

#include "rl_interface_firewall_module.h"

#include "libxorp/xorp.h"
#include "libxorp/xlog.h"
#include "libxorp/debug.h"
#include "libxorp/ipvx.hh"
#include "libxorp/status_codes.h"

#include "xrl_rl_interface_firewall_node.hh"

XrlRLInterfaceFirewallNode::XrlRLInterfaceFirewallNode(EventLoop&	eventloop,
				 const string&	class_name,
				 const string&	finder_hostname,
				 uint16_t	finder_port,
				 const string&	finder_target)
    : XrlStdRouter(eventloop, class_name.c_str(), finder_hostname.c_str(),
		   finder_port),
      XrlRlInterfaceFirewallTargetBase(&xrl_router()),
      _eventloop(eventloop),
      _class_name(xrl_router().class_name()),
      _instance_name(xrl_router().instance_name()),
      _finder_target(finder_target),
      _xrl_finder_client(&xrl_router()),
      _is_finder_alive(false),
      _status(PROC_STARTUP)
{
}

XrlRLInterfaceFirewallNode::~XrlRLInterfaceFirewallNode()
{
  rl_interface_firewall_0_1_shutdown_firewall();
}

bool
XrlRLInterfaceFirewallNode::startup()
{
  _status = PROC_READY;
  return true;
}

XrlCmdError
XrlRLInterfaceFirewallNode::rl_interface_firewall_0_1_shutdown_firewall()
{
  //handles shutdown of system and deletion of nodes?
  _status = PROC_SHUTDOWN;
  _rl_interface_firewall_node.reset();
  return XrlCmdError::OKAY();
}

//
// Finder-related events
//
/**
 * Called when Finder connection is established.
 *
 * Note that this method overwrites an XrlRouter virtual method.
 */
void
XrlRLInterfaceFirewallNode::finder_connect_event()
{
    //printf("%s\n",__PRETTY_FUNCTION__);
    _is_finder_alive = true;
}

/**
 * Called when Finder disconnect occurs.
 *
 * Note that this method overwrites an XrlRouter virtual method.
 */
void
XrlRLInterfaceFirewallNode::finder_disconnect_event()
{
    XLOG_ERROR("Finder disconnect event. Exiting immediately...");
    //printf("%s\n",__PRETTY_FUNCTION__);

    _is_finder_alive = false;
}

//
// XRL target methods
//

/**
 *  Get name of Xrl Target
 */
XrlCmdError
XrlRLInterfaceFirewallNode::common_0_1_get_target_name(
    // Output values, 
    string&	name)
{
    //printf("%s\n",__PRETTY_FUNCTION__);
    name = my_xrl_target_name();

    return XrlCmdError::OKAY();
}

/**
 *  Get version string from Xrl Target
 */
XrlCmdError
XrlRLInterfaceFirewallNode::common_0_1_get_version(
    // Output values, 
    string&	version)
{
    //printf("%s\n",__PRETTY_FUNCTION__);
    version = XORP_MODULE_VERSION;

    return XrlCmdError::OKAY();
}

/**
 *  Get status of Xrl Target
 */
XrlCmdError
XrlRLInterfaceFirewallNode::common_0_1_get_status(
    // Output values, 
    uint32_t&	status, 
    string&	reason)
{
  reason = " ";
  status = _status;

  if (PROC_SHUTDOWN == _status) {
    _status = PROC_DONE;
  }

  return XrlCmdError::OKAY();
}

/**
 *  Request clean shutdown of Xrl Target
 */
XrlCmdError
XrlRLInterfaceFirewallNode::common_0_1_shutdown()
{
    return XrlCmdError::OKAY();
}

/**
 *  Announce target birth to observer.
 *
 *  @param target_class the target class name.
 *
 *  @param target_instance the target instance name.
 */
XrlCmdError
XrlRLInterfaceFirewallNode::finder_event_observer_0_1_xrl_target_birth(
    // Input values,
    const string&   target_class,
    const string&   target_instance)
{
    //printf("%s\n",__PRETTY_FUNCTION__);
    return XrlCmdError::OKAY();
    UNUSED(target_class);
    UNUSED(target_instance);
}

/**
 *  Announce target death to observer.
 *
 *  @param target_class the target class name.
 *
 *  @param target_instance the target instance name.
 */
XrlCmdError
XrlRLInterfaceFirewallNode::finder_event_observer_0_1_xrl_target_death(
    // Input values,
    const string&   target_class,
    const string&   target_instance)
{
    //printf("%s\n",__PRETTY_FUNCTION__);
    return XrlCmdError::OKAY();
    UNUSED(target_class);
    UNUSED(target_instance);
}

/**
 *
 *
 */
XrlCmdError
XrlRLInterfaceFirewallNode::rl_interface_firewall_0_1_delete_rl_interface_firewall()
{
  return _rl_interface_firewall_node.reset();
}

/**
 *  Enable/disable/start/stop RLInterfaceFirewall.
 *
 *  @param enable if true, then enable RLInterfaceFirewall, otherwise disable it.
 */
XrlCmdError
XrlRLInterfaceFirewallNode::rl_interface_firewall_0_1_enable_rl_interface_firewall(
    // Input values,
    const bool&	enable)
{
    //printf("%s\n",__PRETTY_FUNCTION__);
    UNUSED(enable);

    // XLOG_UNFINISHED();

    return XrlCmdError::OKAY();
}

XrlCmdError
XrlRLInterfaceFirewallNode::rl_interface_firewall_0_1_start_rl_interface_firewall()
{
    //printf("%s\n",__PRETTY_FUNCTION__);
    // XLOG_UNFINISHED();

    return XrlCmdError::OKAY();
}

XrlCmdError
XrlRLInterfaceFirewallNode::rl_interface_firewall_0_1_stop_rl_interface_firewall()
{
    //printf("%s\n",__PRETTY_FUNCTION__);
    XLOG_UNFINISHED();

    return XrlCmdError::OKAY();
}

/**
 *  Add an interface
 *
 *  @param add an interface
 */
XrlCmdError
XrlRLInterfaceFirewallNode::rl_interface_firewall_0_1_add_interface(
    // Input values,
    const IPv4&	address)
{
    UNUSED(address);

    //printf("%s\n",__PRETTY_FUNCTION__);
    string error_msg;

    //ADD INTERFACE EXEC HERE!
    //printf("XrlRLInterfaceFirewallNode::rl_interface_firewall_0_1_add_interface()--called!\n");

    return XrlCmdError::OKAY();
}

/**
 *  Enable/disable the RLInterfaceFirewall trace log for all operations.
 *
 *  @param enable if true, then enable the trace log, otherwise disable it.
 */
XrlCmdError
XrlRLInterfaceFirewallNode::rl_interface_firewall_0_1_enable_log_trace_all(
    // Input values,
    const bool&	enable)
{
    UNUSED(enable);

    //printf("%s\n",__PRETTY_FUNCTION__);
    return XrlCmdError::OKAY();
}

  
XrlCmdError XrlRLInterfaceFirewallNode::rl_interface_firewall_0_1_set_interfaces_interface_firewall_name(
											   //Input values,
											   const string &name,
											   const string &firewall,
											   const string &interface)
{
  return _rl_interface_firewall_node.set_firewall(name, firewall, interface);
}

XrlCmdError XrlRLInterfaceFirewallNode::rl_interface_firewall_0_1_delete_interfaces_interface_firewall_name(
											      //Input values,
											      const string &name,
											      const string &firewall,
											      const string &interface)
{
  return _rl_interface_firewall_node.delete_firewall(name, firewall, interface);
}
								     
XrlCmdError XrlRLInterfaceFirewallNode::rl_interface_firewall_0_1_get_interfaces_interface_firewall_rule_list(
												    //Input values,
												    const string &name,
												    //output values,
												    XrlAtomList &rules)
{
  return _rl_interface_firewall_node.get_rule_list(name, rules);
}
  

