rl_firewall_common_get_target_name()
{
    if [ $# -ne 0 ] ; then
        echo "Usage: rl_firewall_common_get_target_name"
        exit 1
    fi

    XRL="finder://rl_firewall/common/0.1/get_target_name"
    call_xrl_wrapper -p all "${XRL}"
}

rl_firewall_common_get_version()
{
    if [ $# -ne 0 ] ; then
        echo "Usage: rl_firewall_common_get_version"
        exit 1
    fi

    XRL="finder://rl_firewall/common/0.1/get_version"
    call_xrl_wrapper -p all "${XRL}"
}

rl_firewall_common_get_status()
{
    if [ $# -ne 0 ] ; then
        echo "Usage: rl_firewall_common_get_status"
        exit 1
    fi

    XRL="finder://rl_firewall/common/0.1/get_status"
    call_xrl_wrapper -p all "${XRL}"
}

rl_firewall_common_shutdown()
{
    if [ $# -ne 0 ] ; then
        echo "Usage: rl_firewall_common_shutdown"
        exit 1
    fi

    XRL="finder://rl_firewall/common/0.1/shutdown"
    call_xrl_wrapper -p all "${XRL}"
}

rl_firewall_rl_firewall_enable_rl_firewall()
{
    if [ $# -ne 1 ] ; then
        echo "Usage: rl_firewall_rl_firewall_enable_rl_firewall <enable:bool>"
        exit 1
    fi

    XRL="finder://rl_firewall/rl_firewall/0.1/enable_rl_firewall?enable:bool=$1"
    call_xrl_wrapper -p all "${XRL}"
}

rl_firewall_rl_firewall_start_rl_firewall()
{
    if [ $# -ne 0 ] ; then
        echo "Usage: rl_firewall_rl_firewall_start_rl_firewall"
        exit 1
    fi

    XRL="finder://rl_firewall/rl_firewall/0.1/start_rl_firewall"
    call_xrl_wrapper -p all "${XRL}"
}

rl_firewall_rl_firewall_stop_rl_firewall()
{
    if [ $# -ne 0 ] ; then
        echo "Usage: rl_firewall_rl_firewall_stop_rl_firewall"
        exit 1
    fi

    XRL="finder://rl_firewall/rl_firewall/0.1/stop_rl_firewall"
    call_xrl_wrapper -p all "${XRL}"
}

rl_firewall_rl_firewall_shutdown_firewall()
{
    if [ $# -ne 0 ] ; then
        echo "Usage: rl_firewall_rl_firewall_shutdown_firewall"
        exit 1
    fi

    XRL="finder://rl_firewall/rl_firewall/0.1/shutdown_firewall"
    call_xrl_wrapper -p all "${XRL}"
}

rl_firewall_rl_firewall_add_interface()
{
    if [ $# -ne 1 ] ; then
        echo "Usage: rl_firewall_rl_firewall_add_interface <address:ipv4>"
        exit 1
    fi

    XRL="finder://rl_firewall/rl_firewall/0.1/add_interface?address:ipv4=$1"
    call_xrl_wrapper -p all "${XRL}"
}

rl_firewall_rl_firewall_enable_log_trace_all()
{
    if [ $# -ne 1 ] ; then
        echo "Usage: rl_firewall_rl_firewall_enable_log_trace_all <enable:bool>"
        exit 1
    fi

    XRL="finder://rl_firewall/rl_firewall/0.1/enable_log_trace_all?enable:bool=$1"
    call_xrl_wrapper -p all "${XRL}"
}

rl_firewall_rl_firewall_start_firewall_filter_rule_number_transaction()
{
    if [ $# -ne 2 ] ; then
        echo "Usage: rl_firewall_rl_firewall_start_firewall_filter_rule_number_transaction <filter:txt> <rule_number:u32>"
        exit 1
    fi

    XRL="finder://rl_firewall/rl_firewall/0.1/start_firewall_filter_rule_number_transaction?filter:txt=$1&rule_number:u32=$2"
    call_xrl_wrapper -p all "${XRL}"
}

rl_firewall_rl_firewall_commit_firewall_filter_rule_number_transaction()
{
    if [ $# -ne 2 ] ; then
        echo "Usage: rl_firewall_rl_firewall_commit_firewall_filter_rule_number_transaction <filter:txt> <rule_number:u32>"
        exit 1
    fi

    XRL="finder://rl_firewall/rl_firewall/0.1/commit_firewall_filter_rule_number_transaction?filter:txt=$1&rule_number:u32=$2"
    call_xrl_wrapper -p all "${XRL}"
}

rl_firewall_rl_firewall_delete_firewall_filter()
{
    if [ $# -ne 1 ] ; then
        echo "Usage: rl_firewall_rl_firewall_delete_firewall_filter <filter:txt>"
        exit 1
    fi

    XRL="finder://rl_firewall/rl_firewall/0.1/delete_firewall_filter?filter:txt=$1"
    call_xrl_wrapper -p all "${XRL}"
}

rl_firewall_rl_firewall_delete_firewall_filter_rule_number()
{
    if [ $# -ne 2 ] ; then
        echo "Usage: rl_firewall_rl_firewall_delete_firewall_filter_rule_number <filter:txt> <rule_number:u32>"
        exit 1
    fi

    XRL="finder://rl_firewall/rl_firewall/0.1/delete_firewall_filter_rule_number?filter:txt=$1&rule_number:u32=$2"
    call_xrl_wrapper -p all "${XRL}"
}

rl_firewall_rl_firewall_set_firewall_filter_rule_number_from_dest_port()
{
    if [ $# -ne 3 ] ; then
        echo "Usage: rl_firewall_rl_firewall_set_firewall_filter_rule_number_from_dest_port <filter:txt> <rule_number:u32> <dest_port:u32>"
        exit 1
    fi

    XRL="finder://rl_firewall/rl_firewall/0.1/set_firewall_filter_rule_number_from_dest_port?filter:txt=$1&rule_number:u32=$2&dest_port:u32=$3"
    call_xrl_wrapper -p all "${XRL}"
}

rl_firewall_rl_firewall_delete_firewall_filter_rule_number_from_dest_port()
{
    if [ $# -ne 3 ] ; then
        echo "Usage: rl_firewall_rl_firewall_delete_firewall_filter_rule_number_from_dest_port <filter:txt> <rule_number:u32> <dest_port:u32>"
        exit 1
    fi

    XRL="finder://rl_firewall/rl_firewall/0.1/delete_firewall_filter_rule_number_from_dest_port?filter:txt=$1&rule_number:u32=$2&dest_port:u32=$3"
    call_xrl_wrapper -p all "${XRL}"
}

rl_firewall_rl_firewall_set_firewall_filter_rule_number_from_icmp_code()
{
    if [ $# -ne 3 ] ; then
        echo "Usage: rl_firewall_rl_firewall_set_firewall_filter_rule_number_from_icmp_code <filter:txt> <rule_number:u32> <icmp_code:u32>"
        exit 1
    fi

    XRL="finder://rl_firewall/rl_firewall/0.1/set_firewall_filter_rule_number_from_icmp_code?filter:txt=$1&rule_number:u32=$2&icmp_code:u32=$3"
    call_xrl_wrapper -p all "${XRL}"
}

rl_firewall_rl_firewall_delete_firewall_filter_rule_number_from_icmp_code()
{
    if [ $# -ne 3 ] ; then
        echo "Usage: rl_firewall_rl_firewall_delete_firewall_filter_rule_number_from_icmp_code <filter:txt> <rule_number:u32> <icmp_code:u32>"
        exit 1
    fi

    XRL="finder://rl_firewall/rl_firewall/0.1/delete_firewall_filter_rule_number_from_icmp_code?filter:txt=$1&rule_number:u32=$2&icmp_code:u32=$3"
    call_xrl_wrapper -p all "${XRL}"
}

rl_firewall_rl_firewall_set_firewall_filter_rule_number_from_icmp_type()
{
    if [ $# -ne 3 ] ; then
        echo "Usage: rl_firewall_rl_firewall_set_firewall_filter_rule_number_from_icmp_type <filter:txt> <rule_number:u32> <icmp_type:u32>"
        exit 1
    fi

    XRL="finder://rl_firewall/rl_firewall/0.1/set_firewall_filter_rule_number_from_icmp_type?filter:txt=$1&rule_number:u32=$2&icmp_type:u32=$3"
    call_xrl_wrapper -p all "${XRL}"
}

rl_firewall_rl_firewall_delete_firewall_filter_rule_number_from_icmp_type()
{
    if [ $# -ne 3 ] ; then
        echo "Usage: rl_firewall_rl_firewall_delete_firewall_filter_rule_number_from_icmp_type <filter:txt> <rule_number:u32> <icmp_type:u32>"
        exit 1
    fi

    XRL="finder://rl_firewall/rl_firewall/0.1/delete_firewall_filter_rule_number_from_icmp_type?filter:txt=$1&rule_number:u32=$2&icmp_type:u32=$3"
    call_xrl_wrapper -p all "${XRL}"
}

rl_firewall_rl_firewall_set_firewall_filter_rule_number_from_port()
{
    if [ $# -ne 3 ] ; then
        echo "Usage: rl_firewall_rl_firewall_set_firewall_filter_rule_number_from_port <filter:txt> <rule_number:u32> <port:u32>"
        exit 1
    fi

    XRL="finder://rl_firewall/rl_firewall/0.1/set_firewall_filter_rule_number_from_port?filter:txt=$1&rule_number:u32=$2&port:u32=$3"
    call_xrl_wrapper -p all "${XRL}"
}

rl_firewall_rl_firewall_delete_firewall_filter_rule_number_from_port()
{
    if [ $# -ne 3 ] ; then
        echo "Usage: rl_firewall_rl_firewall_delete_firewall_filter_rule_number_from_port <filter:txt> <rule_number:u32> <port:u32>"
        exit 1
    fi

    XRL="finder://rl_firewall/rl_firewall/0.1/delete_firewall_filter_rule_number_from_port?filter:txt=$1&rule_number:u32=$2&port:u32=$3"
    call_xrl_wrapper -p all "${XRL}"
}

rl_firewall_rl_firewall_set_firewall_filter_rule_number_from_precedence()
{
    if [ $# -ne 3 ] ; then
        echo "Usage: rl_firewall_rl_firewall_set_firewall_filter_rule_number_from_precedence <filter:txt> <rule_number:u32> <precedence:txt>"
        exit 1
    fi

    XRL="finder://rl_firewall/rl_firewall/0.1/set_firewall_filter_rule_number_from_precedence?filter:txt=$1&rule_number:u32=$2&precedence:txt=$3"
    call_xrl_wrapper -p all "${XRL}"
}

rl_firewall_rl_firewall_delete_firewall_filter_rule_number_from_precedence()
{
    if [ $# -ne 3 ] ; then
        echo "Usage: rl_firewall_rl_firewall_delete_firewall_filter_rule_number_from_precedence <filter:txt> <rule_number:u32> <precedence:txt>"
        exit 1
    fi

    XRL="finder://rl_firewall/rl_firewall/0.1/delete_firewall_filter_rule_number_from_precedence?filter:txt=$1&rule_number:u32=$2&precedence:txt=$3"
    call_xrl_wrapper -p all "${XRL}"
}

rl_firewall_rl_firewall_set_firewall_filter_rule_number_from_protocol()
{
    if [ $# -ne 3 ] ; then
        echo "Usage: rl_firewall_rl_firewall_set_firewall_filter_rule_number_from_protocol <filter:txt> <rule_number:u32> <protocol:u32>"
        exit 1
    fi

    XRL="finder://rl_firewall/rl_firewall/0.1/set_firewall_filter_rule_number_from_protocol?filter:txt=$1&rule_number:u32=$2&protocol:u32=$3"
    call_xrl_wrapper -p all "${XRL}"
}

rl_firewall_rl_firewall_delete_firewall_filter_rule_number_from_protocol()
{
    if [ $# -ne 3 ] ; then
        echo "Usage: rl_firewall_rl_firewall_delete_firewall_filter_rule_number_from_protocol <filter:txt> <rule_number:u32> <protocol:u32>"
        exit 1
    fi

    XRL="finder://rl_firewall/rl_firewall/0.1/delete_firewall_filter_rule_number_from_protocol?filter:txt=$1&rule_number:u32=$2&protocol:u32=$3"
    call_xrl_wrapper -p all "${XRL}"
}

rl_firewall_rl_firewall_set_firewall_filter_rule_number_from_src_port()
{
    if [ $# -ne 3 ] ; then
        echo "Usage: rl_firewall_rl_firewall_set_firewall_filter_rule_number_from_src_port <filter:txt> <rule_number:u32> <src_port:u32>"
        exit 1
    fi

    XRL="finder://rl_firewall/rl_firewall/0.1/set_firewall_filter_rule_number_from_src_port?filter:txt=$1&rule_number:u32=$2&src_port:u32=$3"
    call_xrl_wrapper -p all "${XRL}"
}

rl_firewall_rl_firewall_delete_firewall_filter_rule_number_from_src_port()
{
    if [ $# -ne 3 ] ; then
        echo "Usage: rl_firewall_rl_firewall_delete_firewall_filter_rule_number_from_src_port <filter:txt> <rule_number:u32> <src_port:u32>"
        exit 1
    fi

    XRL="finder://rl_firewall/rl_firewall/0.1/delete_firewall_filter_rule_number_from_src_port?filter:txt=$1&rule_number:u32=$2&src_port:u32=$3"
    call_xrl_wrapper -p all "${XRL}"
}

rl_firewall_rl_firewall_set_firewall_filter_rule_number_from_address()
{
    if [ $# -ne 3 ] ; then
        echo "Usage: rl_firewall_rl_firewall_set_firewall_filter_rule_number_from_address <filter:txt> <rule_number:u32> <address:ipv4>"
        exit 1
    fi

    XRL="finder://rl_firewall/rl_firewall/0.1/set_firewall_filter_rule_number_from_address?filter:txt=$1&rule_number:u32=$2&address:ipv4=$3"
    call_xrl_wrapper -p all "${XRL}"
}

rl_firewall_rl_firewall_delete_firewall_filter_rule_number_from_address()
{
    if [ $# -ne 3 ] ; then
        echo "Usage: rl_firewall_rl_firewall_delete_firewall_filter_rule_number_from_address <filter:txt> <rule_number:u32> <address:ipv4>"
        exit 1
    fi

    XRL="finder://rl_firewall/rl_firewall/0.1/delete_firewall_filter_rule_number_from_address?filter:txt=$1&rule_number:u32=$2&address:ipv4=$3"
    call_xrl_wrapper -p all "${XRL}"
}

rl_firewall_rl_firewall_set_firewall_filter_rule_number_from_dest_address()
{
    if [ $# -ne 3 ] ; then
        echo "Usage: rl_firewall_rl_firewall_set_firewall_filter_rule_number_from_dest_address <filter:txt> <rule_number:u32> <dest_address:ipv4>"
        exit 1
    fi

    XRL="finder://rl_firewall/rl_firewall/0.1/set_firewall_filter_rule_number_from_dest_address?filter:txt=$1&rule_number:u32=$2&dest_address:ipv4=$3"
    call_xrl_wrapper -p all "${XRL}"
}

rl_firewall_rl_firewall_delete_firewall_filter_rule_number_from_dest_address()
{
    if [ $# -ne 3 ] ; then
        echo "Usage: rl_firewall_rl_firewall_delete_firewall_filter_rule_number_from_dest_address <filter:txt> <rule_number:u32> <dest_address:ipv4>"
        exit 1
    fi

    XRL="finder://rl_firewall/rl_firewall/0.1/delete_firewall_filter_rule_number_from_dest_address?filter:txt=$1&rule_number:u32=$2&dest_address:ipv4=$3"
    call_xrl_wrapper -p all "${XRL}"
}

rl_firewall_rl_firewall_set_firewall_filter_rule_number_from_dest_prefix_list()
{
    if [ $# -ne 3 ] ; then
        echo "Usage: rl_firewall_rl_firewall_set_firewall_filter_rule_number_from_dest_prefix_list <filter:txt> <rule_number:u32> <dest_prefix_list:txt>"
        exit 1
    fi

    XRL="finder://rl_firewall/rl_firewall/0.1/set_firewall_filter_rule_number_from_dest_prefix_list?filter:txt=$1&rule_number:u32=$2&dest_prefix_list:txt=$3"
    call_xrl_wrapper -p all "${XRL}"
}

rl_firewall_rl_firewall_delete_firewall_filter_rule_number_from_dest_prefix_list()
{
    if [ $# -ne 3 ] ; then
        echo "Usage: rl_firewall_rl_firewall_delete_firewall_filter_rule_number_from_dest_prefix_list <filter:txt> <rule_number:u32> <dest_prefix_list:txt>"
        exit 1
    fi

    XRL="finder://rl_firewall/rl_firewall/0.1/delete_firewall_filter_rule_number_from_dest_prefix_list?filter:txt=$1&rule_number:u32=$2&dest_prefix_list:txt=$3"
    call_xrl_wrapper -p all "${XRL}"
}

rl_firewall_rl_firewall_set_firewall_filter_rule_number_from_prefix_list()
{
    if [ $# -ne 3 ] ; then
        echo "Usage: rl_firewall_rl_firewall_set_firewall_filter_rule_number_from_prefix_list <filter:txt> <rule_number:u32> <prefix_list:txt>"
        exit 1
    fi

    XRL="finder://rl_firewall/rl_firewall/0.1/set_firewall_filter_rule_number_from_prefix_list?filter:txt=$1&rule_number:u32=$2&prefix_list:txt=$3"
    call_xrl_wrapper -p all "${XRL}"
}

rl_firewall_rl_firewall_delete_firewall_filter_rule_number_from_prefix_list()
{
    if [ $# -ne 3 ] ; then
        echo "Usage: rl_firewall_rl_firewall_delete_firewall_filter_rule_number_from_prefix_list <filter:txt> <rule_number:u32> <prefix_list:txt>"
        exit 1
    fi

    XRL="finder://rl_firewall/rl_firewall/0.1/delete_firewall_filter_rule_number_from_prefix_list?filter:txt=$1&rule_number:u32=$2&prefix_list:txt=$3"
    call_xrl_wrapper -p all "${XRL}"
}

rl_firewall_rl_firewall_set_firewall_filter_rule_number_from_src_addr()
{
    if [ $# -ne 3 ] ; then
        echo "Usage: rl_firewall_rl_firewall_set_firewall_filter_rule_number_from_src_addr <filter:txt> <rule_number:u32> <src_addr:ipv4>"
        exit 1
    fi

    XRL="finder://rl_firewall/rl_firewall/0.1/set_firewall_filter_rule_number_from_src_addr?filter:txt=$1&rule_number:u32=$2&src_addr:ipv4=$3"
    call_xrl_wrapper -p all "${XRL}"
}

rl_firewall_rl_firewall_delete_firewall_filter_rule_number_from_src_addr()
{
    if [ $# -ne 3 ] ; then
        echo "Usage: rl_firewall_rl_firewall_delete_firewall_filter_rule_number_from_src_addr <filter:txt> <rule_number:u32> <src_addr:ipv4>"
        exit 1
    fi

    XRL="finder://rl_firewall/rl_firewall/0.1/delete_firewall_filter_rule_number_from_src_addr?filter:txt=$1&rule_number:u32=$2&src_addr:ipv4=$3"
    call_xrl_wrapper -p all "${XRL}"
}

rl_firewall_rl_firewall_set_firewall_filter_rule_number_from_src_prefix_list()
{
    if [ $# -ne 3 ] ; then
        echo "Usage: rl_firewall_rl_firewall_set_firewall_filter_rule_number_from_src_prefix_list <filter:txt> <rule_number:u32> <src_prefix_list:txt>"
        exit 1
    fi

    XRL="finder://rl_firewall/rl_firewall/0.1/set_firewall_filter_rule_number_from_src_prefix_list?filter:txt=$1&rule_number:u32=$2&src_prefix_list:txt=$3"
    call_xrl_wrapper -p all "${XRL}"
}

rl_firewall_rl_firewall_delete_firewall_filter_rule_number_from_src_prefix_list()
{
    if [ $# -ne 3 ] ; then
        echo "Usage: rl_firewall_rl_firewall_delete_firewall_filter_rule_number_from_src_prefix_list <filter:txt> <rule_number:u32> <src_prefix_list:txt>"
        exit 1
    fi

    XRL="finder://rl_firewall/rl_firewall/0.1/delete_firewall_filter_rule_number_from_src_prefix_list?filter:txt=$1&rule_number:u32=$2&src_prefix_list:txt=$3"
    call_xrl_wrapper -p all "${XRL}"
}

rl_firewall_rl_firewall_set_firewall_filter_rule_number_then_action()
{
    if [ $# -ne 3 ] ; then
        echo "Usage: rl_firewall_rl_firewall_set_firewall_filter_rule_number_then_action <filter:txt> <rule_number:u32> <action:txt>"
        exit 1
    fi

    XRL="finder://rl_firewall/rl_firewall/0.1/set_firewall_filter_rule_number_then_action?filter:txt=$1&rule_number:u32=$2&action:txt=$3"
    call_xrl_wrapper -p all "${XRL}"
}

rl_firewall_rl_firewall_delete_firewall_filter_rule_number_then_action()
{
    if [ $# -ne 3 ] ; then
        echo "Usage: rl_firewall_rl_firewall_delete_firewall_filter_rule_number_then_action <filter:txt> <rule_number:u32> <action:txt>"
        exit 1
    fi

    XRL="finder://rl_firewall/rl_firewall/0.1/delete_firewall_filter_rule_number_then_action?filter:txt=$1&rule_number:u32=$2&action:txt=$3"
    call_xrl_wrapper -p all "${XRL}"
}

rl_firewall_rl_firewall_set_firewall_filter_rule_number_then_action_mod()
{
    if [ $# -ne 3 ] ; then
        echo "Usage: rl_firewall_rl_firewall_set_firewall_filter_rule_number_then_action_mod <filter:txt> <rule_number:u32> <action_mod:txt>"
        exit 1
    fi

    XRL="finder://rl_firewall/rl_firewall/0.1/set_firewall_filter_rule_number_then_action_mod?filter:txt=$1&rule_number:u32=$2&action_mod:txt=$3"
    call_xrl_wrapper -p all "${XRL}"
}

rl_firewall_rl_firewall_delete_firewall_filter_rule_number_then_action_mod()
{
    if [ $# -ne 3 ] ; then
        echo "Usage: rl_firewall_rl_firewall_delete_firewall_filter_rule_number_then_action_mod <filter:txt> <rule_number:u32> <action_mod:txt>"
        exit 1
    fi

    XRL="finder://rl_firewall/rl_firewall/0.1/delete_firewall_filter_rule_number_then_action_mod?filter:txt=$1&rule_number:u32=$2&action_mod:txt=$3"
    call_xrl_wrapper -p all "${XRL}"
}

rl_firewall_rl_firewall_set_interfaces_interface_name_vif_filter_input()
{
    if [ $# -ne 2 ] ; then
        echo "Usage: rl_firewall_rl_firewall_set_interfaces_interface_name_vif_filter_input <input:txt> <vif:txt>"
        exit 1
    fi

    XRL="finder://rl_firewall/rl_firewall/0.1/set_interfaces_interface_name_vif_filter_input?input:txt=$1&vif:txt=$2"
    call_xrl_wrapper -p all "${XRL}"
}

rl_firewall_rl_firewall_delete_interfaces_interface_name_vif_filter_input()
{
    if [ $# -ne 2 ] ; then
        echo "Usage: rl_firewall_rl_firewall_delete_interfaces_interface_name_vif_filter_input <input:txt> <vif:txt>"
        exit 1
    fi

    XRL="finder://rl_firewall/rl_firewall/0.1/delete_interfaces_interface_name_vif_filter_input?input:txt=$1&vif:txt=$2"
    call_xrl_wrapper -p all "${XRL}"
}

rl_firewall_rl_firewall_set_interfaces_interface_name_vif_filter_output()
{
    if [ $# -ne 2 ] ; then
        echo "Usage: rl_firewall_rl_firewall_set_interfaces_interface_name_vif_filter_output <output:txt> <vif:txt>"
        exit 1
    fi

    XRL="finder://rl_firewall/rl_firewall/0.1/set_interfaces_interface_name_vif_filter_output?output:txt=$1&vif:txt=$2"
    call_xrl_wrapper -p all "${XRL}"
}

rl_firewall_rl_firewall_delete_interfaces_interface_name_vif_filter_output()
{
    if [ $# -ne 2 ] ; then
        echo "Usage: rl_firewall_rl_firewall_delete_interfaces_interface_name_vif_filter_output <output:txt> <vif:txt>"
        exit 1
    fi

    XRL="finder://rl_firewall/rl_firewall/0.1/delete_interfaces_interface_name_vif_filter_output?output:txt=$1&vif:txt=$2"
    call_xrl_wrapper -p all "${XRL}"
}

