/*
 * Module: rl_interface_firewall_node.hh
 *
 * **** License ****
 * Version: VPL 1.0
 *
 * The contents of this file are subject to the Vyatta Public License
 * Version 1.0 ("License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.vyatta.com/vpl
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
 * the License for the specific language governing rights and limitations
 * under the License.
 *
 * This code was originally developed by Vyatta, Inc.
 * Portions created by Vyatta are Copyright (C) 2005, 2006, 2007 Vyatta, Inc.
 * All Rights Reserved.
 *
 * Author: Michael Larson
 * Date: 2005
 * Description:
 *
 * **** End License ****
 *
 */
#ifndef __RL_INTERFACE_FIREWALL_RL_INTERFACE_FIREWALL_NODE_HH__
#define __RL_INTERFACE_FIREWALL_RL_INTERFACE_FIREWALL_NODE_HH__

#include <string>
#include <vector>
#include <list>
#include <cctype> 
#include <algorithm> 
#include <librl_common/rl_nat.hh>
#include <libxipc/xrl_atom_list.hh>
#include <libxipc/xrl_error.hh>
#include <libxorp/ipv4.hh>
#include <libxorp/ipv4net.hh>

/****************************************************************************
 *
 ***************************************************************************/
class InterfaceFW
{
public:
  InterfaceFW(bool in_interface, const string &name, const string &rule_spec) : _in_interface(in_interface), _name(name), _rule_spec(rule_spec) {;}
  InterfaceFW() {;}

  string
  dump() const;

  bool _in_interface; //false is out
  string _name;
  string _rule_spec;
};


/****************************************************************************
 *
 ***************************************************************************/
class IFWKey
{
public:
  IFWKey(const string &interface, const string &firewall);

  bool operator==(const IFWKey &key) const;
  bool operator<(const IFWKey &key) const;

public:
  string _interface;
  string _firewall;
};

/****************************************************************************
 *
 ***************************************************************************/
class RLInterfaceFirewallNode
{
public:
  typedef map<IFWKey, InterfaceFW> FirewallNameColl;
  typedef map<IFWKey, InterfaceFW>::iterator FirewallNameIter;

public:
  RLInterfaceFirewallNode();
  ~RLInterfaceFirewallNode();

  XrlCmdError reset();

  /**
   * Methods below are not subject to transaction behavior
   **/
  XrlCmdError set_firewall(const string &name, const string &firewall, const string &interface);
  
  XrlCmdError delete_firewall(const string &name, const string &firewall, const string &interface);

  XrlCmdError get_rule_list(const string &name, XrlAtomList &rules);

private: //variables
  FirewallNameColl _input_firewall; /* used only under interface. */
  FirewallNameColl _forward_firewall; /* used only under interface. */

};

#endif //__RL_INTERFACE_FIREWALL_RL_INTERFACE_FIREWALL_NODE_HH__
