rl_firewall_common_get_target_name()
{
    if [ $# -ne 0 ] ; then
        echo "Usage: rl_firewall_common_get_target_name"
        exit 1
    fi

    XRL="finder://rl_firewall/common/0.1/get_target_name"
    call_xrl_wrapper -p all "${XRL}"
}

rl_firewall_common_get_version()
{
    if [ $# -ne 0 ] ; then
        echo "Usage: rl_firewall_common_get_version"
        exit 1
    fi

    XRL="finder://rl_firewall/common/0.1/get_version"
    call_xrl_wrapper -p all "${XRL}"
}

rl_firewall_common_get_status()
{
    if [ $# -ne 0 ] ; then
        echo "Usage: rl_firewall_common_get_status"
        exit 1
    fi

    XRL="finder://rl_firewall/common/0.1/get_status"
    call_xrl_wrapper -p all "${XRL}"
}

rl_firewall_common_shutdown()
{
    if [ $# -ne 0 ] ; then
        echo "Usage: rl_firewall_common_shutdown"
        exit 1
    fi

    XRL="finder://rl_firewall/common/0.1/shutdown"
    call_xrl_wrapper -p all "${XRL}"
}

rl_firewall_rl_firewall_enable_rl_firewall()
{
    if [ $# -ne 1 ] ; then
        echo "Usage: rl_firewall_rl_firewall_enable_rl_firewall <enable:bool>"
        exit 1
    fi

    XRL="finder://rl_firewall/rl_firewall/0.1/enable_rl_firewall?enable:bool=$1"
    call_xrl_wrapper -p all "${XRL}"
}

rl_firewall_rl_firewall_start_rl_firewall()
{
    if [ $# -ne 0 ] ; then
        echo "Usage: rl_firewall_rl_firewall_start_rl_firewall"
        exit 1
    fi

    XRL="finder://rl_firewall/rl_firewall/0.1/start_rl_firewall"
    call_xrl_wrapper -p all "${XRL}"
}

rl_firewall_rl_firewall_stop_rl_firewall()
{
    if [ $# -ne 0 ] ; then
        echo "Usage: rl_firewall_rl_firewall_stop_rl_firewall"
        exit 1
    fi

    XRL="finder://rl_firewall/rl_firewall/0.1/stop_rl_firewall"
    call_xrl_wrapper -p all "${XRL}"
}

rl_firewall_rl_firewall_shutdown_firewall()
{
    if [ $# -ne 0 ] ; then
        echo "Usage: rl_firewall_rl_firewall_shutdown_firewall"
        exit 1
    fi

    XRL="finder://rl_firewall/rl_firewall/0.1/shutdown_firewall"
    call_xrl_wrapper -p all "${XRL}"
}

rl_firewall_rl_firewall_add_interface()
{
    if [ $# -ne 1 ] ; then
        echo "Usage: rl_firewall_rl_firewall_add_interface <address:ipv4>"
        exit 1
    fi

    XRL="finder://rl_firewall/rl_firewall/0.1/add_interface?address:ipv4=$1"
    call_xrl_wrapper -p all "${XRL}"
}

rl_firewall_rl_firewall_enable_log_trace_all()
{
    if [ $# -ne 1 ] ; then
        echo "Usage: rl_firewall_rl_firewall_enable_log_trace_all <enable:bool>"
        exit 1
    fi

    XRL="finder://rl_firewall/rl_firewall/0.1/enable_log_trace_all?enable:bool=$1"
    call_xrl_wrapper -p all "${XRL}"
}

rl_firewall_rl_firewall_delete_rl_firewall()
{
    if [ $# -ne 0 ] ; then
        echo "Usage: rl_firewall_rl_firewall_delete_rl_firewall"
        exit 1
    fi

    XRL="finder://rl_firewall/rl_firewall/0.1/delete_rl_firewall"
    call_xrl_wrapper -p all "${XRL}"
}

rl_firewall_rl_firewall_start_rl_firewall_name_rule_transaction()
{
    if [ $# -ne 2 ] ; then
        echo "Usage: rl_firewall_rl_firewall_start_rl_firewall_name_rule_transaction <name:txt> <rule:u32>"
        exit 1
    fi

    XRL="finder://rl_firewall/rl_firewall/0.1/start_rl_firewall_name_rule_transaction?name:txt=$1&rule:u32=$2"
    call_xrl_wrapper -p all "${XRL}"
}

rl_firewall_rl_firewall_commit_rl_firewall_name_rule_transaction()
{
    if [ $# -ne 2 ] ; then
        echo "Usage: rl_firewall_rl_firewall_commit_rl_firewall_name_rule_transaction <name:txt> <rule:u32>"
        exit 1
    fi

    XRL="finder://rl_firewall/rl_firewall/0.1/commit_rl_firewall_name_rule_transaction?name:txt=$1&rule:u32=$2"
    call_xrl_wrapper -p all "${XRL}"
}

rl_firewall_rl_firewall_delete_rl_firewall_filter()
{
    if [ $# -ne 1 ] ; then
        echo "Usage: rl_firewall_rl_firewall_delete_rl_firewall_filter <name:txt>"
        exit 1
    fi

    XRL="finder://rl_firewall/rl_firewall/0.1/delete_rl_firewall_filter?name:txt=$1"
    call_xrl_wrapper -p all "${XRL}"
}

rl_firewall_rl_firewall_delete_rl_firewall_name_rule()
{
    if [ $# -ne 2 ] ; then
        echo "Usage: rl_firewall_rl_firewall_delete_rl_firewall_name_rule <name:txt> <rule:u32>"
        exit 1
    fi

    XRL="finder://rl_firewall/rl_firewall/0.1/delete_rl_firewall_name_rule?name:txt=$1&rule:u32=$2"
    call_xrl_wrapper -p all "${XRL}"
}

rl_firewall_rl_firewall_set_rl_firewall_log_martians()
{
    if [ $# -ne 1 ] ; then
        echo "Usage: rl_firewall_rl_firewall_set_rl_firewall_log_martians <enable:txt>"
        exit 1
    fi

    XRL="finder://rl_firewall/rl_firewall/0.1/set_rl_firewall_log_martians?enable:txt=$1"
    call_xrl_wrapper -p all "${XRL}"
}

rl_firewall_rl_firewall_set_rl_firewall_send_redirects()
{
    if [ $# -ne 1 ] ; then
        echo "Usage: rl_firewall_rl_firewall_set_rl_firewall_send_redirects <enable:txt>"
        exit 1
    fi

    XRL="finder://rl_firewall/rl_firewall/0.1/set_rl_firewall_send_redirects?enable:txt=$1"
    call_xrl_wrapper -p all "${XRL}"
}

rl_firewall_rl_firewall_set_rl_firewall_receive_redirects()
{
    if [ $# -ne 1 ] ; then
        echo "Usage: rl_firewall_rl_firewall_set_rl_firewall_receive_redirects <enable:txt>"
        exit 1
    fi

    XRL="finder://rl_firewall/rl_firewall/0.1/set_rl_firewall_receive_redirects?enable:txt=$1"
    call_xrl_wrapper -p all "${XRL}"
}

rl_firewall_rl_firewall_set_rl_firewall_ip_src_route()
{
    if [ $# -ne 1 ] ; then
        echo "Usage: rl_firewall_rl_firewall_set_rl_firewall_ip_src_route <enable:txt>"
        exit 1
    fi

    XRL="finder://rl_firewall/rl_firewall/0.1/set_rl_firewall_ip_src_route?enable:txt=$1"
    call_xrl_wrapper -p all "${XRL}"
}

rl_firewall_rl_firewall_set_rl_firewall_broadcast_ping()
{
    if [ $# -ne 1 ] ; then
        echo "Usage: rl_firewall_rl_firewall_set_rl_firewall_broadcast_ping <enable:txt>"
        exit 1
    fi

    XRL="finder://rl_firewall/rl_firewall/0.1/set_rl_firewall_broadcast_ping?enable:txt=$1"
    call_xrl_wrapper -p all "${XRL}"
}

rl_firewall_rl_firewall_set_rl_firewall_syn_cookies()
{
    if [ $# -ne 1 ] ; then
        echo "Usage: rl_firewall_rl_firewall_set_rl_firewall_syn_cookies <enable:txt>"
        exit 1
    fi

    XRL="finder://rl_firewall/rl_firewall/0.1/set_rl_firewall_syn_cookies?enable:txt=$1"
    call_xrl_wrapper -p all "${XRL}"
}

rl_firewall_rl_firewall_set_rl_firewall_name_rule_protocol()
{
    if [ $# -ne 3 ] ; then
        echo "Usage: rl_firewall_rl_firewall_set_rl_firewall_name_rule_protocol <protocol:txt> <name:txt> <rule:u32>"
        exit 1
    fi

    XRL="finder://rl_firewall/rl_firewall/0.1/set_rl_firewall_name_rule_protocol?protocol:txt=$1&name:txt=$2&rule:u32=$3"
    call_xrl_wrapper -p all "${XRL}"
}

rl_firewall_rl_firewall_delete_rl_firewall_name_rule_protocol()
{
    if [ $# -ne 3 ] ; then
        echo "Usage: rl_firewall_rl_firewall_delete_rl_firewall_name_rule_protocol <protocol:txt> <name:txt> <rule:u32>"
        exit 1
    fi

    XRL="finder://rl_firewall/rl_firewall/0.1/delete_rl_firewall_name_rule_protocol?protocol:txt=$1&name:txt=$2&rule:u32=$3"
    call_xrl_wrapper -p all "${XRL}"
}

rl_firewall_rl_firewall_set_rl_firewall_name_rule_icmp_type()
{
    if [ $# -ne 3 ] ; then
        echo "Usage: rl_firewall_rl_firewall_set_rl_firewall_name_rule_icmp_type <type:txt> <name:txt> <rule:u32>"
        exit 1
    fi

    XRL="finder://rl_firewall/rl_firewall/0.1/set_rl_firewall_name_rule_icmp_type?type:txt=$1&name:txt=$2&rule:u32=$3"
    call_xrl_wrapper -p all "${XRL}"
}

rl_firewall_rl_firewall_delete_rl_firewall_name_rule_icmp_type()
{
    if [ $# -ne 3 ] ; then
        echo "Usage: rl_firewall_rl_firewall_delete_rl_firewall_name_rule_icmp_type <type:txt> <name:txt> <rule:u32>"
        exit 1
    fi

    XRL="finder://rl_firewall/rl_firewall/0.1/delete_rl_firewall_name_rule_icmp_type?type:txt=$1&name:txt=$2&rule:u32=$3"
    call_xrl_wrapper -p all "${XRL}"
}

rl_firewall_rl_firewall_set_rl_firewall_name_rule_icmp_code()
{
    if [ $# -ne 3 ] ; then
        echo "Usage: rl_firewall_rl_firewall_set_rl_firewall_name_rule_icmp_code <code:txt> <name:txt> <rule:u32>"
        exit 1
    fi

    XRL="finder://rl_firewall/rl_firewall/0.1/set_rl_firewall_name_rule_icmp_code?code:txt=$1&name:txt=$2&rule:u32=$3"
    call_xrl_wrapper -p all "${XRL}"
}

rl_firewall_rl_firewall_delete_rl_firewall_name_rule_icmp_code()
{
    if [ $# -ne 3 ] ; then
        echo "Usage: rl_firewall_rl_firewall_delete_rl_firewall_name_rule_icmp_code <code:txt> <name:txt> <rule:u32>"
        exit 1
    fi

    XRL="finder://rl_firewall/rl_firewall/0.1/delete_rl_firewall_name_rule_icmp_code?code:txt=$1&name:txt=$2&rule:u32=$3"
    call_xrl_wrapper -p all "${XRL}"
}

rl_firewall_rl_firewall_set_rl_firewall_name_rule_state_established()
{
    if [ $# -ne 3 ] ; then
        echo "Usage: rl_firewall_rl_firewall_set_rl_firewall_name_rule_state_established <enable:txt> <name:txt> <rule:u32>"
        exit 1
    fi

    XRL="finder://rl_firewall/rl_firewall/0.1/set_rl_firewall_name_rule_state_established?enable:txt=$1&name:txt=$2&rule:u32=$3"
    call_xrl_wrapper -p all "${XRL}"
}

rl_firewall_rl_firewall_delete_rl_firewall_name_rule_state_established()
{
    if [ $# -ne 3 ] ; then
        echo "Usage: rl_firewall_rl_firewall_delete_rl_firewall_name_rule_state_established <enable:txt> <name:txt> <rule:u32>"
        exit 1
    fi

    XRL="finder://rl_firewall/rl_firewall/0.1/delete_rl_firewall_name_rule_state_established?enable:txt=$1&name:txt=$2&rule:u32=$3"
    call_xrl_wrapper -p all "${XRL}"
}

rl_firewall_rl_firewall_set_rl_firewall_name_rule_state_new()
{
    if [ $# -ne 3 ] ; then
        echo "Usage: rl_firewall_rl_firewall_set_rl_firewall_name_rule_state_new <enable:txt> <name:txt> <rule:u32>"
        exit 1
    fi

    XRL="finder://rl_firewall/rl_firewall/0.1/set_rl_firewall_name_rule_state_new?enable:txt=$1&name:txt=$2&rule:u32=$3"
    call_xrl_wrapper -p all "${XRL}"
}

rl_firewall_rl_firewall_delete_rl_firewall_name_rule_state_new()
{
    if [ $# -ne 3 ] ; then
        echo "Usage: rl_firewall_rl_firewall_delete_rl_firewall_name_rule_state_new <enable:txt> <name:txt> <rule:u32>"
        exit 1
    fi

    XRL="finder://rl_firewall/rl_firewall/0.1/delete_rl_firewall_name_rule_state_new?enable:txt=$1&name:txt=$2&rule:u32=$3"
    call_xrl_wrapper -p all "${XRL}"
}

rl_firewall_rl_firewall_set_rl_firewall_name_rule_state_related()
{
    if [ $# -ne 3 ] ; then
        echo "Usage: rl_firewall_rl_firewall_set_rl_firewall_name_rule_state_related <enable:txt> <name:txt> <rule:u32>"
        exit 1
    fi

    XRL="finder://rl_firewall/rl_firewall/0.1/set_rl_firewall_name_rule_state_related?enable:txt=$1&name:txt=$2&rule:u32=$3"
    call_xrl_wrapper -p all "${XRL}"
}

rl_firewall_rl_firewall_delete_rl_firewall_name_rule_state_related()
{
    if [ $# -ne 3 ] ; then
        echo "Usage: rl_firewall_rl_firewall_delete_rl_firewall_name_rule_state_related <enable:txt> <name:txt> <rule:u32>"
        exit 1
    fi

    XRL="finder://rl_firewall/rl_firewall/0.1/delete_rl_firewall_name_rule_state_related?enable:txt=$1&name:txt=$2&rule:u32=$3"
    call_xrl_wrapper -p all "${XRL}"
}

rl_firewall_rl_firewall_set_rl_firewall_name_rule_state_invalid()
{
    if [ $# -ne 3 ] ; then
        echo "Usage: rl_firewall_rl_firewall_set_rl_firewall_name_rule_state_invalid <enable:txt> <name:txt> <rule:u32>"
        exit 1
    fi

    XRL="finder://rl_firewall/rl_firewall/0.1/set_rl_firewall_name_rule_state_invalid?enable:txt=$1&name:txt=$2&rule:u32=$3"
    call_xrl_wrapper -p all "${XRL}"
}

rl_firewall_rl_firewall_delete_rl_firewall_name_rule_state_invalid()
{
    if [ $# -ne 3 ] ; then
        echo "Usage: rl_firewall_rl_firewall_delete_rl_firewall_name_rule_state_invalid <enable:txt> <name:txt> <rule:u32>"
        exit 1
    fi

    XRL="finder://rl_firewall/rl_firewall/0.1/delete_rl_firewall_name_rule_state_invalid?enable:txt=$1&name:txt=$2&rule:u32=$3"
    call_xrl_wrapper -p all "${XRL}"
}

rl_firewall_rl_firewall_set_rl_firewall_name_rule_action()
{
    if [ $# -ne 3 ] ; then
        echo "Usage: rl_firewall_rl_firewall_set_rl_firewall_name_rule_action <action:txt> <name:txt> <rule:u32>"
        exit 1
    fi

    XRL="finder://rl_firewall/rl_firewall/0.1/set_rl_firewall_name_rule_action?action:txt=$1&name:txt=$2&rule:u32=$3"
    call_xrl_wrapper -p all "${XRL}"
}

rl_firewall_rl_firewall_delete_rl_firewall_name_rule_action()
{
    if [ $# -ne 3 ] ; then
        echo "Usage: rl_firewall_rl_firewall_delete_rl_firewall_name_rule_action <action:txt> <name:txt> <rule:u32>"
        exit 1
    fi

    XRL="finder://rl_firewall/rl_firewall/0.1/delete_rl_firewall_name_rule_action?action:txt=$1&name:txt=$2&rule:u32=$3"
    call_xrl_wrapper -p all "${XRL}"
}

rl_firewall_rl_firewall_set_rl_firewall_name_rule_log()
{
    if [ $# -ne 3 ] ; then
        echo "Usage: rl_firewall_rl_firewall_set_rl_firewall_name_rule_log <log:txt> <name:txt> <rule:u32>"
        exit 1
    fi

    XRL="finder://rl_firewall/rl_firewall/0.1/set_rl_firewall_name_rule_log?log:txt=$1&name:txt=$2&rule:u32=$3"
    call_xrl_wrapper -p all "${XRL}"
}

rl_firewall_rl_firewall_set_rl_firewall_name_rule_source_address()
{
    if [ $# -ne 3 ] ; then
        echo "Usage: rl_firewall_rl_firewall_set_rl_firewall_name_rule_source_address <address:ipv4> <name:txt> <rule:u32>"
        exit 1
    fi

    XRL="finder://rl_firewall/rl_firewall/0.1/set_rl_firewall_name_rule_source_address?address:ipv4=$1&name:txt=$2&rule:u32=$3"
    call_xrl_wrapper -p all "${XRL}"
}

rl_firewall_rl_firewall_delete_rl_firewall_name_rule_source_address()
{
    if [ $# -ne 3 ] ; then
        echo "Usage: rl_firewall_rl_firewall_delete_rl_firewall_name_rule_source_address <address:ipv4> <name:txt> <rule:u32>"
        exit 1
    fi

    XRL="finder://rl_firewall/rl_firewall/0.1/delete_rl_firewall_name_rule_source_address?address:ipv4=$1&name:txt=$2&rule:u32=$3"
    call_xrl_wrapper -p all "${XRL}"
}

rl_firewall_rl_firewall_set_rl_firewall_name_rule_source_network()
{
    if [ $# -ne 3 ] ; then
        echo "Usage: rl_firewall_rl_firewall_set_rl_firewall_name_rule_source_network <network:ipv4net> <name:txt> <rule:u32>"
        exit 1
    fi

    XRL="finder://rl_firewall/rl_firewall/0.1/set_rl_firewall_name_rule_source_network?network:ipv4net=$1&name:txt=$2&rule:u32=$3"
    call_xrl_wrapper -p all "${XRL}"
}

rl_firewall_rl_firewall_delete_rl_firewall_name_rule_source_network()
{
    if [ $# -ne 3 ] ; then
        echo "Usage: rl_firewall_rl_firewall_delete_rl_firewall_name_rule_source_network <network:ipv4net> <name:txt> <rule:u32>"
        exit 1
    fi

    XRL="finder://rl_firewall/rl_firewall/0.1/delete_rl_firewall_name_rule_source_network?network:ipv4net=$1&name:txt=$2&rule:u32=$3"
    call_xrl_wrapper -p all "${XRL}"
}

rl_firewall_rl_firewall_set_rl_firewall_name_rule_source_range_start_stop()
{
    if [ $# -ne 4 ] ; then
        echo "Usage: rl_firewall_rl_firewall_set_rl_firewall_name_rule_source_range_start_stop <start:ipv4> <stop:ipv4> <name:txt> <rule:u32>"
        exit 1
    fi

    XRL="finder://rl_firewall/rl_firewall/0.1/set_rl_firewall_name_rule_source_range_start_stop?start:ipv4=$1&stop:ipv4=$2&name:txt=$3&rule:u32=$4"
    call_xrl_wrapper -p all "${XRL}"
}

rl_firewall_rl_firewall_delete_rl_firewall_name_rule_source_range_start_stop()
{
    if [ $# -ne 4 ] ; then
        echo "Usage: rl_firewall_rl_firewall_delete_rl_firewall_name_rule_source_range_start_stop <start:ipv4> <stop:ipv4> <name:txt> <rule:u32>"
        exit 1
    fi

    XRL="finder://rl_firewall/rl_firewall/0.1/delete_rl_firewall_name_rule_source_range_start_stop?start:ipv4=$1&stop:ipv4=$2&name:txt=$3&rule:u32=$4"
    call_xrl_wrapper -p all "${XRL}"
}

rl_firewall_rl_firewall_set_rl_firewall_name_rule_source_port_number()
{
    if [ $# -ne 3 ] ; then
        echo "Usage: rl_firewall_rl_firewall_set_rl_firewall_name_rule_source_port_number <port_number:u32> <name:txt> <rule:u32>"
        exit 1
    fi

    XRL="finder://rl_firewall/rl_firewall/0.1/set_rl_firewall_name_rule_source_port_number?port_number:u32=$1&name:txt=$2&rule:u32=$3"
    call_xrl_wrapper -p all "${XRL}"
}

rl_firewall_rl_firewall_delete_rl_firewall_name_rule_source_port_number()
{
    if [ $# -ne 3 ] ; then
        echo "Usage: rl_firewall_rl_firewall_delete_rl_firewall_name_rule_source_port_number <port_number:u32> <name:txt> <rule:u32>"
        exit 1
    fi

    XRL="finder://rl_firewall/rl_firewall/0.1/delete_rl_firewall_name_rule_source_port_number?port_number:u32=$1&name:txt=$2&rule:u32=$3"
    call_xrl_wrapper -p all "${XRL}"
}

rl_firewall_rl_firewall_set_rl_firewall_name_rule_source_port_name()
{
    if [ $# -ne 3 ] ; then
        echo "Usage: rl_firewall_rl_firewall_set_rl_firewall_name_rule_source_port_name <port_name:txt> <name:txt> <rule:u32>"
        exit 1
    fi

    XRL="finder://rl_firewall/rl_firewall/0.1/set_rl_firewall_name_rule_source_port_name?port_name:txt=$1&name:txt=$2&rule:u32=$3"
    call_xrl_wrapper -p all "${XRL}"
}

rl_firewall_rl_firewall_delete_rl_firewall_name_rule_source_port_name()
{
    if [ $# -ne 3 ] ; then
        echo "Usage: rl_firewall_rl_firewall_delete_rl_firewall_name_rule_source_port_name <port_name:txt> <name:txt> <rule:u32>"
        exit 1
    fi

    XRL="finder://rl_firewall/rl_firewall/0.1/delete_rl_firewall_name_rule_source_port_name?port_name:txt=$1&name:txt=$2&rule:u32=$3"
    call_xrl_wrapper -p all "${XRL}"
}

rl_firewall_rl_firewall_set_rl_firewall_name_rule_source_port_range_start_stop()
{
    if [ $# -ne 4 ] ; then
        echo "Usage: rl_firewall_rl_firewall_set_rl_firewall_name_rule_source_port_range_start_stop <start:u32> <stop:u32> <name:txt> <rule:u32>"
        exit 1
    fi

    XRL="finder://rl_firewall/rl_firewall/0.1/set_rl_firewall_name_rule_source_port_range_start_stop?start:u32=$1&stop:u32=$2&name:txt=$3&rule:u32=$4"
    call_xrl_wrapper -p all "${XRL}"
}

rl_firewall_rl_firewall_delete_rl_firewall_name_rule_source_port_range_start_stop()
{
    if [ $# -ne 4 ] ; then
        echo "Usage: rl_firewall_rl_firewall_delete_rl_firewall_name_rule_source_port_range_start_stop <start:u32> <stop:u32> <name:txt> <rule:u32>"
        exit 1
    fi

    XRL="finder://rl_firewall/rl_firewall/0.1/delete_rl_firewall_name_rule_source_port_range_start_stop?start:u32=$1&stop:u32=$2&name:txt=$3&rule:u32=$4"
    call_xrl_wrapper -p all "${XRL}"
}

rl_firewall_rl_firewall_set_rl_firewall_name_rule_destination_address()
{
    if [ $# -ne 3 ] ; then
        echo "Usage: rl_firewall_rl_firewall_set_rl_firewall_name_rule_destination_address <address:ipv4> <name:txt> <rule:u32>"
        exit 1
    fi

    XRL="finder://rl_firewall/rl_firewall/0.1/set_rl_firewall_name_rule_destination_address?address:ipv4=$1&name:txt=$2&rule:u32=$3"
    call_xrl_wrapper -p all "${XRL}"
}

rl_firewall_rl_firewall_delete_rl_firewall_name_rule_destination_address()
{
    if [ $# -ne 3 ] ; then
        echo "Usage: rl_firewall_rl_firewall_delete_rl_firewall_name_rule_destination_address <address:ipv4> <name:txt> <rule:u32>"
        exit 1
    fi

    XRL="finder://rl_firewall/rl_firewall/0.1/delete_rl_firewall_name_rule_destination_address?address:ipv4=$1&name:txt=$2&rule:u32=$3"
    call_xrl_wrapper -p all "${XRL}"
}

rl_firewall_rl_firewall_set_rl_firewall_name_rule_destination_network()
{
    if [ $# -ne 3 ] ; then
        echo "Usage: rl_firewall_rl_firewall_set_rl_firewall_name_rule_destination_network <network:ipv4net> <name:txt> <rule:u32>"
        exit 1
    fi

    XRL="finder://rl_firewall/rl_firewall/0.1/set_rl_firewall_name_rule_destination_network?network:ipv4net=$1&name:txt=$2&rule:u32=$3"
    call_xrl_wrapper -p all "${XRL}"
}

rl_firewall_rl_firewall_delete_rl_firewall_name_rule_destination_network()
{
    if [ $# -ne 3 ] ; then
        echo "Usage: rl_firewall_rl_firewall_delete_rl_firewall_name_rule_destination_network <network:ipv4net> <name:txt> <rule:u32>"
        exit 1
    fi

    XRL="finder://rl_firewall/rl_firewall/0.1/delete_rl_firewall_name_rule_destination_network?network:ipv4net=$1&name:txt=$2&rule:u32=$3"
    call_xrl_wrapper -p all "${XRL}"
}

rl_firewall_rl_firewall_set_rl_firewall_name_rule_destination_range_start_stop()
{
    if [ $# -ne 4 ] ; then
        echo "Usage: rl_firewall_rl_firewall_set_rl_firewall_name_rule_destination_range_start_stop <start:ipv4> <stop:ipv4> <name:txt> <rule:u32>"
        exit 1
    fi

    XRL="finder://rl_firewall/rl_firewall/0.1/set_rl_firewall_name_rule_destination_range_start_stop?start:ipv4=$1&stop:ipv4=$2&name:txt=$3&rule:u32=$4"
    call_xrl_wrapper -p all "${XRL}"
}

rl_firewall_rl_firewall_delete_rl_firewall_name_rule_destination_range_start_stop()
{
    if [ $# -ne 4 ] ; then
        echo "Usage: rl_firewall_rl_firewall_delete_rl_firewall_name_rule_destination_range_start_stop <start:ipv4> <stop:ipv4> <name:txt> <rule:u32>"
        exit 1
    fi

    XRL="finder://rl_firewall/rl_firewall/0.1/delete_rl_firewall_name_rule_destination_range_start_stop?start:ipv4=$1&stop:ipv4=$2&name:txt=$3&rule:u32=$4"
    call_xrl_wrapper -p all "${XRL}"
}

rl_firewall_rl_firewall_set_rl_firewall_name_rule_destination_port_number()
{
    if [ $# -ne 3 ] ; then
        echo "Usage: rl_firewall_rl_firewall_set_rl_firewall_name_rule_destination_port_number <port_number:u32> <name:txt> <rule:u32>"
        exit 1
    fi

    XRL="finder://rl_firewall/rl_firewall/0.1/set_rl_firewall_name_rule_destination_port_number?port_number:u32=$1&name:txt=$2&rule:u32=$3"
    call_xrl_wrapper -p all "${XRL}"
}

rl_firewall_rl_firewall_delete_rl_firewall_name_rule_destination_port_number()
{
    if [ $# -ne 3 ] ; then
        echo "Usage: rl_firewall_rl_firewall_delete_rl_firewall_name_rule_destination_port_number <port_number:u32> <name:txt> <rule:u32>"
        exit 1
    fi

    XRL="finder://rl_firewall/rl_firewall/0.1/delete_rl_firewall_name_rule_destination_port_number?port_number:u32=$1&name:txt=$2&rule:u32=$3"
    call_xrl_wrapper -p all "${XRL}"
}

rl_firewall_rl_firewall_set_rl_firewall_name_rule_destination_port_name()
{
    if [ $# -ne 3 ] ; then
        echo "Usage: rl_firewall_rl_firewall_set_rl_firewall_name_rule_destination_port_name <port_name:txt> <name:txt> <rule:u32>"
        exit 1
    fi

    XRL="finder://rl_firewall/rl_firewall/0.1/set_rl_firewall_name_rule_destination_port_name?port_name:txt=$1&name:txt=$2&rule:u32=$3"
    call_xrl_wrapper -p all "${XRL}"
}

rl_firewall_rl_firewall_delete_rl_firewall_name_rule_destination_port_name()
{
    if [ $# -ne 3 ] ; then
        echo "Usage: rl_firewall_rl_firewall_delete_rl_firewall_name_rule_destination_port_name <port_name:txt> <name:txt> <rule:u32>"
        exit 1
    fi

    XRL="finder://rl_firewall/rl_firewall/0.1/delete_rl_firewall_name_rule_destination_port_name?port_name:txt=$1&name:txt=$2&rule:u32=$3"
    call_xrl_wrapper -p all "${XRL}"
}

rl_firewall_rl_firewall_set_rl_firewall_name_rule_destination_port_range_start_stop()
{
    if [ $# -ne 4 ] ; then
        echo "Usage: rl_firewall_rl_firewall_set_rl_firewall_name_rule_destination_port_range_start_stop <start:u32> <stop:u32> <name:txt> <rule:u32>"
        exit 1
    fi

    XRL="finder://rl_firewall/rl_firewall/0.1/set_rl_firewall_name_rule_destination_port_range_start_stop?start:u32=$1&stop:u32=$2&name:txt=$3&rule:u32=$4"
    call_xrl_wrapper -p all "${XRL}"
}

rl_firewall_rl_firewall_delete_rl_firewall_name_rule_destination_port_range_start_stop()
{
    if [ $# -ne 4 ] ; then
        echo "Usage: rl_firewall_rl_firewall_delete_rl_firewall_name_rule_destination_port_range_start_stop <start:u32> <stop:u32> <name:txt> <rule:u32>"
        exit 1
    fi

    XRL="finder://rl_firewall/rl_firewall/0.1/delete_rl_firewall_name_rule_destination_port_range_start_stop?start:u32=$1&stop:u32=$2&name:txt=$3&rule:u32=$4"
    call_xrl_wrapper -p all "${XRL}"
}

rl_firewall_rl_firewall_get_firewall_rule_list()
{
    if [ $# -ne 1 ] ; then
        echo "Usage: rl_firewall_rl_firewall_get_firewall_rule_list <name:txt>"
        exit 1
    fi

    XRL="finder://rl_firewall/rl_firewall/0.1/get_firewall_rule_list?name:txt=$1"
    call_xrl_wrapper -p all "${XRL}"
}

