/**
 * Module: xrl_rl_system_node.hh
 *
 * Author: Michael Larson
 * Date: 2005
 */

#ifndef __RL_FIREWALL_XRL_RL_FIREWALL_NODE_HH__
#define __RL_FIREWALL_XRL_RL_FIREWALL_NODE_HH__


//
// RLSystem XRL-aware node definition.
//

#include "libxorp/status_codes.h"
#include "libxipc/xrl_std_router.hh"
#include "xrl/interfaces/finder_event_notifier_xif.hh"

#include "xrl/targets/rl_firewall_base.hh"

#include "rl_firewall_node.hh"

//
// The top-level class that wraps-up everything together under one roof
//
class XrlRLFirewallNode :     public XrlStdRouter, /* used for dispatch of xrl messages */
			      public XrlRlFirewallTargetBase { /* used for defined interface */
public:
    XrlRLFirewallNode(EventLoop&	eventloop,
		    const string&	class_name,
		    const string&	finder_hostname,
		    uint16_t	        finder_port,
		    const string&	finder_target);
    ~XrlRLFirewallNode();

    /**
     * Startup the node operation.
     *
     * @return true on success, false on failure.
     */
    bool	startup();

    /**
     * Shutdown the node operation.
     *
     * @return true on success, false on failure.
     */
    XrlCmdError	rl_firewall_0_1_shutdown_firewall();

    /**
     * Shutdown the node operation.
     *
     * @return true on success, false on failure.
     */
    /**
     * Get a reference to the XrlRouter instance.
     *
     * @return a reference to the XrlRouter (@ref XrlRouter) instance.
     */
    XrlRouter&	xrl_router() { return *this; }

    /**
     * Test if the node processing is done.
     * 
     * @return true if the node processing is done, otherwise false.
     */
    bool	is_done() const { return (_status == PROC_DONE); }

protected:
    //
    // XRL target methods
    //

    /**
     *  Get name of Xrl Target
     */
    XrlCmdError common_0_1_get_target_name(
	// Output values, 
	string&	name);

    /**
     *  Get version string from Xrl Target
     */
    XrlCmdError common_0_1_get_version(
	// Output values, 
	string&	version);

    /**
     *  Get status of Xrl Target
     */
    XrlCmdError common_0_1_get_status(
	// Output values, 
	uint32_t&	status, 
	string&	reason);

    /**
     *  Request clean shutdown of Xrl Target
     */
    XrlCmdError common_0_1_shutdown();

    /**
     *  Announce target birth to observer.
     *
     *  @param target_class the target class name.
     *
     *  @param target_instance the target instance name.
     */
    XrlCmdError finder_event_observer_0_1_xrl_target_birth(
	// Input values,
	const string&	target_class,
	const string&	target_instance);

    /**
     *  Announce target death to observer.
     *
     *  @param target_class the target class name.
     *
     *  @param target_instance the target instance name.
     */
    XrlCmdError finder_event_observer_0_1_xrl_target_death(
	// Input values,
	const string&	target_class,
	const string&	target_instance);

  /**
   *
   *
   *
   */
  XrlCmdError rl_firewall_0_1_delete_rl_firewall();

    /**
     *  Enable/disable/start/stop RLSystem
     *
     *  @param enable if true, then enable RLSystem, otherwise disable it.
     */
    XrlCmdError rl_firewall_0_1_enable_rl_firewall(
	// Input values,
	const bool&	enable);

    XrlCmdError rl_firewall_0_1_start_rl_firewall();

    XrlCmdError rl_firewall_0_1_stop_rl_firewall();

    /**
     *  Configure an interface
     *
     *  @param address of interface
     */
    XrlCmdError rl_firewall_0_1_add_interface(
	// Input values,
	const IPv4&	address);

    /**
     *  Enable/disable the RLSystem trace log for all operations.
     *
     *  @param enable if true, then enable the trace log, otherwise disable it.
     */
    XrlCmdError rl_firewall_0_1_enable_log_trace_all(
	// Input values,
	const bool&	enable);


  XrlCmdError rl_firewall_0_1_delete_rl_firewall_filter(
						   //Input values,
						   const string &name);

  XrlCmdError rl_firewall_0_1_start_rl_firewall_name_rule_transaction(
							       //Input values,
							       const string &name,
							       const uint32_t &rule);

  XrlCmdError rl_firewall_0_1_commit_rl_firewall_name_rule_transaction(
							       //Input values,
							       const string &name,
							       const uint32_t &rule);
  
  XrlCmdError rl_firewall_0_1_delete_rl_firewall_name_rule(
							       //Input values,
							       const string &name,
							       const uint32_t &rule);
  



  XrlCmdError rl_firewall_0_1_set_rl_firewall_log_martians(
					   //Input values,
					   const string &enable);
  
  XrlCmdError rl_firewall_0_1_set_rl_firewall_send_redirects(
					     //Input values,
					     const string &enable);
  XrlCmdError rl_firewall_0_1_set_rl_firewall_receive_redirects(
						//Input values,
						const string &enable);
  XrlCmdError rl_firewall_0_1_set_rl_firewall_ip_src_route(
					   //Input values,
					   const string &enable);
  XrlCmdError rl_firewall_0_1_set_rl_firewall_broadcast_ping(
					     //Input values,
					     const string &enable);
  
  XrlCmdError rl_firewall_0_1_set_rl_firewall_syn_cookies(
					  //Input values,
					  const string &enable);
  XrlCmdError rl_firewall_0_1_set_rl_firewall_name_rule_outbound_interface(
							   //Input values,
							   const string &outbound_interface,
							  const string &name,
							       const uint32_t &rule);
  XrlCmdError rl_firewall_0_1_delete_rl_firewall_name_rule_outbound_interface(
							      //Input values,
							      const string &outbound_interface,
							  const string &name,
							       const uint32_t &rule);
  
  XrlCmdError rl_firewall_0_1_set_rl_firewall_name_rule_protocol(
						 //Input values,
						 const string &protocol,
							  const string &name,
						 const uint32_t &rule);
  XrlCmdError rl_firewall_0_1_delete_rl_firewall_name_rule_protocol(
						    //Input values,
						    const string &protocol,
							  const string &name,
						    const uint32_t &rule);
  
  XrlCmdError rl_firewall_0_1_set_rl_firewall_name_rule_icmp_type(
								  //Input values,
								  const string &type,
								  const string &name,
								  const uint32_t &rule);
  XrlCmdError rl_firewall_0_1_delete_rl_firewall_name_rule_icmp_type(
								     //Input values,
								     const string &type,
								     const string &name,
								     const uint32_t &rule);
  
  XrlCmdError rl_firewall_0_1_set_rl_firewall_name_rule_icmp_code(
						       //Input values,
						       const string &code,
							  const string &name,
						       const uint32_t &rule);
  XrlCmdError rl_firewall_0_1_delete_rl_firewall_name_rule_icmp_code(
							  //Input values,
							  const string &icmp_code,
							  const string &name,
							  const uint32_t &rule);
  
  XrlCmdError rl_firewall_0_1_set_rl_firewall_name_rule_state_established(
							  //Input values,
							  const string &enable,
							  const string &name,
							  const uint32_t &rule);
  XrlCmdError rl_firewall_0_1_delete_rl_firewall_name_rule_state_established(
							     //Input values,
							     const string &enable,
							  const string &name,
							       const uint32_t &rule);
  
  XrlCmdError rl_firewall_0_1_set_rl_firewall_name_rule_state_new(
						  //Input values,
						  const string &enable,
							  const string &name,
						  const uint32_t &rule);
  XrlCmdError rl_firewall_0_1_delete_rl_firewall_name_rule_state_new(
						     //Input values,
						     const string &enable,
							  const string &name,
						     const uint32_t &rule);
  
  XrlCmdError rl_firewall_0_1_set_rl_firewall_name_rule_state_related(
						      //Input values,
						      const string &enable,
							  const string &name,
						      const uint32_t &rule);
  XrlCmdError rl_firewall_0_1_delete_rl_firewall_name_rule_state_related(
							 //Input values,
							 const string &enable,
							  const string &name,
							 const uint32_t &rule);
  
  XrlCmdError rl_firewall_0_1_set_rl_firewall_name_rule_state_invalid(
						      //Input values,
						      const string &enable,
						      const string &name,
						      const uint32_t &rule);
  XrlCmdError rl_firewall_0_1_delete_rl_firewall_name_rule_state_invalid(
							 //Input values,
							 const string &enable,
							 const string &name,
							 const uint32_t &rule);

  XrlCmdError rl_firewall_0_1_set_rl_firewall_name_rule_action(
					       //Input values,
					       const string &action,
					       const string &name,
					       const uint32_t &rule);
  XrlCmdError rl_firewall_0_1_delete_rl_firewall_name_rule_action(
						  //Input values,
						  const string &action,
							  const string &name,
						  const uint32_t &rule);
  
  XrlCmdError rl_firewall_0_1_set_rl_firewall_name_rule_log(
					       //Input values,
					       const string &log,
					       const string &name,
					       const uint32_t &rule);

  XrlCmdError rl_firewall_0_1_set_rl_firewall_name_rule_source_address(
						       //Input values,
						       const IPv4 &address,
							  const string &name,
						       const uint32_t &rule);
  XrlCmdError rl_firewall_0_1_delete_rl_firewall_name_rule_source_address(
							  //Input values,
							  const IPv4 &address,
							  const string &name,
							  const uint32_t &rule);
  
  XrlCmdError rl_firewall_0_1_set_rl_firewall_name_rule_source_network(
						       //Input values,
						       const IPv4Net &network,
							  const string &name,
						       const uint32_t &rule);
  XrlCmdError rl_firewall_0_1_delete_rl_firewall_name_rule_source_network(
							  //Input values,
							  const IPv4Net &network,
							  const string &name,
							  const uint32_t &rule);
  
  XrlCmdError rl_firewall_0_1_set_rl_firewall_name_rule_source_range_start_stop(
						     //Input values,
						     const IPv4 &start,
						     const IPv4 &stop,
							  const string &name,
						     const uint32_t &rule);
  XrlCmdError rl_firewall_0_1_delete_rl_firewall_name_rule_source_range_start_stop(
							//Input values,
							const IPv4 &start,
							const IPv4 &stop,
							  const string &name,
							const uint32_t &rule);
  
  XrlCmdError rl_firewall_0_1_set_rl_firewall_name_rule_source_port_number(
							   //Input values,
							   const uint32_t &port_number,
							  const string &name,
							       const uint32_t &rule);

  XrlCmdError rl_firewall_0_1_delete_rl_firewall_name_rule_source_port_number(
							      //Input values,
							      const uint32_t &port_number,
							  const string &name,
							       const uint32_t &rule);

  
  XrlCmdError rl_firewall_0_1_set_rl_firewall_name_rule_source_port_name(
							 //Input values,
							 const string &port_name,
							  const string &name,
							       const uint32_t &rule);

  XrlCmdError rl_firewall_0_1_delete_rl_firewall_name_rule_source_port_name(
							    //Input values,
							    const string &port_name,
							  const string &name,
							       const uint32_t &rule);

  XrlCmdError rl_firewall_0_1_set_rl_firewall_name_rule_source_port_range_start_stop(
								//Input values,
								const uint32_t &start,
								const uint32_t &stop,
							  const string &name,
							       const uint32_t &rule);

  XrlCmdError rl_firewall_0_1_delete_rl_firewall_name_rule_source_port_range_start_stop(
									//Input values,
									const uint32_t &start,
									const uint32_t &stop,
									const string &name,
									const uint32_t &rule);
  
  XrlCmdError rl_firewall_0_1_set_rl_firewall_name_rule_destination_address(
							       //Input values,
							    const IPv4 &address,
							  const string &name,
							       const uint32_t &rule);

  XrlCmdError rl_firewall_0_1_delete_rl_firewall_name_rule_destination_address(
							       //Input values,
							       const IPv4 &address,
							  const string &name,
							       const uint32_t &rule);

  
  XrlCmdError rl_firewall_0_1_set_rl_firewall_name_rule_destination_network(
							       //Input values,
							    const IPv4Net &network,
							  const string &name,
							       const uint32_t &rule);

  XrlCmdError rl_firewall_0_1_delete_rl_firewall_name_rule_destination_network(
							       //Input values,
							       const IPv4Net &network,
							  const string &name,
							       const uint32_t &rule);

  
  XrlCmdError rl_firewall_0_1_set_rl_firewall_name_rule_destination_range_start_stop(
							       //Input values,
							  const IPv4 &start,
							  const IPv4 &stop,
							  const string &name,
							       const uint32_t &rule);

  XrlCmdError rl_firewall_0_1_delete_rl_firewall_name_rule_destination_range_start_stop(
							     //Input values,
							     const IPv4 &start,
							     const IPv4 &stop,
							  const string &name,
							     const uint32_t &rule);

  XrlCmdError rl_firewall_0_1_set_rl_firewall_name_rule_destination_port_number(
							       //Input values,
								const uint32_t &port_number,
							  const string &name,
							       const uint32_t &rule);

  XrlCmdError rl_firewall_0_1_delete_rl_firewall_name_rule_destination_port_number(
							       //Input values,
								   const uint32_t &port_number,
							  const string &name,
							       const uint32_t &rule);

  
  XrlCmdError rl_firewall_0_1_set_rl_firewall_name_rule_destination_port_name(
							       //Input values,
							      const string &port_name,
							  const string &name,
							       const uint32_t &rule);

  XrlCmdError rl_firewall_0_1_delete_rl_firewall_name_rule_destination_port_name(
							       //Input values,
								 const string &port_name,
							  const string &name,
							       const uint32_t &rule);

  
  XrlCmdError rl_firewall_0_1_set_rl_firewall_name_rule_destination_port_range_start_stop(
									  //Input values,
									  const uint32_t &start,
									  const uint32_t &stop,
							  const string &name,
									  const uint32_t &rule);
  
  XrlCmdError rl_firewall_0_1_delete_rl_firewall_name_rule_destination_port_range_start_stop(
									     //Input values,
									     const uint32_t &start,
									     const uint32_t &stop,
							  const string &name,
									     const uint32_t &rule);
  
  XrlCmdError rl_firewall_0_1_get_firewall_rule_list(
						     //Input values,
						     const string &name,
						     //output values,
						     XrlAtomList &rules);
  

private:
  /**
   * Called when Finder connection is established.
   *
   * Note that this method overwrites an XrlRouter virtual method.
   */
  virtual void finder_connect_event();
  
  /**
   * Called when Finder disconnect occurs.
   *
   * Note that this method overwrites an XrlRouter virtual method.
   */
  virtual void finder_disconnect_event();
  
  const string& my_xrl_target_name() {
      return XrlRlFirewallTargetBase::name();
    }
  
  EventLoop&		_eventloop;
  const string	_class_name;
  const string	_instance_name;
  const string	_finder_target;
  
  XrlFinderEventNotifierV0p1Client	_xrl_finder_client;
  
  static const TimeVal RETRY_TIMEVAL;
  
  bool		_is_finder_alive;
  
  RLFirewallNode    _rl_firewall_node;

  uint32_t         _status;
};

#endif // __RL_FIREWALL_XRL_RL_FIREWALL_NODE_HH__
