/**
 * Module: xrl_rl_firewall_node.hh
 *
 * Author: Michael Larson
 * Date: 2005
 */

#include "rl_firewall_module.h"

#include "libxorp/xorp.h"
#include "libxorp/xlog.h"
#include "libxorp/debug.h"
#include "libxorp/ipvx.hh"
#include "libxorp/status_codes.h"

#include "xrl_rl_firewall_node.hh"

XrlRLFirewallNode::XrlRLFirewallNode(EventLoop&	eventloop,
				 const string&	class_name,
				 const string&	finder_hostname,
				 uint16_t	finder_port,
				 const string&	finder_target)
    : XrlStdRouter(eventloop, class_name.c_str(), finder_hostname.c_str(),
		   finder_port),
      XrlRlFirewallTargetBase(&xrl_router()),
      _eventloop(eventloop),
      _class_name(xrl_router().class_name()),
      _instance_name(xrl_router().instance_name()),
      _finder_target(finder_target),
      _xrl_finder_client(&xrl_router()),
      _is_finder_alive(false),
      _status(PROC_STARTUP)
{
}

XrlRLFirewallNode::~XrlRLFirewallNode()
{
  rl_firewall_0_1_shutdown_firewall();
}

bool
XrlRLFirewallNode::startup()
{
  _status = PROC_READY;
  return true;
}

XrlCmdError
XrlRLFirewallNode::rl_firewall_0_1_shutdown_firewall()
{
  //handles shutdown of system and deletion of nodes?
  XrlCmdError err =  _rl_firewall_node.reset();
  _status = PROC_SHUTDOWN;
  return err;
}

//
// Finder-related events
//
/**
 * Called when Finder connection is established.
 *
 * Note that this method overwrites an XrlRouter virtual method.
 */
void
XrlRLFirewallNode::finder_connect_event()
{
    //printf("%s\n",__PRETTY_FUNCTION__);
    _is_finder_alive = true;
}

/**
 * Called when Finder disconnect occurs.
 *
 * Note that this method overwrites an XrlRouter virtual method.
 */
void
XrlRLFirewallNode::finder_disconnect_event()
{
    XLOG_ERROR("Finder disconnect event. Exiting immediately...");
    //printf("%s\n",__PRETTY_FUNCTION__);

    _is_finder_alive = false;
}

//
// XRL target methods
//

/**
 *  Get name of Xrl Target
 */
XrlCmdError
XrlRLFirewallNode::common_0_1_get_target_name(
    // Output values, 
    string&	name)
{
    //printf("%s\n",__PRETTY_FUNCTION__);
    name = my_xrl_target_name();

    return XrlCmdError::OKAY();
}

/**
 *  Get version string from Xrl Target
 */
XrlCmdError
XrlRLFirewallNode::common_0_1_get_version(
    // Output values, 
    string&	version)
{
    //printf("%s\n",__PRETTY_FUNCTION__);
    version = XORP_MODULE_VERSION;

    return XrlCmdError::OKAY();
}

/**
 *  Get status of Xrl Target
 */
XrlCmdError
XrlRLFirewallNode::common_0_1_get_status(
    // Output values, 
    uint32_t&	status, 
    string&	reason)
{
  reason = " ";
  status = _status;

  if (PROC_SHUTDOWN == _status) {
    _status = PROC_DONE;
  }

  return XrlCmdError::OKAY();
}

/**
 *  Request clean shutdown of Xrl Target
 */
XrlCmdError
XrlRLFirewallNode::common_0_1_shutdown()
{
    string error_msg;
    //printf("%s\n",__PRETTY_FUNCTION__);
    /*
    if (shutdown() != true) {
	error_msg = c_format("Failed to shutdown RLFirewall");
	return XrlCmdError::COMMAND_FAILED(error_msg);
    }
    */
    return XrlCmdError::OKAY();
}

/**
 *  Announce target birth to observer.
 *
 *  @param target_class the target class name.
 *
 *  @param target_instance the target instance name.
 */
XrlCmdError
XrlRLFirewallNode::finder_event_observer_0_1_xrl_target_birth(
    // Input values,
    const string&   target_class,
    const string&   target_instance)
{
    //printf("%s\n",__PRETTY_FUNCTION__);
    return XrlCmdError::OKAY();
    UNUSED(target_class);
    UNUSED(target_instance);
}

/**
 *  Announce target death to observer.
 *
 *  @param target_class the target class name.
 *
 *  @param target_instance the target instance name.
 */
XrlCmdError
XrlRLFirewallNode::finder_event_observer_0_1_xrl_target_death(
    // Input values,
    const string&   target_class,
    const string&   target_instance)
{
    //printf("%s\n",__PRETTY_FUNCTION__);
    return XrlCmdError::OKAY();
    UNUSED(target_class);
    UNUSED(target_instance);
}

/**
 *
 *
 */
XrlCmdError
XrlRLFirewallNode::rl_firewall_0_1_delete_rl_firewall()
{
  return _rl_firewall_node.delete_all();
}

/**
 *  Enable/disable/start/stop RLFirewall.
 *
 *  @param enable if true, then enable RLFirewall, otherwise disable it.
 */
XrlCmdError
XrlRLFirewallNode::rl_firewall_0_1_enable_rl_firewall(
    // Input values,
    const bool&	enable)
{
    //printf("%s\n",__PRETTY_FUNCTION__);
    UNUSED(enable);

    // XLOG_UNFINISHED();

    return XrlCmdError::OKAY();
}

XrlCmdError
XrlRLFirewallNode::rl_firewall_0_1_start_rl_firewall()
{
    //printf("%s\n",__PRETTY_FUNCTION__);
    // XLOG_UNFINISHED();

    return XrlCmdError::OKAY();
}

XrlCmdError
XrlRLFirewallNode::rl_firewall_0_1_stop_rl_firewall()
{
    //printf("%s\n",__PRETTY_FUNCTION__);
    XLOG_UNFINISHED();

    return XrlCmdError::OKAY();
}

/**
 *  Add an interface
 *
 *  @param add an interface
 */
XrlCmdError
XrlRLFirewallNode::rl_firewall_0_1_add_interface(
    // Input values,
    const IPv4&	address)
{
    UNUSED(address);

    //printf("%s\n",__PRETTY_FUNCTION__);
    string error_msg;

    //ADD INTERFACE EXEC HERE!
    //printf("XrlRLFirewallNode::rl_firewall_0_1_add_interface()--called!\n");

    return XrlCmdError::OKAY();
}

/**
 *  Enable/disable the RLFirewall trace log for all operations.
 *
 *  @param enable if true, then enable the trace log, otherwise disable it.
 */
XrlCmdError
XrlRLFirewallNode::rl_firewall_0_1_enable_log_trace_all(
    // Input values,
    const bool&	enable)
{
    UNUSED(enable);

    //printf("%s\n",__PRETTY_FUNCTION__);
    return XrlCmdError::OKAY();
}


XrlCmdError 
XrlRLFirewallNode::rl_firewall_0_1_start_rl_firewall_name_rule_transaction(
								       //Input values,
								       const string &name, 
								       const uint32_t &rule)
{
  return _rl_firewall_node.start_transaction(name, rule);
}

XrlCmdError 
XrlRLFirewallNode::rl_firewall_0_1_commit_rl_firewall_name_rule_transaction(
								       //Input values,
								       const string &name, 
								       const uint32_t &rule)
{
  return _rl_firewall_node.commit_transaction(name, rule);
}
    
XrlCmdError 
XrlRLFirewallNode::rl_firewall_0_1_delete_rl_firewall_filter(
						 //Input values,
						 const string &name)
{
  return _rl_firewall_node.delete_name(name);
}

XrlCmdError 
XrlRLFirewallNode::rl_firewall_0_1_delete_rl_firewall_name_rule(
								       //Input values,
								       const string &name, 
								       const uint32_t &rule)
{
  return _rl_firewall_node.delete_rule_number(name, rule);
}


XrlCmdError 
XrlRLFirewallNode::rl_firewall_0_1_set_rl_firewall_log_martians(
					   //Input values,
					   const string &enable)
{
  return _rl_firewall_node.set_log_martians(enable);
}
  
XrlCmdError 
XrlRLFirewallNode::rl_firewall_0_1_set_rl_firewall_send_redirects(
					     //Input values,
					     const string &enable)
{
  return _rl_firewall_node.set_send_redirects(enable);
}

XrlCmdError 
XrlRLFirewallNode::rl_firewall_0_1_set_rl_firewall_receive_redirects(
						//Input values,
						const string &enable)
{
  return _rl_firewall_node.set_receive_redirects(enable);
}

XrlCmdError 
XrlRLFirewallNode::rl_firewall_0_1_set_rl_firewall_ip_src_route(
						//Input values,
						const string &enable)
{
  return _rl_firewall_node.set_ip_src_route(enable);
}

XrlCmdError 
XrlRLFirewallNode::rl_firewall_0_1_set_rl_firewall_broadcast_ping(
					     //Input values,
					     const string &enable)
{
  return _rl_firewall_node.set_broadcast_ping(enable);
}

XrlCmdError 
XrlRLFirewallNode::rl_firewall_0_1_set_rl_firewall_syn_cookies(
					  //Input values,
					  const string &enable)
{
  return _rl_firewall_node.set_syn_cookies(enable);
}

XrlCmdError 
XrlRLFirewallNode::rl_firewall_0_1_set_rl_firewall_name_rule_protocol(
						      //Input values,
						      const string &protocol,
						      const string &name,
						      const uint32_t &rule)
{
  return _rl_firewall_node.set_protocol(protocol, name, rule);
}
XrlCmdError 
XrlRLFirewallNode::rl_firewall_0_1_delete_rl_firewall_name_rule_protocol(
						    //Input values,
							 const string &protocol,
							 const string &name,
							 const uint32_t &rule)
{
  return _rl_firewall_node.delete_protocol(name, rule);
  UNUSED(protocol);
}
  
XrlCmdError 
XrlRLFirewallNode::rl_firewall_0_1_set_rl_firewall_name_rule_icmp_type(
								       //Input values,
								       const string &type,
								       const string &name,
								       const uint32_t &rule)
{
  return _rl_firewall_node.set_icmp_type(type, name, rule);
}
XrlCmdError 
XrlRLFirewallNode::rl_firewall_0_1_delete_rl_firewall_name_rule_icmp_type(
									  //Input values,
									  const string &type,
									  const string &name,
									  const uint32_t &rule)
{
  return _rl_firewall_node.delete_icmp_type(name, rule);
  UNUSED(type);
}
  
XrlCmdError 
XrlRLFirewallNode::rl_firewall_0_1_set_rl_firewall_name_rule_icmp_code(
									    //Input values,
									    const string &code,
									    const string &name,
									    const uint32_t &rule)
{
  return _rl_firewall_node.set_icmp_code(code, name, rule);
}
XrlCmdError 
XrlRLFirewallNode::rl_firewall_0_1_delete_rl_firewall_name_rule_icmp_code(
							       //Input values,
							       const string &code,
							       const string &name,
							       const uint32_t &rule)
{
  return _rl_firewall_node.delete_icmp_code(name, rule);
  UNUSED(code);
}
  
XrlCmdError 
XrlRLFirewallNode::rl_firewall_0_1_set_rl_firewall_name_rule_state_established(
							  //Input values,
							       const string &enable,
							       const string &name,
								       const uint32_t &rule)
{
  return _rl_firewall_node.set_rule_state_established(enable, name, rule);
}
XrlCmdError 
XrlRLFirewallNode::rl_firewall_0_1_delete_rl_firewall_name_rule_state_established(
							     //Input values,
								  const string &enable,
							       const string &name,
  								       const uint32_t &rule)
{
  return _rl_firewall_node.set_rule_state_established(enable, name, rule);
}
XrlCmdError 
XrlRLFirewallNode::rl_firewall_0_1_set_rl_firewall_name_rule_state_new(
						       //Input values,
						       const string &enable,
							       const string &name,
						       const uint32_t &rule)
{
  return _rl_firewall_node.set_rule_state_new(enable, name, rule);
}								       
XrlCmdError 
XrlRLFirewallNode::rl_firewall_0_1_delete_rl_firewall_name_rule_state_new(
							  //Input values,
							  const string &enable,
							  const string &name,
							  const uint32_t &rule)
{
  return _rl_firewall_node.set_rule_state_new(enable, name, rule);
}
  
XrlCmdError 
XrlRLFirewallNode::rl_firewall_0_1_set_rl_firewall_name_rule_state_related(
							   //Input values,
							   const string &enable,
							       const string &name,
								       const uint32_t &rule)
{
  return _rl_firewall_node.set_rule_state_related(enable, name, rule);
}

XrlCmdError 
XrlRLFirewallNode::rl_firewall_0_1_delete_rl_firewall_name_rule_state_related(
							      //Input values,
							      const string &enable,
							       const string &name,
							      const uint32_t &rule)
{
  return _rl_firewall_node.set_rule_state_related(enable, name, rule);
}
  
XrlCmdError 
XrlRLFirewallNode::rl_firewall_0_1_set_rl_firewall_name_rule_state_invalid(
							   //Input values,
							   const string &enable,
							       const string &name,
							   const uint32_t &rule)
{
  return _rl_firewall_node.set_rule_state_invalid(enable, name, rule);
}
XrlCmdError 
XrlRLFirewallNode::rl_firewall_0_1_delete_rl_firewall_name_rule_state_invalid(
							      //Input values,
							      const string &enable,
							       const string &name,
							      const uint32_t &rule)
{
  return _rl_firewall_node.set_rule_state_invalid(enable, name, rule);
}

  
XrlCmdError 
XrlRLFirewallNode::rl_firewall_0_1_set_rl_firewall_name_rule_action(
						    //Input values,
						    const string &action,
							       const string &name,
						    const uint32_t &rule)
{
  return _rl_firewall_node.set_rule_action(action, name, rule);
}

XrlCmdError 
XrlRLFirewallNode::rl_firewall_0_1_delete_rl_firewall_name_rule_action(
						       //Input values,
						       const string &action,
							       const string &name,
						       const uint32_t &rule)
{
  UNUSED(action);

  string empty;
  return _rl_firewall_node.set_rule_action(empty, name, rule);
}

  
XrlCmdError 
XrlRLFirewallNode::rl_firewall_0_1_set_rl_firewall_name_rule_log(
						    //Input values,
						    const string &log,
							       const string &name,
						    const uint32_t &rule)
{
  return _rl_firewall_node.set_rule_log(log, name, rule);
}

XrlCmdError 
XrlRLFirewallNode::rl_firewall_0_1_set_rl_firewall_name_rule_source_address(
							    //Input values,
							    const IPv4 &address,
							       const string &name,
							    const uint32_t &rule)
{
  return _rl_firewall_node.set_source_address(address, name, rule);
}

XrlCmdError 
XrlRLFirewallNode::rl_firewall_0_1_delete_rl_firewall_name_rule_source_address(
							  //Input values,
							       const IPv4 &address,
							       const string &name,
								       const uint32_t &rule)
{
  return _rl_firewall_node.delete_source_address(name, rule);
  UNUSED(address);
}

  
XrlCmdError 
XrlRLFirewallNode::rl_firewall_0_1_set_rl_firewall_name_rule_source_network(
						       //Input values,
							    const IPv4Net &network,
							       const string &name,
								       const uint32_t &rule)
{
  return _rl_firewall_node.set_source_network(network, name, rule);
}
XrlCmdError 
XrlRLFirewallNode::rl_firewall_0_1_delete_rl_firewall_name_rule_source_network(
							  //Input values,
							       const IPv4Net &network,
							       const string &name,
								       const uint32_t &rule)
{
  return _rl_firewall_node.delete_source_network(name, rule);
  UNUSED(network);
}

  
XrlCmdError 
XrlRLFirewallNode::rl_firewall_0_1_set_rl_firewall_name_rule_source_range_start_stop(
								     //Input values,
								     const IPv4 &start,
								     const IPv4 &stop,
								     const string &name,
								     const uint32_t &rule)
{
  return _rl_firewall_node.set_source_range(start, stop, name, rule);
  UNUSED(start);
  UNUSED(stop);
}

XrlCmdError 
XrlRLFirewallNode::rl_firewall_0_1_delete_rl_firewall_name_rule_source_range_start_stop(
									//Input values,
									const IPv4 &start,
									const IPv4 &stop,
									const string &name,
									const uint32_t &rule)
{
  return _rl_firewall_node.delete_source_range(name, rule);
  UNUSED(start);
  UNUSED(stop);
}

  
XrlCmdError 
XrlRLFirewallNode::rl_firewall_0_1_set_rl_firewall_name_rule_source_port_number(
							   //Input values,
								const uint32_t &port_number,
							       const string &name,
								       const uint32_t &rule)
{
  return _rl_firewall_node.set_source_port_number(port_number, name, rule);
}

XrlCmdError 
XrlRLFirewallNode::rl_firewall_0_1_delete_rl_firewall_name_rule_source_port_number(
							      //Input values,
								   const uint32_t &port_number,
							       const string &name,
								       const uint32_t &rule)
{
  return _rl_firewall_node.delete_source_port_number(name, rule);
  UNUSED(port_number);
}


  
XrlCmdError 
XrlRLFirewallNode::rl_firewall_0_1_set_rl_firewall_name_rule_source_port_name(
							      //Input values,
							      const string &port_name,
							      const string &name,
							      const uint32_t &rule)
{
  return _rl_firewall_node.set_source_port_name(port_name, name, rule);
}

XrlCmdError 
XrlRLFirewallNode::rl_firewall_0_1_delete_rl_firewall_name_rule_source_port_name(
							    //Input values,
								 const string &port_name,
							       const string &name,
								       const uint32_t &rule)
{
  return _rl_firewall_node.delete_source_port_name(name, rule);
  UNUSED(port_name);
}
  
  
XrlCmdError 
XrlRLFirewallNode::rl_firewall_0_1_set_rl_firewall_name_rule_source_port_range_start_stop(
								//Input values,
								     const uint32_t &start,
								     const uint32_t &stop,
								     const string &name,
								     const uint32_t &rule)
{
  return _rl_firewall_node.set_source_port_range(start, stop, name, rule);
}

XrlCmdError 
XrlRLFirewallNode::rl_firewall_0_1_delete_rl_firewall_name_rule_source_port_range_start_stop(
									     //Input values,
									     const uint32_t &start,
									     const uint32_t &stop,
									     const string &name,
									     const uint32_t &rule)
{
  return _rl_firewall_node.delete_source_port_range(name, rule);
  UNUSED(start);
  UNUSED(stop);
}

  
XrlCmdError 
XrlRLFirewallNode::rl_firewall_0_1_set_rl_firewall_name_rule_destination_address(
							       //Input values,
								 const IPv4 &address,
								 const string &name,
								 const uint32_t &rule)
{
  return _rl_firewall_node.set_destination_address(address, name, rule);
}

XrlCmdError 
XrlRLFirewallNode::rl_firewall_0_1_delete_rl_firewall_name_rule_destination_address(
							       //Input values,
								    const IPv4 &address,
							       const string &name,
								       const uint32_t &rule)
{
  return _rl_firewall_node.delete_destination_address(name, rule);
  UNUSED(address);
}
  
XrlCmdError 
XrlRLFirewallNode::rl_firewall_0_1_set_rl_firewall_name_rule_destination_network(
							       //Input values,
								 const IPv4Net &network,
							       const string &name,
								       const uint32_t &rule)
{
  return _rl_firewall_node.set_destination_network(network, name, rule);
}

XrlCmdError 
XrlRLFirewallNode::rl_firewall_0_1_delete_rl_firewall_name_rule_destination_network(
								    //Input values,
								    const IPv4Net &network,
								    const string &name,
								    const uint32_t &rule)
{
  return _rl_firewall_node.delete_destination_network(name, rule);
  UNUSED(network);
}

  
XrlCmdError 
XrlRLFirewallNode::rl_firewall_0_1_set_rl_firewall_name_rule_destination_range_start_stop(
											  //Input values,
											  const IPv4 &start,
											  const IPv4 &stop,
											  const string &name,
											  const uint32_t &rule)
{
  return _rl_firewall_node.set_destination_range(start, stop, name, rule);
}

XrlCmdError 
XrlRLFirewallNode::rl_firewall_0_1_delete_rl_firewall_name_rule_destination_range_start_stop(
											     //Input values,
											     const IPv4 &start,
											     const IPv4 &stop,
											     const string &name,
											     const uint32_t &rule)
{
  return _rl_firewall_node.delete_destination_range(name, rule);
  UNUSED(start);
  UNUSED(stop);
}

XrlCmdError 
XrlRLFirewallNode::rl_firewall_0_1_set_rl_firewall_name_rule_destination_port_number(
								     //Input values,
								     const uint32_t &port_number,
							       const string &name,
								     const uint32_t &rule)
{
  return _rl_firewall_node.set_destination_port_number(port_number, name, rule);
}

XrlCmdError 
XrlRLFirewallNode::rl_firewall_0_1_delete_rl_firewall_name_rule_destination_port_number(
							       //Input values,
									const uint32_t &port_number,
							       const string &name,
								       const uint32_t &rule)
{
  return _rl_firewall_node.delete_destination_port_name(name, rule);
  UNUSED(port_number);
}

  
XrlCmdError 
XrlRLFirewallNode::rl_firewall_0_1_set_rl_firewall_name_rule_destination_port_name(
								   //Input values,
								   const string &port_name,
							       const string &name,
								   const uint32_t &rule)
{
  return _rl_firewall_node.set_destination_port_name(port_name, name, rule);
}

XrlCmdError 
XrlRLFirewallNode::rl_firewall_0_1_delete_rl_firewall_name_rule_destination_port_name(
							       //Input values,
								      const string &port_name,
							       const string &name,
								       const uint32_t &rule)
{
  return _rl_firewall_node.delete_destination_port_name(name, rule);
  UNUSED(port_name);
  
}

  
XrlCmdError 
XrlRLFirewallNode::rl_firewall_0_1_set_rl_firewall_name_rule_destination_port_range_start_stop(
									       //Input values,
									       const uint32_t &start,
									       const uint32_t &stop,
							       const string &name,
									       const uint32_t &rule)
{
  return _rl_firewall_node.set_destination_port_range(start, stop, name, rule);
}
XrlCmdError 
XrlRLFirewallNode::rl_firewall_0_1_delete_rl_firewall_name_rule_destination_port_range_start_stop(
									     //Input values,
									     const uint32_t &start,
									     const uint32_t &stop,
									     const string &name,
									     const uint32_t &rule)
{
  return _rl_firewall_node.delete_destination_port_range(name, rule);
  UNUSED(start);
  UNUSED(stop);
}

XrlCmdError 
XrlRLFirewallNode::rl_firewall_0_1_get_firewall_rule_list(
							  //input values,
							  const string &name,
							  //output values,
							  XrlAtomList &rules)
{
  return _rl_firewall_node.retrieve_rules(name, rules);
}
