/*
 * Module: rl_firewall_node.hh
 *
 * **** License ****
 * Version: VPL 1.0
 *
 * The contents of this file are subject to the Vyatta Public License
 * Version 1.0 ("License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.vyatta.com/vpl
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
 * the License for the specific language governing rights and limitations
 * under the License.
 *
 * This code was originally developed by Vyatta, Inc.
 * Portions created by Vyatta are Copyright (C) 2005, 2006, 2007 Vyatta, Inc.
 * All Rights Reserved.
 *
 * Author: Michael Larson
 * Date: 2005
 * Description:
 *
 * **** End License ****
 *
 */
#ifndef __RL_FIREWALL_RL_FIREWALL_NODE_HH__
#define __RL_FIREWALL_RL_FIREWALL_NODE_HH__

#include <string>
#include <vector>
#include <set>
#include <map>
#include <list>
#include <cctype> 
#include <algorithm> 
#include "librl_common/rl_nat.hh"
#include "librl_common/rl_fw.hh"
#include <libxipc/xrl_atom_list.hh>
#include <libxipc/xrl_error.hh>
#include <libxorp/ipv4.hh>
#include <libxorp/ipv4net.hh>

/****************************************************************************
 *
 ***************************************************************************/
/*
class FirewallRule 
{
public: //methods
  FirewallRule();
  ~FirewallRule() {}

  XrlCmdError
  create_rule(string &rule_spec) const;

  void
  commit_mods() {_cur_rule = _mod_rule; _new = false;}

  void
  rollback_mods() {_mod_rule = _cur_rule;}

  bool
  is_new() const {return _new;}

  void
  dump(ostream &os) const;

  FirewallRuleData
  expose() {return _cur_rule;}

public: //variables
  FirewallRuleData _mod_rule;

protected: //methods
  friend ostream& operator<< (ostream& os, const FirewallRule& obj)
  {
    obj.dump(os);
    return os;
  }

private: //variables
  FirewallRuleData _cur_rule;
  bool _new;
};
*/

/****************************************************************************
 *
 ***************************************************************************/
class RLFirewallNode
{
public:
  /*
  typedef map<uint32_t, FirewallRule> FirewallRuleColl;
  typedef map<uint32_t, FirewallRule>::iterator FirewallRuleIter;
  */
  typedef map<string, FWChain> FirewallColl;
  typedef map<string, FWChain>::iterator FirewallIter;

public:
  RLFirewallNode();
  ~RLFirewallNode();

  XrlCmdError reset();

  XrlCmdError start_transaction(const string &filter, const uint32_t &rule_number);

  XrlCmdError commit_transaction(const string &filter, const uint32_t &rule_number);

  XrlCmdError delete_all();

  XrlCmdError delete_name(const string &filter);
  
  XrlCmdError delete_rule_number(const string &filter, const uint32_t &rule_number);
  
  XrlCmdError set_log_martians(const string &enable);

  XrlCmdError set_send_redirects(const string &enable);

  XrlCmdError set_receive_redirects(const string &enable);

  XrlCmdError set_ip_src_route(const string &enable);

  XrlCmdError set_broadcast_ping(const string &enable);

  XrlCmdError set_syn_cookies(const string &enable);

  XrlCmdError set_protocol(const string &protocol, const string &name, const uint32_t &rule_number);
  XrlCmdError delete_protocol(const string &name, const uint32_t &rule_number);

  XrlCmdError set_icmp_type(const string &type, const string &name, const uint32_t &rule_number);
  XrlCmdError delete_icmp_type(const string &name, const uint32_t &rule_number);

  XrlCmdError set_icmp_code(const string &icmp_code, const string &name, const uint32_t &rule_number);
  XrlCmdError delete_icmp_code(const string &name, const uint32_t &rule_number);


  XrlCmdError set_rule_state_established(const string &enable, const string &name, const uint32_t &rule_number);
  XrlCmdError set_rule_state_new(const string &enable, const string &name, const uint32_t &rule_number);
  XrlCmdError set_rule_state_related(const string &enable, const string &name, const uint32_t &rule_number);
  XrlCmdError set_rule_state_invalid(const string &enable, const string &name, const uint32_t &rule_number);

  XrlCmdError set_rule_action(const string &action, const string &name, const uint32_t &rule_number);

  XrlCmdError set_rule_log(const string &log, const string &name, const uint32_t &rule_number);

  XrlCmdError set_rate_limit(const uint32_t &limit, const string &name, const uint32_t &rule_number);
  XrlCmdError delete_rate_limit(const string &name, const uint32_t &rule_number);


  XrlCmdError set_rate_interval(const string &interval, const string &name, const uint32_t &rule_number);
  XrlCmdError delete_rate_interval(const string &name, const uint32_t &rule_number);

  XrlCmdError set_rate_limit_burst(const uint32_t &limit_burst, const string &name, const uint32_t &rule_number);
  XrlCmdError delete_rate_limit_burst(const string &name, const uint32_t &rule_number);

  XrlCmdError set_source_address(const IPv4 &address, const string &name, const uint32_t &rule_number);
  XrlCmdError delete_source_address(const string &name, const uint32_t &rule_number);

  XrlCmdError set_source_network(const IPv4Net &network, const string &name, const uint32_t &rule_number);
  XrlCmdError delete_source_network(const string &name, const uint32_t &rule_number);

  XrlCmdError set_source_range(const IPv4 &start, const IPv4 &stop, const string &name, const uint32_t &rule_number);
  XrlCmdError delete_source_range(const string &name, const uint32_t &rule_number);

  XrlCmdError set_source_port_number(const uint32_t &port_number, const string &name, const uint32_t &rule_number);
  XrlCmdError delete_source_port_number(const string &name, const uint32_t &rule_number);

  XrlCmdError set_source_port_name(const string &port_name, const string &name, const uint32_t &rule_number);
  XrlCmdError delete_source_port_name(const string &name, const uint32_t &rule_name);

  XrlCmdError set_source_port_range(const uint32_t &start, const uint32_t &stop, const string &name, const uint32_t &rule_number);
  XrlCmdError delete_source_port_range(const string &name, const uint32_t &rule_name);

  XrlCmdError set_destination_address(const IPv4 &address, const string &name, const uint32_t &rule_number);
  XrlCmdError delete_destination_address(const string &name, const uint32_t &rule_number);

  XrlCmdError set_destination_network(const IPv4Net &network, const string &name, const uint32_t &rule_number);
  XrlCmdError delete_destination_network(const string &name, const uint32_t &rule_number);

  XrlCmdError set_destination_range(const IPv4 &start, const IPv4 &stop, const string &name, const uint32_t &rule_number);
  XrlCmdError delete_destination_range(const string &name, const uint32_t &rule_number);

  XrlCmdError set_destination_port_number(const uint32_t &port_number, const string &name, const uint32_t &rule_number);
  XrlCmdError delete_destination_port_number(const string &name, const uint32_t &rule_number);

  XrlCmdError set_destination_port_name(const string &port_name, const string &name, const uint32_t &rule_number);
  XrlCmdError delete_destination_port_name(const string &name, const uint32_t &rule_name);

  XrlCmdError set_destination_port_range(const uint32_t &start, const uint32_t &stop, const string &name, const uint32_t &rule_number);
  XrlCmdError delete_destination_port_range(const string &name, const uint32_t &rule_name);

  XrlCmdError
  retrieve_rules(const string &name, XrlAtomList &rules);

private:
  XrlCmdError
  retrieve_rule_set(const string &name, FWChain::FirewallColl coll, XrlAtomList &rules);

private: //members
  /*  bool get_rule(const string &name, const uint32_t &rule_number, FirewallRuleIter &rule_iter);*/
  bool
  get_filter(const string &name, FirewallIter &iter);

private: //variables
  FirewallColl _firewall_coll;

  bool _log_martians;
  bool _send_redirects;
  bool _receive_redirects;
  bool _ip_src_route;
  bool _broadcast_ping;
  bool _syn_cookies;

};

#endif //__RL_FIREWALL_RL_FIREWALL_NODE_HH__
