<?xml version="1.0"?>
<!DOCTYPE stylesheet [
<!ENTITY newln "&#10;">
]>

<!-- /*
      *  Copyright 2006, Vyatta, Inc.
      *
      *  GNU General Public License
      *
      *  This program is free software; you can redistribute it and/or modify
      *  it under the terms of the GNU General Public License, version 2,
      *  as published by the Free Software Foundation.
      *
      *  This program is distributed in the hope that it will be useful,
      *  but WITHOUT ANY WARRANTY; without even the implied warranty of
      *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
      *  GNU General Public License for more details.
      *
      *  You should have received a copy of the GNU General Public License
      *  along with this program; if not, write to the Free Software
      *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
      *  02110-1301 USA
      *
      * Module: show_bgp_peers.xsl  
      *
      * Author: Mike Horn
      * Date: 2006
      *
      */ -->

<!--XSL Template for formatting the "show bgp peers" command-->

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<xsl:variable name="pad5" select="'     '"/>
<xsl:variable name="pad5_len" select="string-length($pad5)"/>
<xsl:variable name="pad7" select="'       '"/>
<xsl:variable name="pad7_len" select="string-length($pad7)"/>
<xsl:variable name="pad8" select="'        '"/>
<xsl:variable name="pad8_len" select="string-length($pad8)"/>
<xsl:variable name="pad11" select="'           '"/>
<xsl:variable name="pad11_len" select="string-length($pad11)"/>
<xsl:variable name="pad17" select="'                 '"/>
<xsl:variable name="pad17_len" select="string-length($pad17)"/>

<xsl:template match="opcommand">

<xsl:text>&newln;</xsl:text>
<xsl:text>&newln;</xsl:text>
<xsl:text>Peer IP          AS     State    Ver  Msg Rx     Msg Tx  Update Rx  Update Tx</xsl:text>
<xsl:text>&newln;</xsl:text>
<xsl:text>-------          --     -----    ---  ------     ------  ---------  ---------</xsl:text>
<xsl:text>&newln;</xsl:text>

<xsl:for-each select="format/row">

  <xsl:value-of select="peer_ip"/>
  <xsl:value-of select="substring($pad17,1,$pad17_len - string-length(peer_ip))"/>
  
  <xsl:value-of select="peer_as"/>
  <xsl:value-of select="substring($pad7,1,$pad7_len - string-length(peer_as))"/>

  <xsl:choose>
    <xsl:when test="peer_state='ESTABLISHED'">
      <xsl:text>ESTAB    </xsl:text>
    </xsl:when>
    <xsl:when test="peer_state='ACTIVE'">
      <xsl:text>ACTIVE   </xsl:text>
    </xsl:when>
    <xsl:when test="peer_state='IDLE'">
      <xsl:text>IDLE     </xsl:text>
    </xsl:when>
    <xsl:when test="peer_state='START'">
      <xsl:text>START    </xsl:text>
    </xsl:when> 
    <xsl:when test="peer_state='CONNECT'">
      <xsl:text>CONNECT    </xsl:text>
    </xsl:when> 
  </xsl:choose>

  <xsl:value-of select="neg_bgp"/>
  <xsl:value-of select="substring($pad5,1,$pad5_len - string-length(neg_bgp))"/>
 
  <xsl:value-of select="msg_rec"/>
  <xsl:value-of select="substring($pad11,1,$pad11_len - string-length(msg_rec))"/>

  <xsl:value-of select="msg_sent"/>
  <xsl:value-of select="substring($pad8,1,$pad8_len - string-length(msg_sent))"/>

  <xsl:value-of select="up_rec"/>
  <xsl:value-of select="substring($pad11,1,$pad11_len - string-length(up_rec))"/>

  <xsl:value-of select="up_sent"/>

  <xsl:text>&newln;</xsl:text>

</xsl:for-each> 
</xsl:template>

</xsl:stylesheet>
