<?xml version="1.0"?>
<!DOCTYPE stylesheet [
<!ENTITY newln "&#10;">
]>

<!-- /*
      *  Copyright 2006, Vyatta, Inc.
      *
      *  GNU General Public License
      *
      *  This program is free software; you can redistribute it and/or modify
      *  it under the terms of the GNU General Public License, version 2,
      *  as published by the Free Software Foundation.
      *
      *  This program is distributed in the hope that it will be useful,
      *  but WITHOUT ANY WARRANTY; without even the implied warranty of
      *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
      *  GNU General Public License for more details.
      *
      *  You should have received a copy of the GNU General Public License
      *  along with this program; if not, write to the Free Software
      *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
      *  02110-1301 USA
      *
      * Module: show_arp.xsl 
      *
      * Author: Mike Horn
      * Date: 2006
      *
      */ -->

<!--XSL template for formatting the "show arp" command output-->

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<xsl:variable name="pad16" select="'               '"/>
<xsl:variable name="pad16_len" select="string-length($pad16)"/>
<xsl:variable name="pad23" select="'                      '"/>
<xsl:variable name="pad23_len" select="string-length($pad23)"/>
<xsl:variable name="pad8" select="'        '"/>
<xsl:variable name="pad8_len" select="string-length($pad8)"/>

<xsl:template match="/">
<xsl:text>&newln;</xsl:text>
<xsl:text>MAC Address           IP Address     State   Interface</xsl:text>
<xsl:text>&newln;</xsl:text>
<xsl:text>-----------           ----------     -----   ---------</xsl:text>
<xsl:text>&newln;</xsl:text>
<xsl:for-each select="opcommand/format/row">
  <xsl:value-of select="mac"/>
  <xsl:value-of select="substring($pad23,1,$pad23_len - string-length(mac))"/>
  <xsl:value-of select="ip"/>
  <xsl:value-of select="substring($pad16,1,$pad16_len - string-length(ip))"/>
  <xsl:value-of select="flag"/>
  <xsl:value-of select="substring($pad8,1,$pad8_len - string-length(flag))"/>
  <xsl:value-of select="iface"/>
  <xsl:text>&newln;</xsl:text>
</xsl:for-each>
</xsl:template>

</xsl:stylesheet>
