/*
 * Module: rl_command.cc
 *
 * **** License ****
 * Version: VPL 1.0
 *
 * The contents of this file are subject to the Vyatta Public License
 * Version 1.0 ("License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.vyatta.com/vpl
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
 * the License for the specific language governing rights and limitations
 * under the License.
 *
 * This code was originally developed by Vyatta, Inc.
 * Portions created by Vyatta are Copyright (C) 2005, 2006, 2007 Vyatta, Inc.
 * All Rights Reserved.
 *
 * Author: Michael Larson
 * Date: 2005
 * Description:
 *
 * **** End License ****
 *
 */

#include <stdio.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <stdio.h>
#include <errno.h>
#include <syslog.h>
#include <string>

#include "rl_command.hh"

using namespace std;

/**
 *
 **/
bool
rl_command::execute(const char *_cmd, bool debug, bool log)
{
	string cmd(_cmd);

	return execute(cmd, debug, log);
}

bool
rl_command::execute(const std::string &cmd, bool debug, bool log)
{
  if (cmd.empty() == false) {
    if (log) {
      syslog(LOG_DEBUG | LOG_USER , "********* rl_cmd::execute(): %s\n", cmd.c_str());
    }
    //	printf("********* rl_cmd::execute(): %s ********\n", cmd.c_str());
    if (debug == false) {
      FILE *f = popen(cmd.c_str(), "w");
      if (f) {
	if (pclose(f) != 0) {
	  syslog(LOG_DEBUG | LOG_USER , "********* rl_cmd::execute(): Error on closing command\n");
	  //	printf("rl_command failed to set command: %s", cmd.c_str());
	return false;
	}
      }
    }
  } 
  else {
    syslog(LOG_DEBUG | LOG_USER , "********* rl_cmd::execute(): command is empty\n");
  }
  return true;
}

/**
 *
 **/
rl_trace::rl_trace(const string &module) : _module(module)
{
  struct timeval time;
  gettimeofday(&time, NULL);
  syslog(LOG_DEBUG | LOG_USER, "rl_trace Entering %s. %d.%d\n", _module.c_str(),(int)time.tv_sec, (int)time.tv_usec);
}


/**
 *
 **/
rl_trace::~rl_trace()
{
  struct timeval time;
  gettimeofday(&time, NULL);
  syslog(LOG_DEBUG | LOG_USER, "rl_trace Leaving %s. %d.%d\n", _module.c_str(),(int)time.tv_sec, (int)time.tv_usec);
}

/**
 *
 **/
string
rl_utils::to_upper(const string &str)
{
  string tmp;
  string::const_iterator str_iter = str.begin();
  while (str_iter != str.end()) {
    tmp += toupper(*str_iter);
    ++str_iter;
  }
  return tmp;
}

/**
 *
 **/
bool
rl_utils::find_process(const std::string &proc_name, const std::string &process)
{
  if (process.length() > 512) {
    return false;
  }

  bool found = false;
  string grep_str("grep");

  string find_cmd("ps | grep '");
  find_cmd += process + "'";
  FILE *f = popen(find_cmd.c_str(), "r");
  if (f) {
    char buf[512];
    while(fgets(buf, 512, f) != NULL) { 
      //      cout << "comparing: " << server << " <to> " << buf << endl;
      if (string(buf).find(process) != string::npos) {
	//make sure that this isn't the grep string itself
	if (string(buf).find(grep_str) == string::npos &&
	    string(buf).find(proc_name) == string::npos) {
	  //	  cout << "MATCH! " << string(buf) << endl;
	  found = true;
	  break;
	}
      }
    }
    pclose(f);
  }
  return found;
}

/**
 * Reads the mount stdout for rw to determine if the boot source
 * is writable.
 **/
bool
rl_utils::is_boot_rw() 
{
  string match_one("rootimage");
  string match_two("rw");
  string cmd = "mount";
  FILE *f = popen(cmd.c_str(), "r");
  if (f) {
    char buf[1025];
    if (fgets(buf, 1024, f) != NULL) { //read first line only!
      if ((string(buf).find(match_one) != string::npos)
	  && (string(buf).find(match_two) != string::npos)) {
	pclose(f);
	return true;
      }
    }
    pclose(f);
  }
  return false;
}

/**
 *
 **/
unsigned long long
rl_utils::rdtsc()
{
  unsigned long long d;

  /*
   * Instruction is volatile because we don't want it to move
   * over an adjacent gettimeofday. That would ruin the timing
   * calibrations.
   */
  __asm__ __volatile__ ("rdtsc" : "=&A" (d));
  return d;

}
