/**
 * Module: main.cc
 *
 * Author: Michael Larson
 * Date: 2005
 */
#include <iostream>
#include <unistd.h>
#include <linux/unistd.h>
#include <string>

#include "config.h"
#include "rl_str_proc.hh"
#include "rl_command.hh"
#include "command_proc_base.hh"
#include "xsl_processor.hh"
#include "command_proc_mgr.hh"

using namespace std;

/*
 * Main entry point for the show command processor
 */

int main(int argc, char* argv[])
{
  bool debug = false;

#ifdef RL_NOT_TARGET
  CommandProcMgr cmd_proc_mgr("./rl_proc_cmd", debug);
#else
  CommandProcMgr cmd_proc_mgr(PKGLIBEXECDIR "/rl_proc_cmd", debug);
#endif

  if (argc < 2) {
    printf("usage:\nrl_cmd_proc [command] --debug\n");
    printf("available modules:\n");
    vector<string> coll = cmd_proc_mgr.get_available_modules();
    vector<string>::iterator iter = coll.begin();
    while (iter != coll.end()) {
      printf("  %s\n", iter->c_str());
      ++iter;
    }
    exit(0);
  }
  
  /* 
     Build out string request based on the number of argcs.
  */
  string request;
  for (int i = 1; i < argc; ++i) {
    if (strcmp(argv[i], "--debug") == 0) {
      debug = true;
    }
    else {
      request += string(argv[i]) + string(" ");
    }
  }
  
  string mod_name(argv[1]);
  
  if (debug) {
    cout << "request: " << request << endl;
  }
  
  //initialize the command processor
  CommandProcBase *proc = cmd_proc_mgr.init(mod_name);
  if (proc != NULL) {
    if (debug) {
      cout << "found command processor: " << request << ", " << mod_name << endl;
    }

    // process command and create xml output
    string reason;
    string xml_out = proc->process(request, debug, reason);
    if (debug) {
      cout << "output xml" << endl << xml_out << endl;
    }

    if (xml_out.empty() == true) {
      cout << reason << endl;
      exit(0);
    }

    bool catch_param_name = false;
    bool catch_param_val = false;
    string param_name;
    string param_val;
    list<pair<string,string> > listParams;
    for (int i = 1; i < argc; ++i) {
      if (strcmp(argv[i], "--pname") == 0) {
        catch_param_name = true;
        catch_param_val = false;
        param_name = "";
        param_val = "";
      } else if (strcmp(argv[i], "--pval") == 0) {
        catch_param_name = false;
        catch_param_val = true;
        param_val = "";
      } else {
        if (catch_param_name) {
          param_name = argv[i];
          catch_param_name = false;
	}
        if (catch_param_val) {
          param_val = argv[i];
          catch_param_val = false;
	}
      }
      if (param_name.length() > 0 && param_val.length() > 0) {
        listParams.push_back(pair<string,string>(param_name, param_val));
        param_name = "";
        param_val = "";
      }
    }

    XSLProcessor xsl_processor(debug);

    cout << xsl_processor.transform(xml_out, proc->xsl(), listParams) << endl;

  } else {
    if (debug) {
      cout << "did not find command processor: " << mod_name << endl;
    }
    //execute command without processing....
    //rl_command::execute(request); //this was for the command to live within xorp
  }

  exit(0);
}
