/**
 *    Module: command_proc_show_serial.hh
 *
 *    Author: Michael Larson
 *    Date: 2005
 *    Description:
 *
 *    This program is free software; you can redistribute it and/or modify 
 *    it under the terms of the GNU General Public License as published 
 *    by the Free Software Foundation; either version 2 of the License, 
 *    or (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be  useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 *    02110-1301 USA
 *
 *    Copyright 2006, Vyatta, Inc.
 */
#ifndef __COMMAND_PROC_SHOW_SERIAL_HH__
#define __COMMAND_PROC_SHOW_SERIAL_HH__

#include <string>
#include <command_proc_base.hh>

class CommandProcShowSerial : public CommandProcBase
{
public:
  CommandProcShowSerial();
  ~CommandProcShowSerial();

  /**
   *
   **/
  static std::string
  name() {return "showserialinterface";}

  /**
   *
   **/
  std::string
  process(const std::string &cmd, bool debug, std::string &reason);

  /**
   *
   **/ 
  bool
  is_valid() {return true;}

private:
  /**
   *
   **/
  void
  convert_to_xml_vif(const std::string &line, bool debug, std::string &extracted_vif);

  /**
   *
   **/
  void
  convert_to_xml_proc_state(const std::string &line, bool debug, std::string &iface_vif);

  /**
   *
   **/
  void 
  convert_to_xml_xm(const std::string &line, bool debug);

  /**
   *
   **/
  void 
  convert_to_xml_xru(const std::string &line, bool debug);

  /**
   *
   **/
  void 
  convert_to_xml_sc(const std::string &line, bool debug);

  /**
   *
   **/
  void 
  convert_to_xml_Tread(const std::string &line, bool debug);

  /**
   *
   **/
  void 
  convert_to_xml_Ta(const std::string &line, bool debug);

  /**
   *
   **/
  void 
  convert_to_xml_sg(const std::string &line, bool debug);

  /**
   *
   **/
  void 
  convert_to_xml_sp(const std::string &line, bool debug);

  /**
   *
   **/
  void 
  convert_to_xml_sicp(const std::string &line, bool debug);

  /**
   *
   **/
  void 
  convert_to_xml_xu(const std::string &line, bool debug);

  /**
   *
   **/
  void 
  convert_to_xml_ca(const std::string &line, bool debug);

  /**
   *
   **/
  void 
  convert_to_xml_xn(const std::string &line, bool debug);

  /**
   *
   **/
  void 
  convert_to_xml_ci(const std::string &line, bool debug);

  /**
   *
   **/
  void 
  convert_to_xml_cg(const std::string &line, bool debug);

  /**
   *
   **/
  void 
  convert_to_xml_slcp(const std::string &line, bool debug);

  /**
   *
   **/
  void 
  convert_to_xml_crc(const std::string &line, bool debug);


  /**
   *
   **/
  void 
  convert_to_xml_so(const std::string &line, bool debug);


  /**
   *
   **/
  void 
  convert_to_xml_sd(const std::string &line, bool debug);


  /**
   *
   **/
  void 
  convert_to_xml_ss(const std::string &line, bool debug);


  /**
   *
   **/
  void 
  convert_to_xml_xl(const std::string &line, bool debug);


  /**
   *
   **/
  void 
  convert_to_xml_xcv(const std::string &line, bool debug);

  /**
   *
   **/
  void 
  convert_to_xml_se(const std::string &line, bool debug);

  /**
   *
   **/
  void 
  convert_to_xml_cl(const std::string &line, bool debug);

  /**
   *
   **/
  void 
  convert_to_xml_clr(const std::string &line, bool debug);

  /**
   *
   **/
  void
  process_dlcis(const std::string &iface, const std::string &vif_iface, const std::string &cl_vif_arg, bool debug);

protected:
  std::string _xml_out;
};

#endif //__COMMAND_PROC_SHOW_SERIAL_H__
