/**
 *    Module: command_proc_show_ntp.cc
 *
 *    Author: Michael Larson
 *    Date: 2006
 *    Description:
 *
 *    This program is free software; you can redistribute it and/or modify 
 *    it under the terms of the GNU General Public License as published 
 *    by the Free Software Foundation; either version 2 of the License, 
 *    or (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be  useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 *    02110-1301 USA
 *
 *    Copyright 2006, Vyatta, Inc.
 */
#include <iostream>
#include <list>
#include <string>
#include <time.h>
#include <stdlib.h>

#include "config.h"
#include "rl_str_proc.hh"
#include <command_proc_show_ntp.hh>

using namespace std;

/**
 *
 **/
CommandProcShowNTP::CommandProcShowNTP() : CommandProcBase()
{

}

/**
 *
 **/
CommandProcShowNTP::~CommandProcShowNTP()
{


}

/**
 *
 **/
std::string
CommandProcShowNTP::process(const string &cmd, bool debug, string &reason)
{
  UNUSED(reason);
  //first thing, execute this command;
  if (cmd.empty() == false) {
    char buf[2048];
    
    vector<string> in_coll;
    StrProc proc_str(cmd, " ");
    in_coll = proc_str.get();
    if (in_coll.size() < 2) {
      return _xml_out;
    }
    
    _xsl = XSLDIR "/" + in_coll[1];
    
    _xml_out = "<opcommand name='ntp'><format type='row'>";
    
    string ntp_cmd = "ntpq -p -c associations";
    
    bool mode = false, status = false;
    FILE *f = popen(ntp_cmd.c_str(), "r");
    if (f) {
      while(fgets(buf, 2047, f) != NULL) { 
	string line(buf);
	if (line.find("====") != string::npos && mode == false){
	  mode = true;
	  continue;
	}
	else if (line.find("====") != string::npos && mode == true) {
	  status = true;
	  continue;
	}
	_xml_out += "<row>";
	convert_to_xml(line, debug, status);
	_xml_out += "</row>";
      } 
      if (pclose(f) != 0) {
	return string("");
      }
    }
    _xml_out += "</format></opcommand>";
  }
  return _xml_out;
}


/**
 *
/lib # ntpq -p -c associations
     remote           refid      st t when poll reach   delay   offset  jitter
==============================================================================
 1.1.1.1         .INIT.          16 u    -  256    0    0.000    0.000 4000.00
ind assID status  conf reach auth condition  last_event cnt
===========================================================
  1  5684  8000   yes   yes  none    reject
 **/
void 
CommandProcShowNTP::convert_to_xml(const string &line, bool debug, bool status)
{
  debug = false;
  
  StrProc proc_str(line, " ");
  
  if (line.find("====") != string::npos ||
      line.find("remote") != string::npos || 
      line.find("assID") != string::npos) {
    return;
  }
  
  StrProc str_proc(line, " ");
      
  if (status == false) {
    _xml_out += "<remote>" + str_proc.get(0) + "</remote>";
    _xml_out += "<refid>" + str_proc.get(1) + "</refid>";
    _xml_out += "<st>" + str_proc.get(2) + "</st>";
    _xml_out += "<t>" + str_proc.get(3) + "</t>";
    _xml_out += "<when>" + str_proc.get(4) + "</when>";
    _xml_out += "<poll>" + str_proc.get(5) + "</poll>";
    _xml_out += "<reach>" + str_proc.get(6) + "</reach>";
    _xml_out += "<delay>" + str_proc.get(7) + "</delay>";
    _xml_out += "<offset>" + str_proc.get(8) + "</offset>";
    _xml_out += "<jitter>" + str_proc.get(9) + "</jitter>";
  }
  else {
    _xml_out += "<ind>" + str_proc.get(0) + "</ind>";
    _xml_out += "<assID>" + str_proc.get(1) + "</assID>";
    _xml_out += "<status>" + str_proc.get(2) + "</status>";
    _xml_out += "<conf>" + str_proc.get(3) + "</conf>";
    _xml_out += "<reach>" + str_proc.get(4) + "</reach>";
    _xml_out += "<auth>" + str_proc.get(5) + "</auth>";
    _xml_out += "<condition>" + str_proc.get(6) + "</condition>";
    _xml_out += "<last_event>" + str_proc.get(7) + "</last_event>";
    _xml_out += "<cnt>" + str_proc.get(8) + "</cnt>";
  }

  return;
}

