/**
 * Module: command_proc_show_nat.cc
 *
 * Author: Michael Larson
 * Date: 2005
 */
#include <iostream>
#include <list>
#include <string>
#include <time.h>
#include <stdlib.h>

#include "config.h"
#include "rl_str_proc.hh"
#include <command_proc_show_nat.hh>

using namespace std;

/**
 *
 **/
CommandProcShowNat::CommandProcShowNat() : CommandProcBase()
{

}

/**
 *
 **/
CommandProcShowNat::~CommandProcShowNat()
{


}

/**
 *
 todo: add byte/packet ct to the print_nat_rules command (inside rl_service module--or maybe best to do here???
 add names to the dispatched command as well...

 **/
std::string
CommandProcShowNat::process(const string &cmd, bool debug, string &reason)
{
  UNUSED(reason);

  //first thing, execute this command;
  if (cmd.empty() == false) {
    StrProc str_proc(cmd, " ");

    if (str_proc.size() < 3) {
      return _xml_out;
    }

    _xsl = XSLDIR "/" + str_proc.get(2);

    string exe_cmd = PKGLIBEXECDIR "/print_nat_rules ";

    exe_cmd += str_proc.get(1);

    FILE *f = popen(exe_cmd.c_str(), "r");
    if (f) {
      char buf[2048];
      _xml_out = "<opcommand name='natrules'><format type='row'>";
      
      while(fgets(buf, 2048, f) != NULL) { 
	string line(buf);
	convert_to_xml(line, debug);
      } 
      if (pclose(f) != 0) {
	return string("");
      }
      _xml_out += "</format></opcommand>";
    }
  } 
  else {
  }
  return _xml_out;
}

/**
 *
 **/
void 
CommandProcShowNat::convert_to_xml(const string &line, bool debug)
{
  StrProc str_proc(line, "%3B");

  vector<string> coll = str_proc.get();
  
  _xml_out += "<row>";

  vector<string>::iterator iter = coll.begin();
  while (iter != coll.end()) {
    if (debug) {
      cout << "convert_to_xml(), processing: " << *iter << endl;
    }
    
    uint32_t loc;
    if ((loc = iter->find(":txt=")) != string::npos) {
      *iter = iter->substr(loc+5, iter->length() - loc-5);
    }

    uint32_t pos = iter->find("%3D");
    if (pos != string::npos) {
      string key = iter->substr(0, pos);
      string value = iter->substr(pos+3, iter->length() - pos-3);

      _xml_out += "<" + key + ">" + value + "</"+ key + ">";
    }
    ++iter;
  }

  _xml_out += "</row>";
  return;
  debug = true; //just to avoid the compiler warning.
}

