/**
 *  Copyright 2006, Vyatta, Inc.
 *
 *  GNU General Public License
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License, version 2, 
 *  as published by the Free Software Foundation.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 *  02110-1301 USA
 *
 *    Module: command_proc_show_firewall_rules.cc
 *
 *    Author: Michael Larson
 *    Date: 2005
 *    Description:
 *
 */
#include <iostream>
#include <list>
#include <string>
#include <time.h>
#include <stdlib.h>

#include "config.h"
#include "rl_str_proc.hh"
#include <command_proc_show_firewall_rules.hh>

using namespace std;

/**
 *
 **/
CommandProcShowFirewallRules::CommandProcShowFirewallRules() : CommandProcBase()
{

}

/**
 *
 **/
CommandProcShowFirewallRules::~CommandProcShowFirewallRules()
{


}

/**
 *
 **/
std::string
CommandProcShowFirewallRules::process(const string &cmd, bool debug, string &reason)
{
  UNUSED(reason);

    StrProc proc_str(cmd, " ");
    string rule_no;

    if (proc_str.size() < 3) {
      return _xml_out;
    }
  
    string exe_cmd = "sudo " PKGLIBEXECDIR "/print_firewall_rules " + proc_str.get(1);

    //    string rule_scope = proc_str.get(2);

    if (proc_str.get(2) == "noresolve") {
      exe_cmd += " -n";

      if (proc_str.size() == 5) {
	rule_no = proc_str.get(3);
	_xsl = XSLDIR "/" + proc_str.get(4);
      } 
      else {
	_xsl = XSLDIR "/" + proc_str.get(3);
      }
    }
    else {
      if (proc_str.size() == 4) {
	rule_no = proc_str.get(2);
	_xsl = XSLDIR "/" + proc_str.get(3);
      } 
      else {
	_xsl = XSLDIR "/" + proc_str.get(2);
      }
    }

    if (debug) {
      cout << "command: " << exe_cmd << endl;
    }

  //first thing, execute this command;
  if (exe_cmd.empty() == false) {
    //    syslog(LOG_DEBUG | LOG_USER , "********* rl_cmd::execute(): %s\n", cmd.c_str());
    FILE *f = popen(exe_cmd.c_str(), "r");
    if (f) {
      char buf[2048];
      int ct = 0;
      while(fgets(buf, 2048, f) != NULL) { 
	//	printf("'line(%d):  %s'\n", ct, buf);
	string line(buf);
	convert_to_xml(line, ct, rule_no, debug);
	++ct;
      } 
      if (ct != 0) {
	complete_xml();
      }
      if (pclose(f) != 0) {

	//	syslog(LOG_DEBUG | LOG_USER , "********* rl_cmd::execute(): Error on closing command\n");
	return string("");
      }
    }
  } 
  else {
    //    syslog(LOG_DEBUG | LOG_USER , "********* rl_cmd::execute(): command is empty\n");
  }
  string foo = cmd;
  return _xml_out;
}

/**
 *
 **/
void 
CommandProcShowFirewallRules::convert_to_xml(const string &line, int ct, const string &rule_no, bool debug)
{
  StrProc str_proc(line, "%3B");

  vector<string> coll = str_proc.get();
  
  if (debug) {
    printf("CommandProcShowFirewallRules::convert_to_xml: %s\n", line.c_str());
  }

  if (ct == 0) {
    _xml_out = "<opcommand name='firewallrules'><format type='row'>";
  }

  vector<string>::iterator iter = coll.begin();
  while (iter != coll.end()) {
    if (debug) {
      cout << "convert_to_xml(), processing: " << *iter << endl;
    }
    uint32_t loc;
    if ((loc = iter->find(":txt=")) != string::npos) {
      *iter = iter->substr(loc+5, iter->length() - loc-5);
    }

    uint32_t pos = iter->find("%3D");
    if (pos != string::npos) {
      string key = iter->substr(0, pos);
      string value = iter->substr(pos+3, iter->length() - pos-3);
      
      if (key.find("rule_number") != string::npos) {
	if (rule_no.empty() == false && rule_no != value) {
	  //if rule is specified and doesn't match bail...
	  return;
	}
	_xml_out += "<row>";
      }
      _xml_out += "<" + key + ">" + value + "</" + key + ">";
      if (key.find("bytes") != string::npos) {
	_xml_out += "</row>";
      }

    }
    ++iter;
  }

  return;
}

/**
 *
 **/
void
CommandProcShowFirewallRules::complete_xml()
{
  if (_xml_out.empty() == false) {
    _xml_out += "</format></opcommand>";
  }
}

