/**
 *    Module: command_proc_show_bgp_peers.cc
 *
 *    Author: Michael Larson
 *    Date: 2006
 *    Description:
 *
 *    This program is free software; you can redistribute it and/or modify 
 *    it under the terms of the GNU General Public License as published 
 *    by the Free Software Foundation; either version 2 of the License, 
 *    or (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be  useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 *    02110-1301 USA
 *
 *    Copyright 2006, Vyatta, Inc.
 */
#include <iostream>
#include <list>
#include <map>
#include <string>
#include <time.h>
#include <stdlib.h>
#include "config.h"
#include "rl_str_proc.hh"
#include <command_proc_show_bgp_peers.hh>

using namespace std;

/**
 *
 **/
CommandProcShowBGPPeers::CommandProcShowBGPPeers() : CommandProcBase()
{

}

/**
 *
 **/
CommandProcShowBGPPeers::~CommandProcShowBGPPeers()
{


}

/**
 *
 **/
std::string
CommandProcShowBGPPeers::process(const string &cmd, bool debug, string &reason)
{
  UNUSED(reason);

  //first thing, execute this command;
  if (cmd.empty() == false) {
    char buf[2048];
    string exe_cmd;

    vector<string> in_coll;
    StrProc proc_str(cmd, " ");
    in_coll = proc_str.get();
    if (in_coll.size() < 1) {
      return string("");
    }

    _xsl = XSLDIR "/" + in_coll[1];

    _xml_out = "<opcommand name='bgp_peers'><format type='row'>";

    exe_cmd = PKGLIBEXECDIR "/xorpsh_print_peers show bgp peers detail";
    FILE *f = popen(exe_cmd.c_str(), "r");
    if (f) {
      while(fgets(buf, 2047, f) != NULL) { 
	string line(buf);
	convert(line, debug);
      } 
      if (pclose(f) != 0) {
	return string("");
      }
    }
    _xml_out += "</format></opcommand>";
  }
  return _xml_out;
}

/*
Peer 1: local 10.1.0.55/179 remote 10.1.0.56/179
  Peer ID: 10.1.0.56
  Peer State: ESTABLISHED
  Admin State: START
  Negotiated BGP Version: 4
  Peer AS Number: 65505
  Updates Received: 1,  Updates Sent: 0
  Messages Received: 56,  Messages Sent: 55
  Time since last received update: 1402 seconds
  Number of transitions to ESTABLISHED: 1
  Time since last entering ESTABLISHED state: 1402 seconds
  Retry Interval: 120 seconds
  Hold Time: 90 seconds,  Keep Alive Time: 30 seconds
  Configured Hold Time: 90 seconds,  Configured Keep Alive Time: 30 seconds
  Minimum AS Origination Interval: 0 seconds
  Minimum Route Advertisement Interval: 0 seconds
*/
void
CommandProcShowBGPPeers::convert(const string &line, bool debug)
{
  if (debug) {
    cout << "processing: convert: " << line << endl;
  }
  StrProc proc_str(line, " ");
  vector<string> coll = proc_str.get();

  if (line.find("remote") != string::npos) {
    string tmp = proc_str.get(5);
    uint32_t pos = tmp.find("/");
    string peer_ip = tmp.substr(0, pos);
    _xml_out += "<row><peer_ip>" + peer_ip + "</peer_ip>";
  }
  else if (line.find("Peer ID") != string::npos) {
    _xml_out += "<peer_id>" + proc_str.get(2) + "</peer_id>";
  }
  else if (line.find("Peer State") != string::npos) {
    _xml_out += "<peer_state>" + proc_str.get(2) + "</peer_state>";
  }
  else if (line.find("Admin State") != string::npos) {
    _xml_out += "<admin_state>" + proc_str.get(2) + "</admin_state>";
  }
  else if (line.find("Negotiated BGP") != string::npos) {
    _xml_out += "<neg_bgp>" + proc_str.get(3) + "</neg_bgp>";
  }
  else if (line.find("Peer AS") != string::npos) {
    _xml_out += "<peer_as>" + proc_str.get(3) + "</peer_as>";
  }
  else if (line.find("Updates Received") != string::npos) {
    _xml_out += "<up_rec>" + proc_str.get(2).substr(0, proc_str.get(2).length()-1) + "</up_rec>";
    _xml_out += "<up_sent>" + proc_str.get(5) + "</up_sent>";
  }
  else if (line.find("Messages Received") != string::npos) {
    _xml_out += "<msg_rec>" + proc_str.get(2).substr(0, proc_str.get(2).length()-1) + "</msg_rec>";
    _xml_out += "<msg_sent>" + proc_str.get(5) + "</msg_sent>";
  }
  else if (line.find("Time since last rec") != string::npos) {
    _xml_out += "<time_lst_rec>" + proc_str.get(5) + "</time_lst_rec>";
  }
  else if (line.find("Number of transitions") != string::npos) {
    _xml_out += "<num_trans>" + proc_str.get(5) + "</num_trans>";
  }
  else if (line.find("Time since last ent") != string::npos) {
    _xml_out += "<time_lst_ent>" + proc_str.get(6) + "</time_lst_ent>";
  }
  else if (line.find("Retry Interval") != string::npos) {
    _xml_out += "<retry_int>" + proc_str.get(2) + "</retry_int>";
  }
  else if (line.find(", Keep Alive Time:") != string::npos) {
    _xml_out += "<hold_time>" + proc_str.get(2) + "</hold_time>";
    _xml_out += "<keep_alive_time>" + proc_str.get(7) + "</keep_alive_time>";
  }
  else if (line.find("Configured Hold Time:") != string::npos) {
    _xml_out += "<cfg_hold_time>" + proc_str.get(3) + "</cfg_hold_time>";
    _xml_out += "<cfg_keep_alive_time>" + proc_str.get(9) + "</cfg_keep_alive_time>";
  }
  else if (line.find("Minimum AS") != string::npos) {
    _xml_out += "<min_as_orig>" + proc_str.get(4) + "</min_as_orig>";
  }
  else if (line.find("Minimum Route Adv") != string::npos) {
    _xml_out += "<min_rt_adv>" + proc_str.get(4) + "</min_rt_adv></row>";
  }
  return;
}

