/**
 *    Module: command_proc_show_arp.cc
 *
 *    Author: Michael Larson
 *    Date: 2005
 *    Description:
 *
 *    This program is free software; you can redistribute it and/or modify 
 *    it under the terms of the GNU General Public License as published 
 *    by the Free Software Foundation; either version 2 of the License, 
 *    or (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be  useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 *    02110-1301 USA
 *
 *    Copyright 2006, Vyatta, Inc.
 */
#include <iostream>
#include <list>
#include <string>
#include "config.h"
#include "rl_str_proc.hh"
#include <command_proc_show_arp.hh>

using namespace std;

/*
Example of an arp command:

rl(conf)> run show arp
IP address       HW type     Flags       HW address            Mask     Device
192.168.0.3      0x1         0x2         00:30:1B:B2:ED:CD     *        eth0
192.168.0.1      0x1         0x2         00:09:5B:50:04:E6     *        eth0


<opcommand name="arp">
<format type = column>
<header>
<value>IP address</value>
<value>HW type</value>
<value>Flags</value>
<value>HW address</value>
<value>Mask</value>
<value>Device</value>
</header>
<row count = 1>
<value>192.168.0.3</value>
<value>0x1</value>
<value>0x2</value>
<value>00:30:1B:ED:CD</value>
<value>*</value>
<value>eth0</value>
</row>
<row count = 2>
<value>192.168.0.1</value>
<value>0x1</value>
<value>0x2</value>
<value>00:09:5B:50:04:36</value>
<value>*</value>
<value>eth0</value>
</row>
</format>
</opcommand>
*/

/**
 *
 **/
CommandProcShowArp::CommandProcShowArp() : CommandProcBase()
{

}

/**
 *
 **/
CommandProcShowArp::~CommandProcShowArp()
{


}

/**
 *
 **/
std::string
CommandProcShowArp::process(const string &cmd, bool debug, string &reason)
{
  UNUSED(reason);
  StrProc proc_str(cmd, " ");

  _xsl = XSLDIR "/" + proc_str.get(1);

  //first thing, execute this command;
  if (cmd.empty() == false) {
    FILE *f = popen("cat /proc/net/arp", "r");
    if (f) {
      char buf[2048];
      int ct = 0;
      
      while(fgets(buf, 2047, f) != NULL) { 
	string line(buf);
	convert_to_xml(line, ct);
	++ct;
      } 
      if (ct != 0) {
	complete_xml();
      }
      if (pclose(f) != 0) {
	return string("");
      }
    }
  } 
  else {
  }

  string foo = cmd;
  debug = true;
  return _xml_out;
}

/**
 *
 **/
void 
CommandProcShowArp::convert_to_xml(const string &line, int ct)
{
  list<string> segments;
  string remainder = line;

  StrProc str_proc(line, " ");

  if (ct == 0) {
    _xml_out = "<opcommand name='arp'><format type='column'><header>";
  }
  else {
    char buf[20];
    sprintf(buf, "%d", ct);
    _xml_out += "<row count = '" + string(buf) + "'>";
  }

  _xml_out += "<ip>" + str_proc.get(0) + "</ip>";

  _xml_out += "<hwtype>";
  string hwtype = str_proc.get(1);
  if (hwtype == "0x0") { _xml_out += "none"; }
  else if (hwtype == "0x1") { _xml_out += "incom"; }
  else if (hwtype == "0x2") { _xml_out += "reach"; }
  else if (hwtype == "0x4") { _xml_out += "stale"; }
  else if (hwtype == "0x8") { _xml_out += "delay"; }
  else if (hwtype == "0x10") { _xml_out += "probe"; }
  else if (hwtype == "0x20") { _xml_out += "fail"; }
  else if (hwtype == "0x40") { _xml_out += "noARP"; }
  else if (hwtype == "0x80") { _xml_out += "perm"; }
  _xml_out += "</hwtype>";

  _xml_out += "<flag>";
  string flag = str_proc.get(2);
  if (flag == "0x0") { _xml_out += "none"; }
  else if (flag == "0x1") { _xml_out += "incom"; }
  else if (flag == "0x2") { _xml_out += "reach"; }
  else if (flag == "0x4") { _xml_out += "stale"; }
  else if (flag == "0x8") { _xml_out += "delay"; }
  else if (flag == "0x10") { _xml_out += "probe"; }
  else if (flag == "0x20") { _xml_out += "fail"; }
  else if (flag == "0x40") { _xml_out += "noARP"; }
  else if (flag == "0x80") { _xml_out += "perm"; }
  _xml_out += "</flag>";

  _xml_out += "<mac>" + str_proc.get(3) + "</mac>";
  _xml_out += "<mask>" + str_proc.get(4) + "</mask>";
  _xml_out += "<iface>" + str_proc.get(5) + "</iface>";

  if (ct == 0) {
    _xml_out += "</header>";
  }
  else {
    _xml_out += "</row>";
  }

  return;
}

/**
 *
 **/
void
CommandProcShowArp::complete_xml()
{
  if (_xml_out.empty() == false) {
    _xml_out += "</format></opcommand>";
  }
}
