/**
 *    Module: command_proc_mgr.hh
 *
 *    Author: Michael Larson
 *    Date: 2005
 *    Description:
 *
 *    This program is free software; you can redistribute it and/or modify 
 *    it under the terms of the GNU General Public License as published 
 *    by the Free Software Foundation; either version 2 of the License, 
 *    or (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be  useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 *    02110-1301 USA
 *
 *    Copyright 2006, Vyatta, Inc.
 */
#ifndef __COMMAND_PROC_MGR_HH__
#define __COMMAND_PROC_MGR_HH__

#include <string>
#include <vector>
#include <map>
#include <command_proc_base.hh>

class CommandProcMgr
{
public:
  CommandProcMgr(const std::string &path, bool debug);
  ~CommandProcMgr();

  /*
   * Initializes set of exe's.
   */
  CommandProcBase* init(const std::string &mod_name);

  /*
   * Provides collection of available modules
   */
  std::vector<std::string> get_available_modules();

private:
  std::string _cmd_path;
  bool _debug;
};



#endif //__COMMAND_PROC_HH__

