/**
 *    Module: command_proc_mgr.cc
 *
 *    Author: Michael Larson
 *    Date: 2005
 *    Description:
 *
 *    This program is free software; you can redistribute it and/or modify 
 *    it under the terms of the GNU General Public License as published 
 *    by the Free Software Foundation; either version 2 of the License, 
 *    or (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be  useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 *    02110-1301 USA
 *
 *    Copyright 2006, Vyatta, Inc.
 */

#include <stdio.h>
#include <errno.h>
#include <dirent.h>
#include <string>
#include <iostream>
#include <iomanip>
#include <fstream>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <vector>
#include <map>
#include "rl_str_proc.hh"
#include "command_proc_base.hh"
#include "command_proc_show_arp.hh"
#include "command_proc_show_leases.hh"
#include "command_proc_show_nat.hh"
#include "command_proc_show_ntp.hh"
#include "command_proc_show_firewall_rules.hh"
#include "command_proc_show_serial.hh"
#include "command_proc_show_bgp_peers.hh"
#include "command_proc_show_dhcp_stat.hh"
#include "command_proc_show_vpn.hh"
#include "command_proc_mgr.hh"

using namespace std;

/**
 *
 **/
CommandProcMgr::CommandProcMgr(const string &path, bool debug) : 
  _cmd_path(path),
  _debug(debug)
{

}

/**
 *
 **/
CommandProcMgr::~CommandProcMgr() 
{

}

/**
 *
 **/
CommandProcBase*
CommandProcMgr::init(const string &mod_name)
{
  CommandProcBase::StringColl str_coll;
  CommandProcBase::StringIter iter;

  if (mod_name == CommandProcShowArp::name()) {
    return new CommandProcShowArp();
  }
  else if (mod_name == CommandProcShowLeases::name()) {
    return new CommandProcShowLeases();
  }
  else if (mod_name == CommandProcShowNat::name()) {
    return new CommandProcShowNat();
  }
  else if (mod_name == CommandProcShowNTP::name()) {
    return new CommandProcShowNTP();
  }
  else if (mod_name == CommandProcShowFirewallRules::name()) {
    return new CommandProcShowFirewallRules();
  }
  else if (mod_name == CommandProcShowSerial::name()) {
    return new CommandProcShowSerial();
  }
  else if (mod_name == CommandProcShowBGPPeers::name()) {
    return new CommandProcShowBGPPeers();
  }
  else if (mod_name == CommandProcShowDHCPStat::name()) {
    return new CommandProcShowDHCPStat();
  }
  else if (mod_name == CommandProcShowVPN::name()) {
    return new CommandProcShowVPN();
  }
  else {
    return NULL;
  }
  return NULL;
}

vector<string>
CommandProcMgr::get_available_modules()
{
  vector<string> coll;
  coll.push_back(CommandProcShowArp::name());
  coll.push_back(CommandProcShowLeases::name());
  coll.push_back(CommandProcShowNat::name());
  coll.push_back(CommandProcShowNTP::name());
  coll.push_back(CommandProcShowFirewallRules::name());
  coll.push_back(CommandProcShowSerial::name());
  coll.push_back(CommandProcShowBGPPeers::name());
  coll.push_back(CommandProcShowDHCPStat::name());
  coll.push_back(CommandProcShowVPN::name());
  return coll;
}
