/**
 * Module: xrl_rl_cluster_node.hh
 *
 * Author: An-Cheng Huang
 * Date: 2007
 */

#include "rl_cluster_module.h"

#include "libxorp/xorp.h"
#include "libxorp/xlog.h"
#include "libxorp/debug.h"
#include "libxorp/ipvx.hh"
#include "libxorp/status_codes.h"
#include "librl_common/rl_command.hh"

#include "xrl_rl_cluster_node.hh"

XrlRLClusterNode::XrlRLClusterNode(EventLoop& eventloop,
                                   const string& class_name,
                                   const string& finder_hostname,
                                   uint16_t finder_port,
                                   const string& finder_target)
  : XrlStdRouter(eventloop, class_name.c_str(), finder_hostname.c_str(),
                 finder_port),
    XrlRlClusterTargetBase(&xrl_router()),
    _eventloop(eventloop),
    _class_name(xrl_router().class_name()),
    _instance_name(xrl_router().instance_name()),
    _finder_target(finder_target),
    _xrl_finder_client(&xrl_router()),
    _is_finder_alive(false),
    _status(PROC_STARTUP)
{
}

XrlRLClusterNode::~XrlRLClusterNode()
{
}

bool
XrlRLClusterNode::startup()
{
  _status = PROC_READY;
  return true;
}

XrlCmdError
XrlRLClusterNode::rl_cluster_0_1_shutdown_cluster()
{
  // dummy module. do nothing.
  _status = PROC_SHUTDOWN;
  return XrlCmdError::OKAY();
}

XrlCmdError
XrlRLClusterNode::rl_cluster_0_1_end_commit()
{
  // dummy module. do nothing.
  return XrlCmdError::OKAY();
}


/**
 *
 */
XrlCmdError 
XrlRLClusterNode::rl_cluster_0_1_delete_cluster(const string &dir)
{
  // dummy module. do nothing.
  return XrlCmdError::OKAY();
  UNUSED(dir);
}


//
// Finder-related events
//
/**
 * Called when Finder connection is established.
 *
 * Note that this method overwrites an XrlRouter virtual method.
 */
void
XrlRLClusterNode::finder_connect_event()
{
  _is_finder_alive = true;
}

/**
 * Called when Finder disconnect occurs.
 *
 * Note that this method overwrites an XrlRouter virtual method.
 */
void
XrlRLClusterNode::finder_disconnect_event()
{
  XLOG_ERROR("Finder disconnect event. Exiting immediately...");
  _is_finder_alive = false;
}

//
// XRL target methods
//

/**
 *  Get name of Xrl Target
 */
XrlCmdError
XrlRLClusterNode::common_0_1_get_target_name(// Output values
                                             string& name)
{
  name = my_xrl_target_name();
  return XrlCmdError::OKAY();
}

/**
 *  Get version string from Xrl Target
 */
XrlCmdError
XrlRLClusterNode::common_0_1_get_version(// Output values
                                         string& version)
{
  version = XORP_MODULE_VERSION;
  return XrlCmdError::OKAY();
}

/**
 *  Get status of Xrl Target
 */
XrlCmdError
XrlRLClusterNode::common_0_1_get_status(// Output values
                                        uint32_t& status, string& reason)
{
  reason = " ";
  status = _status;

  if (PROC_SHUTDOWN == _status) {
    _status = PROC_DONE;
  }

  return XrlCmdError::OKAY();
}

/**
 *  Request clean shutdown of Xrl Target
 */
XrlCmdError
XrlRLClusterNode::common_0_1_shutdown()
{
  // dummy module. do nothing.
  return XrlCmdError::OKAY();
}

/**
 *  Announce target birth to observer.
 *
 *  @param target_class the target class name.
 *
 *  @param target_instance the target instance name.
 */
XrlCmdError
XrlRLClusterNode::finder_event_observer_0_1_xrl_target_birth(
    // Input values
    const string& target_class,
    const string& target_instance)
{
  // dummy module. do nothing.
  return XrlCmdError::OKAY();
  UNUSED(target_class);
  UNUSED(target_instance);
}

/**
 *  Announce target death to observer.
 *
 *  @param target_class the target class name.
 *
 *  @param target_instance the target instance name.
 */
XrlCmdError
XrlRLClusterNode::finder_event_observer_0_1_xrl_target_death(
    // Input values
    const string& target_class,
    const string& target_instance)
{
  // dummy module. do nothing.
  return XrlCmdError::OKAY();
  UNUSED(target_class);
  UNUSED(target_instance);
}

