/*
 * Module: netlink_rt_entry.hh
 *
 * **** License ****
 * Version: VPL 1.0
 *
 * The contents of this file are subject to the Vyatta Public License
 * Version 1.0 ("License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.vyatta.com/vpl
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
 * the License for the specific language governing rights and limitations
 * under the License.
 *
 * This code was originally developed by Vyatta, Inc.
 * Portions created by Vyatta are Copyright (C) 2005, 2006, 2007 Vyatta, Inc.
 * All Rights Reserved.
 *
 * Author: Stig Thormodsrud
 * Date: 2007
 * Description:
 *
 * **** End License ****
 *
 */
#ifndef __RIB_NETLINK_RT_ENTRY_HH__
#define __RIB_NETLINK_RT_ENTRY_HH__

#include "fea/netlink_socket.hh"
#include "fea/netlink_socket_utils.hh"


#define MAX_RTMSG 4        // RTA_DST, RTA_GATEWAY, RTA_OIF, RTA_PRIORITY
#define MAX_RTMSG_DATA 16  // sizeof(ipv6_addr)
#define MAX_NETLINK_BUFSIZ (sizeof(struct nlmsghdr)           + \
                            sizeof(struct rtmsg)              + \
                            MAX_RTMSG * sizeof(struct rtattr) + \
			    MAX_RTMSG * MAX_RTMSG_DATA)

/**
 * @short class for Netlink Route Entries
 * 
 * NelinkRouteEntry is the class for access to Netlink to add 
 * and delete route entries in the kernel FIB.
 */
class NetlinkRouteEntry: public NetlinkSocket {
public:
    NetlinkRouteEntry(EventLoop& eventloop);
    ~NetlinkRouteEntry(void);
    bool start(void);
    bool stop(void);
    
    template <typename A>
    bool add_entry(const IPRouteEntry<A>& route);
    
    template <typename A>
    bool delete_entry(const IPRouteEntry<A>& route);

private:

    //
    // Global netlink buffer.  This assumes single threaded.
    //
    union {
        uint8_t		data[MAX_NETLINK_BUFSIZ];
        struct nlmsghdr	nlh;
    } _buffer;

    bool                 _is_running;
    uint32_t             _pid;
    NetlinkSocketReader	 _ns_reader;
};


#endif // __RIB_NETLINK_RT_ENTRY_HH__
