#include <string>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <stdio.h>
#include <iostream>
#include <stdlib.h>
#include <errno.h>
#include <string.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/un.h>

#include "config.h"

#include "libxorp/ipv4.hh"

#include "xrl/targets/show_routes_base.hh"
#include "common.hh"

#include <librl_common/rl_command.hh>

using namespace std;


#define SOCK_PATH "/tmp/route_display"

void
usage()
{
  printf("route_display_client:\n");
  printf("-d               detail\n");
  printf("-b               brief\n");
  printf("-e               exact\n");
  printf("-c               match\n");
  printf("-r <rt proto>    route protocol\n");
  printf("-m <mask length> mask length\n");
  printf("-n <next hop>    next hop\n");
  printf("-p <prefix>      prefix\n");
}

int 
main(int argc, char *argv[])
{
  int s, t, len;
  struct sockaddr_un remote;
  char str[100];
  int mode = 0;
  string filter = "0.0.0.0/0";
  int ch;
  int filt_mode = PREFIX_FILTER;
  
  while ((ch = getopt(argc, argv, "dber:m:n:p:")) != -1) {
    switch (ch) {
    case 'd':
      mode |= DETAIL;
      break;
    case 'b':
      mode |= BRIEF;
      break;
    case 'e':
      mode |= EXACT;
      break;
    case 'c':
      mode |= MATCH; //used for longest prefix match
      break;
    case 'r':
      filt_mode = PROTO_FILTER;
      if (optarg != NULL) {
	filter = optarg;
      }
      break;
    case 'm':
      filt_mode = MASK_FILTER;
      if (optarg != NULL) {
	filter = optarg;
      }
      break;
    case 'n':
      filt_mode = NEXTHOP_FILTER;
      if (optarg != NULL) {
	filter = optarg;
      }
      break;
    case 'p':
      filt_mode = PREFIX_FILTER;
      if (optarg != NULL) {
	filter = optarg;
	try { //test for fully defined prefix
	  IPv4Net foo(filter.c_str());
	}
	catch (...) {
	  try { //test for ip only
	    IPv4 foo(filter.c_str());
	    mode |= MATCH; //automatically set mode to match
	  }
	  catch (...) {
	    fprintf(stderr, "bad prefix argument\n");
	    exit(0);
	  }
	}

      } 
      else {
	filter = "0.0.0.0/0";
      }
      //      cout << "filter: " << filter << endl;
      break;
    }
  }

  mode |= filt_mode;

  bool found = false;
  string server = SBINDIR "/route_display_server";
  string find_cmd("ps -o cmd -C route_display_server");
  FILE *f = popen(find_cmd.c_str(), "r");
  if (f) {
    char buf[512];
    while(fgets(buf, 512, f) != NULL) { 
      //      cout << "comparing: " << server << " <to> " << buf << endl;
      if (string(buf).find(server) != string::npos) {
	//	cout << "MATCH!" << endl;
	found = true;
	break;
      }
    }
    pclose(f);
  }

  //check for server process and restart if not found
  if (!found) {
    rl_command::execute(SBINDIR "/route_display_server.init restart > /dev/null 2 > /dev/null");
    sleep(1); 
  }

  char buf[512];
  sprintf(buf, "%d", mode);
  string message = string(buf) + ":" + filter;


  if ((s = socket(AF_UNIX, SOCK_STREAM, 0)) == -1) {
    perror("socket");
    exit(1);
  }

  message += string(":");

  //  cout << "sending from client: " << message << endl;

  
  remote.sun_family = AF_UNIX;
  strcpy(remote.sun_path, SOCK_PATH);
  len = strlen(remote.sun_path) + sizeof(remote.sun_family);
  if (connect(s, (struct sockaddr *)&remote, len) == -1) {
    perror("connect");
    close(s);
    exit(1);
  }

  if (send(s, message.c_str(), message.length(), 0) == -1) {
    perror("send");
    close(s);
    exit(1);
  }
  
  while ((t=recv(s, str, 100, 0)) > 0) {
    str[t] = '\0';
    printf("%s", str);
    if (t < 0) {

      char buf[256];
      sprintf(buf, "Error on recv: %d, %d\n", t, errno);
      D(buf);

      close(s);
      return 0;
    }
  }
  printf("\n");
  close(s);

  return 0;
}
