%{
// XXX: this whole parsing is becoming a mess... Once we finalize how to test
// policy and what it should look like, it needs a re-write.

#include "libxorp/xorp.h"

#include "policy/test/compilepolicy.hh"
#include "policy/test/compilepolicy_parser.h"
#include "policy/common/policy_utils.hh"
#include <sstream>

void compilepolicy_scanner_error(const char *);
extern int compilepolicy_parser_parse(void);

namespace {
	unsigned _yy_lineno;
	string _yy_last_err;
}

%}

%option noyywrap
%option nounput
%option never-interactive
%x STR BLOCK

RE_IPV4_BYTE 25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?
RE_IPV4 {RE_IPV4_BYTE}\.{RE_IPV4_BYTE}\.{RE_IPV4_BYTE}\.{RE_IPV4_BYTE}
RE_IPV4_PREFIXLEN 3[0-2]|[0-2]?[0-9]
RE_IPV4NET {RE_IPV4}\/{RE_IPV4_PREFIXLEN}

RE_H4 [a-fA-F0-9]{1,4}
RE_H4_COLON {RE_H4}:
RE_LS32 (({RE_H4}:{RE_H4})|{RE_IPV4})
RE_IPV6_P1      {RE_H4_COLON}{6}{RE_LS32}
RE_IPV6_P2      ::{RE_H4_COLON}{5}{RE_LS32}
RE_IPV6_P3      ({RE_H4})?::{RE_H4_COLON}{4}{RE_LS32}
RE_IPV6_P4      ({RE_H4_COLON}{0,1}{RE_H4})?::{RE_H4_COLON}{3}{RE_LS32}
RE_IPV6_P5      ({RE_H4_COLON}{0,2}{RE_H4})?::{RE_H4_COLON}{2}{RE_LS32}
RE_IPV6_P6      ({RE_H4_COLON}{0,3}{RE_H4})?::{RE_H4_COLON}{1}{RE_LS32}
RE_IPV6_P7      ({RE_H4_COLON}{0,4}{RE_H4})?::{RE_LS32}
RE_IPV6_P8      ({RE_H4_COLON}{0,5}{RE_H4})?::{RE_H4}
RE_IPV6_P9      ({RE_H4_COLON}{0,6}{RE_H4})?::
RE_IPV6 	{RE_IPV6_P1}|{RE_IPV6_P2}|{RE_IPV6_P3}|{RE_IPV6_P4}|{RE_IPV6_P5}|{RE_IPV6_P6}|{RE_IPV6_P7}|{RE_IPV6_P8}|{RE_IPV6_P9}
RE_IPV6_PREFIXLEN 12[0-8]|1[01][0-9]|[0-9][0-9]?
RE_IPV6NET      {RE_IPV6}\/{RE_IPV6_PREFIXLEN}

%%

\"		BEGIN(STR);

"{"		return YY_LBRACE;

"}"		return YY_RBRACE;

"source"	BEGIN(BLOCK); return YY_SOURCE;
"dest"		BEGIN(BLOCK); return YY_DEST;
"action"	BEGIN(BLOCK); return YY_ACTION;

<BLOCK>";"	{ return YY_SEMICOLON; }
<BLOCK>[[:blank:]\n]*"{"[[:blank:]\n]*	{  
	 	  _yy_lineno += policy_utils::count_nl(compilepolicy_scanner_text);
	   	  return YY_LBRACE; 
					}
<BLOCK>[[:blank:]\n]*"}"[[:blank:]\n]*	{
		  BEGIN(INITIAL);
		  _yy_lineno += policy_utils::count_nl(compilepolicy_scanner_text);
		  return YY_RBRACE; 
					}

<BLOCK>[^;{}]*	{ compilepolicy_parser_lval.c_str = strdup(compilepolicy_scanner_text);
		  _yy_lineno += policy_utils::count_nl(compilepolicy_scanner_text);
		  return YY_STATEMENT;
		}

<STR>\"		BEGIN(INITIAL);
<STR>[^\"]+	{ compilepolicy_parser_lval.c_str = strdup(compilepolicy_scanner_text); 
		  _yy_lineno += policy_utils::count_nl(compilepolicy_scanner_text);
		  return YY_STR;
		}

{RE_IPV4}	{
		  compilepolicy_parser_lval.c_str = strdup(compilepolicy_scanner_text);
		  return YY_IPV4;
		}

{RE_IPV4NET}	{
		  compilepolicy_parser_lval.c_str = strdup(compilepolicy_scanner_text);
		  return YY_IPV4NET;
		}
		
{RE_IPV6}	{
		  compilepolicy_parser_lval.c_str = strdup(compilepolicy_scanner_text);
		  return YY_IPV6;
		}

{RE_IPV6NET}	{
		  compilepolicy_parser_lval.c_str = strdup(compilepolicy_scanner_text);
		  return YY_IPV6NET;
		}

"term"		return YY_TERM;

"policy\-statement"	return YY_POLICY_STATEMENT;

"SET"		return YY_SET;

"import"	return YY_IMPORT;
"export"	return YY_EXPORT;

[[:alpha:]][[:alnum:]_]*	{ compilepolicy_parser_lval.c_str = strdup(compilepolicy_scanner_text);
				  return YY_ID;
				}  

;		return YY_SEMICOLON;

"\n"		_yy_lineno++;

[[:blank:]]+	/* eat blanks */

.		{ compilepolicy_scanner_error("Unknown character"); }

%%

void compilepolicy_scanner_error(const char *m) {
        ostringstream oss;

        oss << "Error on line " <<  _yy_lineno << ": " << m;

        _yy_last_err = oss.str();
}


// XXX: no memory management [a lot of leaks... for simplicy]
int
do_parsing(const string& conf, string& outerr) {
        YY_BUFFER_STATE yybuffstate = yy_scan_string(conf.c_str());

        _yy_last_err = "No error";
        _yy_lineno =1;

        int res = compilepolicy_parser_parse();

	yy_delete_buffer(yybuffstate);
        outerr = _yy_last_err;

        return res;
}
