#ifndef __POLICY_KEY_HH__
#define __POLICY_KEY_HH__

#include <string>


class PolicyKey {
public:
    PolicyKey(const std::string &protocol, const std::string &label);

    bool
    operator<(const PolicyKey &key) const;

    bool
    is_global() const {return _label.empty();}

    std::string
    protocol() const {return _protocol;}
    
    std::string
    label() const {return _label;}

private:
    std::string _protocol;
    std::string _label;
};

#endif //__POLICY_KEY_HH__
