%{
#include "libxorp/xorp.h"

#include <vector>

#include "policy/common/varrw.hh"
#include "policy/common/element_factory.hh"
#include "policy/common/operator.hh"

#include "policy/backend/policy_backend_parser.hh"
#include "policy/backend/instruction.hh"
#include "policy/backend/term_instr.hh"
#include "policy/backend/policy_instr.hh"


extern int backend_scanner_lex(void);
#define backend_parser_lex  backend_scanner_lex

extern void backend_scanner_error(const char*);
#define backend_parser_error  backend_scanner_error

using namespace policy_backend_parser;

static ElementFactory _ef;

%}

%union {
	const char* c_str;
};

%token <c_str> YY_ARG
%token YY_NEWLINE YY_BLANK
%token YY_POLICY_START YY_POLICY_END YY_TERM_START YY_TERM_END
%token YY_PUSH YY_PUSH_SET
%token YY_EQ YY_NE YY_LT YY_GT YY_LE YY_GE
%token YY_NOT YY_AND YY_OR YY_XOR YY_HEAD YY_CTR YY_NE_INT
%token YY_ADD YY_SUB YY_MUL
%token YY_ONFALSE_EXIT
%token YY_REGEX
%token YY_LOAD YY_STORE
%token YY_ACCEPT YY_REJECT
%token YY_SET
%%

program:
	  program policy
	| program set  
	| /* empty */
	;

set:
	  YY_SET YY_ARG YY_ARG YY_ARG YY_NEWLINE 
	  {
	  	// XXX: doesn't delete old
		(*_yy_sets)[$3] = _ef.create($2, $4);
		free((void*)$2); free((void*)$3); free((void*)$4);
	  }
	;  

policy:	  YY_POLICY_START YY_ARG YY_NEWLINE terms YY_POLICY_END YY_NEWLINE {
			PolicyInstr* pi = new PolicyInstr($2,_yy_terms);
			_yy_terms = new vector<TermInstr*>();
			_yy_policies->push_back(pi);
			free((void*)$2);
			}
	;

terms:
	  terms YY_TERM_START YY_ARG YY_NEWLINE statements YY_TERM_END YY_NEWLINE {
	  
			TermInstr* ti = new TermInstr($3,_yy_instructions);
			_yy_instructions = new vector<Instruction*>();
			_yy_terms->push_back(ti);
			free((void*)$3);
			}
	| /* empty */		
	;

statements: 
	  statements statement YY_NEWLINE
	| /* empty */
	;


statement:
	  YY_PUSH YY_ARG YY_ARG {
	  			Instruction* i = new Push(_ef.create($2,$3));
				_yy_instructions->push_back(i);
				free((void*)$2); free((void*)$3);
	  			}
	| YY_PUSH_SET YY_ARG	{
				_yy_instructions->push_back(new PushSet($2));
				free((void*)$2);
				}
	
	| YY_ONFALSE_EXIT	{
				_yy_instructions->push_back(new OnFalseExit());
				}

	| YY_LOAD YY_ARG	{
				char* err = NULL;
				bool is_error = false;
				VarRW::Id id = strtoul($2, &err, 10);
				if ((err != NULL) && (*err != '\0'))
				    is_error = true;
				free((void*)$2);
				if (is_error) {
					yyerror("Need numeric var ID");
					YYERROR;
				}
				_yy_instructions->push_back(new Load(id));
				}

	| YY_STORE YY_ARG	{
				char* err = NULL;
				bool is_error = false;
				VarRW::Id id = strtoul($2, &err, 10);
				if ((err != NULL) && (*err != '\0'))
				    is_error = true;
				free((void*)$2);
				if (is_error) {
					yyerror("Need numeric var ID");
					YYERROR;
				}
				_yy_instructions->push_back(new Store(id));
				}

	| YY_ACCEPT		{ _yy_instructions->push_back(new Accept()); }
	| YY_REJECT		{ _yy_instructions->push_back(new Reject()); }

	| YY_EQ		{ _yy_instructions->push_back(new NaryInstr(new OpEq)); }
	| YY_NE		{ _yy_instructions->push_back(new NaryInstr(new OpNe)); }
	| YY_LT		{ _yy_instructions->push_back(new NaryInstr(new OpLt)); }
	| YY_GT		{ _yy_instructions->push_back(new NaryInstr(new OpGt)); }
	| YY_LE		{ _yy_instructions->push_back(new NaryInstr(new OpLe)); }
	| YY_GE		{ _yy_instructions->push_back(new NaryInstr(new OpGe)); }

	| YY_NOT	{ _yy_instructions->push_back(new NaryInstr(new OpNot)); }
	| YY_AND	{ _yy_instructions->push_back(new NaryInstr(new OpAnd)); }
	| YY_XOR	{ _yy_instructions->push_back(new NaryInstr(new OpXor)); }
	| YY_OR		{ _yy_instructions->push_back(new NaryInstr(new OpOr)); }

	| YY_ADD	{ _yy_instructions->push_back(new NaryInstr(new OpAdd)); }
	| YY_SUB	{ _yy_instructions->push_back(new NaryInstr(new OpSub)); }
	| YY_MUL	{ _yy_instructions->push_back(new NaryInstr(new OpMul)); }
	| YY_HEAD	{ _yy_instructions->push_back(new NaryInstr(new OpHead));}
	| YY_CTR	{ _yy_instructions->push_back(new NaryInstr(new OpCtr));}
	| YY_NE_INT	{ _yy_instructions->push_back(new NaryInstr(new OpNEInt));}
	| YY_REGEX	{ _yy_instructions->push_back(new NaryInstr(new OpRegex));}
	;  

%%
