// -*- c-basic-offset: 4; tab-width: 8; indent-tabs-mode: t -*-

// Copyright (c) 2001-2007 International Computer Science Institute
//
// Permission is hereby granted, free of charge, to any person obtaining a
// copy of this software and associated documentation files (the "Software")
// to deal in the Software without restriction, subject to the conditions
// listed in the XORP LICENSE file. These conditions include: you must
// preserve this copyright notice, and you cannot mention the copyright
// holders in advertising related to the Software without their permission.
// The Software is provided WITHOUT ANY WARRANTY, EXPRESS OR IMPLIED. This
// notice is a summary of the XORP LICENSE file; the license in that file is
// legally binding.

#ident "$XORP$"

/*
 * Note: this file originally auto-generated by mib2c using
 *        : mib2c.int_watch.conf,v 5.0 2002/04/20 07:30:13 hardaker Exp $
 */

#include "xorp_netsnmp_module.h"

#include "fixconfigs.h"

#include "libxorp/xorp.h"

#include "xorpevents.hh"
#include "ospf_mib_1850.hh"

// Local variables
#ifndef	SNMP_NO_DEBUGGING
static const char * mib_mod_name="ospf_mib_1850";
#endif
static PeriodicTimerCallback ptcb;
static XorpTimer * pXtospf = NULL;
SnmpEventLoop& eventloop = SnmpEventLoop::the_instance(); 

// Local functions
static bool ospf_mib_callback() {
    static int i;
    DEBUGMSGTL((mib_mod_name, "Counting...%d\n", i));
    if (-1 == ++i) return false;
    return true;
}


void
init_ospf_mib_1850 (void)
{
    DEBUGMSGTL((mib_mod_name, "Initializing...\n"));
    DEBUGMSGTL((mib_mod_name, "Creating periodic event...\n"));
    ptcb = callback(ospf_mib_callback);
    pXtospf = new XorpTimer;
    *pXtospf = eventloop.new_periodic_ms(1000, ptcb);
    DEBUGMSGTL((mib_mod_name, "Exporting events...\n"));
}

void 
deinit_ospf_mib_1850 (void) 
{
    DEBUGMSGTL((mib_mod_name, "Unloading...\n"));
    delete pXtospf;
    pXtospf= NULL;
}
