/*
 * Module: rl_syslog.c
 *
 * **** License ****
 * Version: VPL 1.0
 *
 * The contents of this file are subject to the Vyatta Public License
 * Version 1.0 ("License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.vyatta.com/vpl
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
 * the License for the specific language governing rights and limitations
 * under the License.
 *
 * This code was originally developed by Vyatta, Inc.
 * Portions created by Vyatta are Copyright (C) 2005, 2006, 2007 Vyatta, Inc.
 * All Rights Reserved.
 *
 * Author: Michael Larson
 * Date: 2005
 * Description:
 *
 * **** End License ****
 *
 */
#include <stdio.h>
#include <string.h>
#include <sys/klog.h>
#include <unistd.h>
#include <linux/unistd.h>
#include <syslog.h>
#include "xorp.h"
#include "rl_syslog.h"

//The prefix that is to append all log messages
//static char rl_syslog_log_prefix[255];

int 
rl_syslog_callback(void *data, const char *buffer)
{
    rl_syslog_log(buffer);
    UNUSED(data);
    return 0;
}

void
rl_syslog_log(const char *buffer)
{
  int priority = rl_syslog_get_priority(buffer);

  //this is where we'll do the logging to syslog
  syslog(priority, "%s", buffer);
}

/**
 * WARNING: This file is dependent on changes to the xorp logging
 * levels. Any changes on the xorp side may break the code below!
 */
int
rl_syslog_get_priority(const char* buffer)
{
  if (strstr(buffer, "FATAL") != NULL) {
    return LOG_ALERT | LOG_LOCAL7;
  }
  else if (strstr(buffer, "ERROR") != NULL) {
    return LOG_ERR | LOG_LOCAL7;
  }
  else if (strstr(buffer, "WARNING") != NULL) {
    return LOG_WARNING | LOG_LOCAL7;
  }
  else if (strstr(buffer, "INFO") != NULL) {
    return LOG_INFO | LOG_LOCAL7;
  }
  else if (strstr(buffer, "TRACE") != NULL) {
    return LOG_DEBUG | LOG_LOCAL7;
  }

  return LOG_INFO | LOG_LOCAL7;
}
